--
-- Type: TABLE; Owner: TM_CZ; Name: AZ_TEST_STEP_RUN
--
 CREATE TABLE "TM_CZ"."AZ_TEST_STEP_RUN" 
  (	"TEST_STEP_RUN_ID" NUMBER(18,0) NOT NULL ENABLE, 
"TEST_RUN_ID" NUMBER(18,0) NOT NULL ENABLE, 
"TEST_ID" NUMBER(18,0) NOT NULL ENABLE, 
"START_DATE" DATE, 
"END_DATE" DATE, 
"STATUS" VARCHAR2(20 BYTE), 
"SEQ_ID" NUMBER, 
"PARAM1" VARCHAR2(4000 BYTE), 
 CONSTRAINT "AZ_TEST_STEP_RUN_PK" PRIMARY KEY ("TEST_STEP_RUN_ID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: TM_CZ; Name: TRG_AZ_TEST_STEP_RUN_ID
--
  CREATE OR REPLACE TRIGGER "TM_CZ"."TRG_AZ_TEST_STEP_RUN_ID" 
before insert on AZ_TEST_STEP_RUN    for each row 
begin     
    if inserting then       
      if :NEW.TEST_STEP_RUN_ID is null then          
        select SEQ_CZ_TEST.nextval into :NEW.TEST_STEP_RUN_ID from dual;       
      end if;   
    end if; 
  end;







/
ALTER TRIGGER "TM_CZ"."TRG_AZ_TEST_STEP_RUN_ID" ENABLE;
 
--
-- Type: REF_CONSTRAINT; Owner: TM_CZ; Name: AZ_TEST_STEP_RUN_CZ_JOB_FK1
--
ALTER TABLE "TM_CZ"."AZ_TEST_STEP_RUN" ADD CONSTRAINT "AZ_TEST_STEP_RUN_CZ_JOB_FK1" FOREIGN KEY ("TEST_ID")
 REFERENCES "TM_CZ"."CZ_TEST" ("TEST_ID") ENABLE;

--
-- Type: REF_CONSTRAINT; Owner: TM_CZ; Name: AZ_TST_STEP_RUN_AZ_TEST_RU_FK1
--
ALTER TABLE "TM_CZ"."AZ_TEST_STEP_RUN" ADD CONSTRAINT "AZ_TST_STEP_RUN_AZ_TEST_RU_FK1" FOREIGN KEY ("TEST_RUN_ID")
 REFERENCES "TM_CZ"."AZ_TEST_RUN" ("TEST_RUN_ID") ENABLE;

