\name{setMKLthreads}
\alias{setMKLthreads}
\alias{getMKLthreads}
\title{Set the Number of Threads for Math Kernel Library}
\description{Set (or get) the maximum number of threads that can be started by the Math
Kernel Library BLAS. This should be less than or equal to the number of 
processing cores on your computer. }
\usage{
setMKLthreads(n)
getMKLthreads()
}
\arguments{
  \item{n}{an integer specifying the maximum number of threads. If missing, all available processors will be used.}
}
\details{Revolution R includes the Intel Math Kernel Library (\url{https://software.intel.com/en-us/intel-mkl}). 
This library provides Basic Linear Algebra Subroutines (BLAS) and Lapack subroutines.}
\examples{

# by default using all cores available
getMKLthreads() 
setMKLthreads(1)
getMKLthreads()
setMKLthreads()
getMKLthreads()
setMKLthreads(1)
try (setMKLthreads(1000), silent=TRUE)
getMKLthreads()
}
\keyword{programming}
