".onLoad" <- function(libname, pkgname){
  # check first for size of Rblas.dll; if too small to be MKL, throw an error
  msgintro <- paste("To use RevoUtilsMath you must first install the MKL Math Library.\n",
               "Visit http://mran.revolutionanalytics.com/download.\n",
			   "If you have previously installed the MKL Math Library,")
  winmsg <- paste(msgintro,  "remove it using Add/Remove Programs, then re-install.", sep="\n")
  linmsg <- paste(msgintro,  "remove it and then re-install.", sep="\n")
  if (identical(.Platform$OS.type, "windows") && file.info(file.path(R.home(), "bin", "x64", "Rblas.dll"))$size < 500000)
	stop(winmsg)
  if (identical(.Platform$OS.type, "unix") && file.info(file.path(R.home(), "lib", "libRblas.so"))$size < 500000)
    stop(linmsg)
  tryCatch(library.dynam("RevoUtilsMath", pkgname, libname),
      error=function(e) {
          if (any(nzchar(e$message))) {
              Revo.warning(e$message, ignore=isUnix())
          } else {
              Revo.warning("Unknown problem in call to library.dynam", ignore=isUnix())
          }
      })
  if (!isOSX()) 
  	.Default.Revo.Threads <<- getMKLthreads()
}

.Last.lib <- function (libpath){
  tryCatch(library.dynam.unload("RevoUtilsMath", libpath),
      error=function(e) {
          if (any(nzchar(e$message))) {
              Revo.warning(e$message, ignore=isUnix())
          } else {
              Revo.warning("Unknown problem in call to library.dynam", ignore=isUnix())
          }
      })
 }

# A placeholder for .Default.Revo.Threads: 
# It will be replaced when RevoUtilsMath.dll is available
.Default.Revo.Threads <- -1L 
