source("helper.R")
library("GSVA")
library("ggplot2")
library("genefilter")
library("gplots")
library("RColorBrewer")
library("GSEABase")
library("hugene10sttranscriptcluster.db")
library("hgu133plus2.db") #affy
library("limma")
library("plyr")
library("DT")

load("data/Methodology.paper.signature.details.r")


shinyServer(function(input, output) {

  
 
  
  
  
    
  output$chooseDataset<-renderUI({  
    # if (is.null(input$gsv) || input$gsv==0){
    if(!is.null(gsvaInput())) return()
      selectInput("dataset", "Choose a dataset:", 
                  choices = names(esets))
      # }
  })


  
output$displaySetName<-renderUI({  

  if(!is.null(gsvaInput())) p(gsub(".Expr","",input$dataset))
  
})  
  
#check if  input$dataset is null/ if not check if user has uploaded signatures/
#if not return the ES set in esets[[input$dataset]], if yes return exprsets[[input$dataset]]
dataInput <- reactive({
  
  if(is.null(input$dataset)) return(NULL)
  if(is.null(gsetInput())) return(esets[[input$dataset]])
  
  if(!is.null(gsetInput())) return(exprsets[[input$dataset]])
  
})



#datasetInput is the ES data.frame used by all functions below / if gsvaInput() is NULL

  datasetInput <-reactive({
  #if the user has not uploaded gene set (gsvaInput is null) dataInput is returned
    if(is.null(gsvaInput())){return(dataInput())}else{return(gsvaInput())}
  #otherwise gsvaInput is returned  
  })
  
#web link
  output$pmid <- renderUI({  
    
    if(is.null(input$dataset)) return(NULL)
    
      # if(is.na(pmatch("gse",input$dataset))) return(NULL) 
    if(input$selectedTab == "Signatures") return(NULL)
    
      a(paste("Go to",input$dataset,"GEO","page"), href = paste("http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=", 
                                                  input$dataset,sep=""),target="_blank",
                                                                style="position:relative;top:-5px")  
  })       




  ######################################################   work in progress ##########################################
  
  values <- reactiveValues(gene_list = NA)
  
  observe({
    if(is.null(input$Gene_list_submit)) return()
    if(input$Gene_list_submit > 0) {
      
      values$gene_list <- isolate(input$gene_list)
      
    }
    
  })
  
  # output$text <- renderText({values$gene_list})
  
  gsetInput <- reactive({ 
    
     if(is.na(values$gene_list)) return(NULL)
    
    
    isolate({
      
      usergsc<-read_signatures(values$gene_list)
      return(usergsc)
    })
  })
  
  output$show_geneset_input<-renderUI({
        
    if(is.null(gsetInput)) return()
    
       if(!is.null(gsvaInput())) return()
       if(is.null(datasetInput())) return()
       if(input$selectedTab == "Signatures" || input$selectedTab =="Summary" || input$selectedTab == "Table") return(NULL)

      list(
          textInput("gene_list", "Input gene list for GSVA (gene Symbols)", ""),
        actionButton("Gene_list_submit", "Submit gene list")
      )

  })
  
  output$display_warning<-renderText({
    
    
    if (is.null(gsetInput())) return(NULL)
    if(!is.null(gsvaInput())) return()
    
    if (sum(is.element(strsplit(values$gene_list," ")[[1]],exprsets.gene.symbols[[input$dataset]]))==0) {
      warning_text<-paste("No genes found matching the microarray platfrom")
    }else if(sum(is.element(strsplit(values$gene_list," ")[[1]],exprsets.gene.symbols[[input$dataset]]))>0 & 
             sum(is.element(strsplit(values$gene_list," ")[[1]],exprsets.gene.symbols[[input$dataset]]))<length(strsplit(values$gene_list," ")[[1]]) ){
    missing.genes<-geneIds(gsetInput()[[1]])[!is.element(geneIds(gsetInput()[[1]]),exprsets.gene.symbols[[input$dataset]])]
    missing.genes<-paste('The following genes are not on the platform: ',paste(missing.genes,collapse = ', '))
    }else{
        return()
      }
  })
  
  
  # 
  # 
  # output$show_submit_Button<-renderUI({
  #   if (is.null(gsetInput())) return(NULL)
  #   if (!is.null(gsvaInput())) return(NULL)
  #    if(is.null(input$gene_list)) return(NULL)
  #   isolate({
  #   actionButton("Gene_list_submit", "Submit gene list")
  #   })
  # 
  # })
  ######################################################    END   #####################################################
  
 
  ########################################### ORIGINAL  #######################################
   #User-Upload gene set collection
  # gsetInput <- reactive({ 
  #   
  #   if(is.null(input$gset)) return(NULL)
  #   
  #   isolate({
  #     
  #     genesetFile <- input$gset    
  #     usergsc<-read_signatures(genesetFile[[4]])
  #     return(usergsc)
  #   })
  # })
  
  # output$show_geneset_upload<-renderUI({
  #   if(!is.null(gsvaInput())) return()
  #   if(is.null(datasetInput())) return()
  #   if(input$selectedTab == "Signatures") return(NULL)
  #   
  #   fileInput("gset",HTML('<a data-toggle="tooltip" title="Upload a txt file with one signature per row,
  #                         starting with the signature name, followed by gene symbols,
  #                         separated by spaces" style = "color:gray;"><h6>Upload a geneSetCollection 
  #                           <img src="info_512pxGREY.png" align = "top">
  #                         </h6></a>'),
  #             multiple = FALSE, accept = NULL)
  # 
  #   
  # })
  
  ########################################### END OF ORIGINAL  #######################################


  
#if user has uploaded own gene signatures - show gene Filter
output$filter_var <- renderUI({
  
  if (is.null(gsetInput())) return(NULL)
  if (!is.null(gsvaInput())) return(NULL)
  if (sum(is.element(strsplit(values$gene_list," ")[[1]],exprsets.gene.symbols[[input$dataset]]))==0) return()
  sliderInput("varCutoff", 
              "Variance cutoff:", 
              min = 0,
              max = 0.5,
              step = 0.05,
              value = 0)
  
})



#if user has uploaded own gene signatures - show Apply GSVA button
output$gsva_button <- renderUI({
  
  if (is.null(gsetInput())) return(NULL)
  if (!is.null(gsvaInput())) return(NULL)
  if (sum(is.element(strsplit(values$gene_list," ")[[1]],exprsets.gene.symbols[[input$dataset]]))==0) return()
    actionButton("gsv", "Apply GSVA")
})

#Apply GSVA - when the user uploads signatures!
gsvaInput <- reactive({ 
  
  if(is.null(input$gsv) || input$gsv==0)  return(NULL)
  
  isolate({
    
    esdf<-applyGSVA(dataInput(),gsetInput(),input$varCutoff)
    if (is.null(esdf)) return()
    fesdf<-formatesdf(esdf) 
    return(fesdf) 
  })
})


######################################### BOXPLOT ###########################################  
#Ask user to select signature to visualise
output$choose_signature <- renderUI({  
  
  if(input$selectedTab != "BoxPlot" && input$selectedTab != "Signatures") return()  
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return()
  if(is.null(gsvaInput()) && is.null(gsetInput())) {
  if(input$selectedTab == "Signatures") return()
    
    ch <- names(datasetInput())[sapply(datasetInput(),is.numeric)]

    selectInput("signatures_set", "Select Signature/variable to plot", 
          
             choices  = ch,
            selected = ch[1],
              multiple = FALSE)
  }else if(!is.null(gsvaInput()) && !is.null(gsetInput())){
   
    selectInput("signatures_set", "Select Signature", 
                choices  = names(gsetInput()),
                selected = names(gsetInput())[1],
                multiple = FALSE)

  }
})    


#Ask user to select the column containing the cohorts (needed for boxplot & plot)
output$choose_cohort_column <- renderUI({
 
  if(is.null(datasetInput())) return()
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return()

      if(input$selectedTab != "BoxPlot" && input$selectedTab != "Plot" && input$selectedTab != "HeatMap") return()

    col_names <- colnames(datasetInput())      
    factor_cols <- col_names[grep(1,as.numeric(lapply(datasetInput(),is.factor)))]
    factor_cols=factor_cols[2:length(factor_cols)]
 
  #remove those holding a different value in each row (clearly irrelevant to analysis!)
  factor_cols<-factor_cols[lapply(lapply(datasetInput()[factor_cols],unique)
                                  ,length)!=nrow(datasetInput())]
  
    # Create the select cohort box
    
    selectInput("cohort", "Select cohort column", 
              choices  = factor_cols,
              selected = factor_cols[1])
})

#Ask user to select a condition for color (default=cohort/above)
output$choose_color_condition <- renderUI({
  
  if(is.null(datasetInput())) return()
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return()
  
  if(input$selectedTab != "BoxPlot" && input$selectedTab != "Plot") return()
  if(is.null(input$cohort)) return()
  col_names <- colnames(datasetInput())      
  factor_cols <- col_names[grep(1,as.numeric(lapply(datasetInput(),is.factor)))]
  factor_cols=factor_cols[2:length(factor_cols)]
  
  #remove those holding a different value in each row (clearly irrelevant to analysis!)
 
  factor_cols<-factor_cols[lapply(lapply(datasetInput()[factor_cols],unique)
                                  ,length)!=nrow(datasetInput())]
  # Create the select cohort box
  
  selectInput("color", "Select color condition", 
              choices  = factor_cols,
              selected = input$cohort)
})







#select control group
output$choose_control <- renderUI({
  
  if(input$selectedTab != "BoxPlot" || is.null(input$cohort)) return()
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return()

  if (!is.element(input$cohort,colnames(datasetInput()))) return()
  control_choices <- as.character(sort(unique(datasetInput()[input$cohort])[[1]]))
 
  # choose control
  selectInput("control", "Select control group", 
              choices  = control_choices,
              selected = control_choices[1])
})




#normalise if box checked
output$do_normalise <- renderUI({
  
  if (is.null(input$control) || input$selectedTab != "BoxPlot") return()
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return()
  isolate({
    checkboxInput("normal", "normalise", FALSE)

  })
  
})

######## choose subset of cohorts##############
output$choose_subset_cohort <- renderUI({
  if (is.null(input$normal) ||
        !is.element(input$cohort,colnames(datasetInput())) ||
        !is.element(input$signatures_set,colnames(datasetInput())))  return(NULL)
    
  isolate({     
    
    subset_cohort<-sort(unique(as.character(datasetInput()[[input$cohort]])))
    checkboxGroupInput("subset_cohort_2plot", "", inline = FALSE,
                       subset_cohort,selected = subset_cohort)
    
  })
  
  
})
#############################################


#BoxPlot based on selected boxes
output$boxplot <- renderPlot({
 
  if(is.null(input$cohort)) return(NULL)
  if(is.null(datasetInput())) return(NULL)
if (is.null(input$normal) ||
      !is.element(input$cohort,colnames(datasetInput())) ||
      !is.element(input$signatures_set,colnames(datasetInput())))  return(NULL)
#if(is.null(input$shifhtBoxPlot)) return(NULL)
  dat <- datasetInput()[, c(input$signatures_set,input$cohort,input$color), drop = FALSE] 

  ###added this to check if input is factor! if so I try to change to numeric !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  # if (is.factor(dat[,1])) dat[,1]<-as.numeric(as.character(dat[,1]))
  if (is.factor(dat[,1])) return()
  
 
  
  if (input$normal==TRUE) dat<-normalise2control(dat,input$control,input$cohort) 
  
#the next 3 lines check for selected cohort groups - if removed function works without checking
  if(is.null(input$subset_cohort_2plot)) return(NULL)
  if(length(which(dat[,2] %in% input$subset_cohort_2plot))==0) return(NULL)
  dat<-dat[which(dat[,2] %in% input$subset_cohort_2plot),]
  # BoxPlot 

  showboxplot(dat,2,1,3) 
},width = 680,   
height = 400)   

################################# END OF BOXPLOT ########################################

######################################### PLOT ###########################################

#display signatures - select boxes for PLOTTING
output$choose_columns_plot1 <- renderUI({
   
  if(is.null(datasetInput()) || is.null(input$signatures_set) ||
       input$selectedTab != "Plot"  ) return()
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return()
    # Choose signatures to plot
  isolate({
   
   
    sig_cols<-colnames(datasetInput()[sapply(datasetInput(), is.numeric)])

 
  c1<-selectInput("columns1", "Select columns to plot", 
            choices  = sig_cols,
            selected = sig_cols[1])

  })
})

output$choose_columns_plot2 <- renderUI({
  
  if(is.null(datasetInput()) || is.null(input$signatures_set) ||
     input$selectedTab != "Plot"  ) return()
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return()
  # Choose signatures to plot
  isolate({
    
    
    sig_cols<-colnames(datasetInput()[sapply(datasetInput(), is.numeric)])
    
    
    c2<-selectInput("columns2", "", 
                    choices  = sig_cols,
                    selected = sig_cols[2])
    

    
  })
})

##display cohort check boxes
output$choose_cohorts_plot <- renderUI({

 
  if (input$selectedTab != "Plot" || is.null(input$columns1) || is.null(input$columns2)) return()
 if(is.null(gsvaInput()) && !is.null(gsetInput())) return()
  if (!is.element(input$cohort,colnames(datasetInput()))) return()
    
  isolate({     
      
      cohort_choises<-sort(unique(as.character(datasetInput()[[input$cohort]])))
      checkboxGroupInput("cohorts2plot", "", cohort_choises,selected = cohort_choises)
      
    })

})


output$plot <- renderPlot({  
  
  if (is.null(datasetInput()) || is.null(input$cohort) || is.null(input$cohorts2plot) || 
        !is.element(input$cohort,colnames(datasetInput())) || 
        is.null(input$columns1) || is.null(input$columns2))  return() 
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return()
  # isolate({
    dat <- datasetInput()[is.element(datasetInput()[,input$cohort],input$cohorts2plot), c(input$columns1,input$columns2,input$cohort)]
    if (nrow(dat)==0) return()
    showplot(dat,1,2,3)
  # })
  
})


#show intersection between gene sets

output$geneIntersect <- renderTable({
  
  
  if (is.null(datasetInput()) || is.null(input$cohort) || is.null(input$cohorts2plot) || 
        !is.element(input$cohort,colnames(datasetInput())) || 
        is.null(input$columns1) || is.null(input$columns2))  return() 
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return()  
  
  if (is.null(gsetInput())){gset<-gsc}else{gset<-gsetInput()}

  #if it is not a signature (hence a clinical variable) return 0 

  
  
    if(!is.element(input$columns1,names(gset))) return()
    if(!is.element(input$columns2,names(gset))) return()
    if(input$columns1==input$columns2) return()
  set1<-as.character(length(geneIds(gset[[input$columns1]])))
  set2<-as.character(length(geneIds(gset[[input$columns2]])))
  overlap<-length(intersect(geneIds(gset[[input$columns1]]),geneIds(gset[[input$columns2]])))
  overlap.frame<-data.frame(rbind(set1,set2,overlap))
  rownames(overlap.frame)<-c(input$columns1,input$columns2,"overlap")
  names(overlap.frame)<-"Number of genes"
  overlap.frame<-cbind(rownames(overlap.frame),overlap.frame)
  names(overlap.frame)[1]<-"Gene signature"
  return(overlap.frame)
})







###########################################################################################


#Display ES table
  output$table <- renderTable({
  
    if(is.null(datasetInput())) return(NULL)
    if(is.null(gsvaInput()) && !is.null(gsetInput())) return()    
      isolate({
 
      # datasetInput()[-grep("rownames\\(esdf\\)",names(datasetInput()))]
      res<-datasetInput()
      names(res)[1]<-""
      res
      })      
  })

#Download data
output$save <- renderUI({



  
  if(is.null(datasetInput()) || input$selectedTab != "Table") return()
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return()
  
  isolate({
    
    # DownLoad data
    downloadButton('downloadData', 'Save table')

    
  })
})

output$downloadData <- downloadHandler(
  filename = function() { paste(input$dataset,'.Enrichment.Scores', '.csv', sep='') },
  content = function(file) {
    write.csv(datasetInput()[-1], file)
  }
)

#########################Signature overview########################################

output$signature_table <- DT::renderDataTable({
  createLink <- function(val) {
    sprintf('<a href="%s" target="_blank" class="btn btn-primary">Info</a>',val)
  }
  
  Methodology.paper.signature.details$link <- createLink(Methodology.paper.signature.details$reference)
  Methodology.paper.signature.details<-cbind(Methodology.paper.signature.details$link,Methodology.paper.signature.details[1:6])
  
  names(Methodology.paper.signature.details)[1]<-"link"
  
  datatable(Methodology.paper.signature.details,
            escape = FALSE,
            selection = 'single',
            options = list(pageLength = 105),
            rownames = FALSE,
            filter = 'top')
  
})


output$signature_link <- renderUI({
  
  if(is.null(input$signatures_set)) return()
  
  
  pos<-match(input$signatures_set,signature_info$Signature.Name)
  
  if(is.na(pos)) return()
  a(signature_info[pos,6], 
    href = signature_info[pos,6],target="_blank")
  
})


output$signature_TITLE <- renderUI({
  
  if(is.null(input$signatures_set)) return()
  
  
  pos<-match(input$signatures_set,signature_info$Signature.Name)
  if(is.na(pos)) return()
  h6(signature_info[pos,7])
  
  
})


#display apply statistics button
output$apply_stats <- renderUI({
  
  if(input$selectedTab != "BoxPlot") return(NULL)
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return(NULL)
  checkboxInput("stats_checkbox", "Display Statistics for entire signature collection", FALSE)
  
})



#check if button pressed
stats <- reactive({ 
  
  if(is.null(datasetInput())) return(NULL)
  
  
  if(input$selectedTab != "BoxPlot") return(NULL)
  #check if user has uploaded a gene set but gsva is not ready yet - return NULL
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return(NULL)
  
  if(is.null(input$stats_checkbox))  return(NULL)
  if(input$stats_checkbox==FALSE)  return(NULL)
  #starts/stops doing stats
  
  if(is.null(input$signatures_set)) return(NULL)
  
  if(is.null(input$cohort)) return()

  if(is.null(input$subset_cohort_2plot)) return(NULL)

 if(sum(is.element(datasetInput()[[input$cohort]],input$subset_cohort_2plot))==0) return()
  
   dat <- datasetInput()[datasetInput()[[input$cohort]] %in% input$subset_cohort_2plot,]
   rownames(dat)<-dat[,1]
   dat<-dat[,2:ncol(dat)]
   
   
   
  
   
   #if user has not uploaded gene set gsc is used, otherwise user set is used
   
   if (is.null(gsetInput())) genesetnames<-names(gsc) else genesetnames<-names(gsetInput())
  
   
   res<-run_limma(dat,genesetnames,input$cohort)
   
  if(is.null(res)) return()
   
   res<-round(res,4)

})




output$statsResult <- DT::renderDataTable({ 
  
  if(input$selectedTab != "BoxPlot") return(NULL)
  
 
  if(is.null(stats())) return()
  if(!is.data.frame(stats())) return()
  if(is.null(input$cohort)) return()
  if(input$stats_checkbox==FALSE)  return(NULL)
  
  stats()
  })

#show only significan results
output$show_significant <- renderUI({
  
  if (is.null(input$control) || input$selectedTab != "BoxPlot") return()
  if(is.null(gsvaInput()) && !is.null(gsetInput())) return()
  
  if(!is.null(gsvaInput())){
   if(!is.element(input$signatures_set,colnames(gsvaInput()))) return()
  }
  if(input$stats_checkbox==TRUE)  return(NULL)
  isolate({
    checkboxInput("significant", "Show only statistically significant results", TRUE)
    
  })
  
})


#this is to display the statistics for the signature chosen currently
output$signature_stat<-renderTable({
  if(input$selectedTab != "BoxPlot") return(NULL)
  if(is.null(datasetInput())) return(NULL)
  if(is.null(input$cohort)) return(NULL)
  if(is.null(input$control)) return(NULL)
  if(is.null(input$subset_cohort_2plot)) return(NULL)
  if(input$stats_checkbox==TRUE)  return(NULL)
  if(!is.element(input$cohort,names(datasetInput()))) return()
  if(!is.element(input$control,datasetInput()[[input$cohort]])) return()
  
  
  ######
  dat <- datasetInput()[datasetInput()[[input$cohort]] %in% input$subset_cohort_2plot,]
  rownames(dat)<-dat[,1]
  dat<-dat[,2:ncol(dat)]
  
  if (is.null(gsetInput())) genesetnames<-names(gsc) else genesetnames<-names(gsetInput())
  
  res<-run_limma(dat,genesetnames,input$cohort)
  if(!is.element(input$signatures_set,rownames(res))) return()
  
 
  res<-res[match(input$signatures_set,rownames(res)),]
  

  ind_sign<-c(seq(3,ncol(res),3)[res[seq(3,ncol(res),3)]<0.05]-2,
              seq(3,ncol(res),3)[res[seq(3,ncol(res),3)]<0.05]-1,
              seq(3,ncol(res),3)[res[seq(3,ncol(res),3)]<0.05])
  ind_sign<-sort(ind_sign)
 
  
  if(input$significant & length(ind_sign)!=0){
  
  res<-data.frame(t(res[ind_sign]))
  res<-cbind(rownames(res),res)
  colnames(res)[1]<-"comparisons"
  res}else if(input$significant & length(ind_sign)==0){
    return() }else{
    res<-data.frame(t(res))
    res<-cbind(rownames(res),res)
    colnames(res)[1]<-"comparisons"
    res
  }
 
  
})


###save stats
output$save_stats <- renderUI({
  
  if(is.null(stats()) || !is.data.frame(stats())) return()
  isolate({
    
    # DownLoad data
    downloadButton('downloadStats', 'Save table')
    
  })
})

output$downloadStats <- downloadHandler(
  filename = function() { paste('Deregulated.pathways', '.csv', sep='') },
  content = function(file) {
    write.csv(stats(), file)
  }
)


})

