shinyUI(pageWithSidebar(
  
  headerPanel("Gene Set Variation Analysis"),
        
  sp<-sidebarPanel(

#     tags$style(type="text/css", '#sp {position:relative;min-height: 500px }'),
#     id="sp",  
    
#     tags$head(
#       tags$style(type="text/css", "select { max-width: 210px;position:relative;top:-3px;}")),
         
    
    
    wp1<-wellPanel(  
      
#       tags$style(type="text/css", '#wp1 {height: 65px }'),
#       id="wp1",
        
      
        uiOutput("chooseDataset"),
        uiOutput("displaySetName"),
         uiOutput("pmid")
    ),

    
   wp2<-wellPanel( 

#       tags$style(type="text/css", '#wp2 {position:relative;height:175px;}'),
#       id="wp2",
     
     
    
     
     
     
     uiOutput("choose_cohort_column"),
      uiOutput("choose_signature"), #just remove this, and choose_signature in server
      uiOutput("choose_columns_plot1"),
     uiOutput("choose_columns_plot2"),
      
   #   uiOutput("choose_control"),
    uiOutput("gsva_button"),
    uiOutput("filter_var"),
    
#     tags$head(
#       tags$style(type="text/css", "#gsva_button { position: relative;top:80px;}"))
uiOutput("apply_stats"),
#  checkboxInput("stats_checkbox", "Statistics", FALSE),
#  tags$style(type="text/css", "#apply_stats {position: relative;top:-15px;}"),
uiOutput("select_pval"),
uiOutput("select_fc")
    
   
    
),


# inputTextarea('exampleTextarea', '',2,5),
# actionButton("submit", "Submit"),
# fileInput("gset", h6("Upload a geneSetCollection",align = "left",style = "color:gray;"),
# #                      position:absolute;bottom:131px"),
#           multiple = FALSE, accept = NULL),
# tags$style(type="text/css", '#gset {position:absolute;bottom:116px;}'),
#       id="gset",
    
#     p("To browse GEO series, visit the ",
#       a("GEO homepage.", 
#         href = "http://www.ncbi.nlm.nih.gov/geo/",target="_blank")),
# #         style="position:absolute;bottom:88px"),
      uiOutput('show_geneset_upload'),

     # img(src="etriks_janssen.jpg",height=80,width=290) 

######################################################   work in progress ##########################################


# textInput("gene_list", "Input gene list", ""),
# actionButton("submit", "submit"),
# # textOutput("text"), 

uiOutput('show_geneset_input'),
# uiOutput('show_submit_Button'),
 

######################################################    END   #####################################################

img(src="Janssen-logo-and-etriks.png",height=180)

  ),

  
  mP<-mainPanel(
    
    ### show timer
    conditionalPanel("updateBusy() || $('html').hasClass('shiny-busy')",
                     img(src="loading_icon.gif"),
                     id='progressIndicator',
                     div(id='progress',includeHTML("timer.js"))
    ),

    tags$head(tags$style(type="text/css",
                         '#progressIndicator {',
                         '  position:fixed; top: 10px; right: 710px; top: 310px; width: 130px; height: 30px;',
                         '  padding: 8px; border: 1px transparent #CCC; border-radius: 8px;',
                         '}'
    )),
    ####
    
    
    
    tp<-tabsetPanel(
      
      
      tabPanel("Summary",
               tags$style(HTML("
              .tabs-above > .nav > li[class=active] > a {
                               background-color: aliceblue;
                               color: cornflowerblue;
                               }")),
               

               
            
               
               br(),
               
               p("Gene Set Variation Analysis (GSVA) is a non-parametric, unsupervised method which estimates the relative enrichment 
                 of a gene set of interest across a sample population. Hence, it allows us to observe the variation in the activity 
                 of a set of genes, such us a pathway or a gene signature, corresponding to a particular biological condition, 
                 within an entire gene expression set. It produces a value, termed enrichment score (ES), per sample and gene set, 
                 which can be examined for associations with clinical features of interest.",style='text-align:justify'),
               br(),
               h6("BMC Bioinformatics. 2013 Jan 16;14:7. doi: 10.1186/1471-2105-14-7."),
               a("GSVA: gene set variation analysis for microarray and RNA-seq data.", 
                 href = "http://www.ncbi.nlm.nih.gov/pubmed/23323831",target="_blank"),
               h6("Hanzelmann S, Castelo R, Guinney J"),
             
               
                 br(),
                p("This implementation of GSVA, contains two preloaded, publicly available gene expression datasets, 
                  which the user can select through the 'Choose a dataset' drop down menu on the top left. The link, 
                  below the drop down menu opens the Gene Expression Omnibus (GEO) page, 
                  with detailed desciption of the data set in question."),
               p('In addition the application holds a collection of 103 signatures, related to immune cells, 
                 immunological responses and conditions. The user can choose a signature of interest and explore ES scores distribution, 
                 through the  "Select Signature/variable to plot" drop down menu, on the right of the BoxPlot tab. The "select cohort column" 
                 drop down, allows the choice of the condition of interest.
                 At the Plot tab, the user can visualize the correlation between signature ES scores and/or numerical variables.'),
               p("Importantly, users can provide their own signature typing in or copying a set of gene symbols, separated by spaces, in the Input gene list box. 
                  In the current GSVA implementation, the application only works with gene symbols."),
               tags$hr(),
               p("In conclussion:"),
               tags$ul(
                 tags$li("The BoxPlot tab allows visual exploration of ES scores, per user selected condition and provides the user with 
                 statistical information, for between group comparisons.",style='text-align:justify'), 
                 tags$li("The Plot tab allows the user to visualise the correlation between enrichment scores of signatures, as well as correlation
                  with available numerical clinical variables.",style='text-align:justify'), 
                 tags$li("The table tab allows the user to download the enrichment score table for further analysis."),
                 tags$li("The Signatures tab provides the list of signatures used here, along with additional information and links to the
                 publication, from where each signature was acquired.",style='text-align:justify')
               )

            ),
      


      tpbp<-tabPanel("BoxPlot",
                    
                     tags$style(type="text/css", "#tpbp {height:800px;}"),
               chc<-uiOutput("choose_control"),
               tags$style(type="text/css", "#choose_control {width:220px;}"),
               uiOutput("do_normalise"),
               tags$head(
                 tags$style(type="text/css", "#do_normalise { position: relative; max-width:20px; 
                                 left:240px;top:-42px;}")),
               uiOutput("choose_color_condition"),
               tags$head(
                 tags$style(type="text/css", "#choose_color_condition { position: relative; max-width:200px; 
                                 left:360px;top:-100px;}")),
               
               
               plotOutput("boxplot",height="auto",width="auto"),
               tags$head(
                 tags$style(type="text/css", "#boxplot { position: relative;top:-100px;}")),
               
               textOutput('display_warning'),
               
               
               uiOutput("choose_subset_cohort"),
               tags$head(
                 tags$style(type="text/css", "#choose_subset_cohort { position: relative;top:-470px;left:702px;width:5px}")),
               uiOutput("show_significant"),
               tags$head(
                 tags$style(type="text/css", "#show_significant { position: relative;top:-470px;left:702px;width:5px}")),

               DT::dataTableOutput("statsResult"),
               tags$head(
                 tags$style(type="text/css", "#statsResult { position: relative;top:-190px;}")),
               
               uiOutput("save_stats"),
               tags$head(
                 tags$style(type="text/css", "#save_stats { position: relative;top:-180px;}")),
               # uiOutput("statsState"),
               tags$head(
                 tags$style(type="text/css", "#statsState { position: relative;top:-62px;}"))
              
               ),
      
      
      
      
      tabPanel("Plot",plotOutput("plot"),
               uiOutput("choose_cohorts_plot"),
#                tags$style(type="text/css", '#choose_cohorts_plot {position:relative;
#                                                           max-width:200px;left:50px;bottom:12px;
#                                                         max-height:180px;overflow-y:auto;}'),
#               id="choose_cohorts_plot",
tableOutput("geneIntersect"),
tags$style(type="text/css", '#geneIntersect {position:relative;left:200px;top:-80px  }'),
id="geneIntersect"

               ),
      tabPanel("Table",tableOutput("table"),
               tags$style(type="text/css", '#table {max-height: 457px;overflow:auto; }'),
               id="table",
               uiOutput("save")
               ),
      


tabPanel("Signatures",
         br(),
         DT::dataTableOutput('signature_table'),
         #                tableOutput("signature_table"),
         uiOutput("signature_TITLE"),uiOutput("signature_abstract"),
         uiOutput("signature_link")),





                                                    
      id = "selectedTab"
    ),

              tableOutput("signature_stat"), #this is to show statistics for displayed signatures
                tags$head(
                  tags$style(type="text/css", "#signature_stat { position: absolute;top:580px;}"))

  )
  
))