#load packages
library("shiny")
library(networkD3)
library( "shiny")
 
#load scripts needed for running SNF
source("SNF_implement.R")
 
options(shiny.maxRequestSize=100*1024^2) 
shinyServer(function(input,output){
  fl=reactive({
    validate(
      need(input$files$datapath != "", "Please select a data set")
    )
    read_files(features_list=input$files$datapath,input$rm,input$rmv,input$im,input$imv,input$nr)
  })
  #generate similarity matrix
  Wf <- reactive({
   
    
    makeWf(K=20,tau=10,alpha=0.5,fl())
    })
  
  #Vector containing group assignements
  groups <- reactive({cluster_groups(Wf(),input$clusters)})
  
  #Links for network
  nw <- reactive({make_nw(Wf())})
  
  output$contents <- renderTable(number_of_clusters(Wf()))
  
  output$heatmap <- renderPlot({display_heatmap(Wf(),groups())})
 
  output$networkPlot <- 
    renderForceNetwork(
      
      {
      groups2=order_group(groups(),descending=T,letter=T)
      groups2=as.data.frame(cbind(names(groups2),groups2))
      groups2$ID=1:nrow(groups2)
      colnames(groups2)=c("name","group","ID")
    
      nw=nw_to_plot(nw(),groups2,input$topLinks)
      forceNetwork(
        Nodes = groups2,
        zoom=TRUE,
        Links = nw, 
        Source = "source", 
        Target = "target",
        Value = "value",
        NodeID = "name",
        Group = "group",
        opacity=1,
        bounded=TRUE,
        
        colourScale =JS( 'd3.scale.ordinal().domain("a","b","c","d","e","f","g","h").range(["#1f77b4","#ff7f0e","#2ca02c","#d62728","#9467bd","#8c564b","#e377c2","#7f7f7f","#bcbd22","#17becf"])')  
      )
    }
    )
     
 
  
  output$downloadWf <- downloadHandler(
    filename="Similarity_matrix.csv" ,
    content = function(file) {
      write.csv(Wf(), file)
    }
  )
  
  output$downloadGroups <- downloadHandler(
    filename="Group_assignment.csv",
    conten <- function(file){
      write.table(groups(),file)
    }
  )
  output$downloadNw <- downloadHandler(
    filename="interactions.csv",
    conten <- function(file){
      write.table(nw(),file)
    }
  )
  
 # output$features<-renderTable({
  #  input$features
   # isolate(select_features(fl(),Wf(),input$clusters))
  #}
  #)

})