#load and install library => test to know if needs to be installed

# source("http://bioconductor.org/biocLite.R")
# biocLite(c("AnnotationDbi", "impute", "GO.db", "preprocessCore"))
# install.packages("WGCNA") 
library(WGCNA)
library(gplots)
library(networkD3) 
library(DT)

# load ready female liver data set and precomputed SFT
load(file = 'data/fem_mice_liver_datExpr.Rdata') # female expression data
load(file = 'data/fem_mice_liver_datTraits.Rdata') # female clinical traits
load(file = 'data/male_mice_liver_datExpr.Rdata') # male expression data
load(file = 'data/male_mice_liver_datTraits.Rdata') # male clinical traits
load(file = 'data/sfts.Rdata') # precomputed SFTs

## functions
plot_soft_threshold <- function(sft,powers){
    plotCols <- c(2,5,6,7)
    colNames <- c("Scale Free Topology Model Fit", "Mean Connectivity", "Median Connectivity", "Max Connectivity")
    ylim <- matrix(NA, nrow=2, ncol=4)
    for (col in 1:length(plotCols))
    {
        ylim[1, col]<-min(ylim[1,col], sft$fitIndices[,plotCols[col]], na.rm=T)
        ylim[2, col]<-max(ylim[2,col], sft$fitIndices[,plotCols[col]], na.rm=T)
    }
    par(mfcol = c(2,2));
    for (col in 1:4)
    {
        plot(sft$fitIndices[,1], -sign(sft$fitIndices[,3])*sft$fitIndices[,2],xlab="Soft Threshold (Power)", ylab=colNames[col], type="n", ylim=ylim[,col], main=colNames[col])
        addGrid()
        if(col==1)
        {
            abline(h = 0.8,col='red')
            tmp <- which.max((-sign(sft$fitIndices[,3])*sft$fitIndices[,2])>=0.8)
            text(sft$fitIndices[,1], -sign(sft$fitIndices[,3])*sft$fitIndices[,2], labels=powers,col=replace(rep('black',length(powers)),tmp,'red'))
        }
        else
            text(sft$fitIndices[,1], sft$fitIndices[,plotCols[col]], labels=powers,col=replace(rep('black',length(powers)),tmp,'red'))
    }
}

create_network <- function(datExpr,power,network_construction_method,network_type,man_param,tom_type){
    if(network_construction_method %in% c('Automatic','Manual')){
            adjacency <- adjacency(datExpr=datExpr, power=power, type = network_type)
            
            TOM <- TOMsimilarity(adjacency,TOMType = tom_type,verbose = 0)
            
            dissTOM <- 1-TOM
            geneTree <- hclust(as.dist(dissTOM), method = "average")
            
                    
    }else if(network_construction_method=='Block'){
            
    }
            
   
            
        return(list("adjacency"=adjacency,"TOM"=TOM,"dissTOM"=dissTOM,
                    "geneTree"=geneTree))
    }

initial_modules <- function(datExpr,power,network_construction_method,net,man_param){
    if(network_construction_method %in% c('Automatic','Manual')){
        dynamicMods <-  cutreeDynamic(dendro = net$geneTree, distM = net$dissTOM,cutHeight = man_param$cutheight,
                                  deepSplit = man_param$deepSplit,
                                  pamRespectsDendro = FALSE,
                                  minClusterSize = man_param$minModuleSize,
                                  verbose = 0)
    
        dynamicColors <- labels2colors(dynamicMods)
        MEList <- moduleEigengenes(datExpr, colors = dynamicColors, softPower = power)
    }else if(network_construction_method=='Block'){
        
    }
    return(list("dynamicMods"=dynamicMods, 
    "dynamicColors"=dynamicColors,"MEs"=MEList))
}
  
mergeModules <- function(value,datExpr,useAbs,network_construction_method,colors,man_param){
        
    if (network_construction_method=='Automatic'){
        tmp <- mergeCloseModules(datExpr, colors, 
                                   cutHeight = man_param$MEDissThres, 
                                    verbose = 0,useAbs =useAbs,iterate=TRUE)
    }else if (network_construction_method=='Manual'){
        tmp <- mergeCloseModules(datExpr,colors,
                                   cutHeight = man_param$MEDissThres, 
                                    verbose = 0,useAbs =useAbs,iterate=FALSE)
    }
   
    moduleColors <- tmp$colors
    colorOrder <- c("grey", standardColors(50));

    moduleLabels <- match(moduleColors, colorOrder)-1
    
    MEs <- tmp$newMEs
    
    return(list("moduleColors"=moduleColors,"moduleLabels"=moduleLabels,"MEs"=MEs))
    
}

gene_relationship <- function(datTraits, datExpr, MEs){
        modNames <- substring(names(MEs), 3)
        geneModuleMembership <- as.data.frame(cor(datExpr, MEs, use = "p"));
        MMPvalue <- as.data.frame(corPvalueStudent(as.matrix(geneModuleMembership), nrow(datExpr)));
        names(geneModuleMembership) <- paste("MM", modNames, sep="");
        names(MMPvalue) <- paste("p.MM", modNames, sep="");
        geneTraitSignificance <- as.data.frame(cor(datExpr, as.data.frame(datTraits), use = "p"));
        GSPvalue <- as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance), nrow(datExpr)));
        names(geneTraitSignificance) <- paste("GS.", names(datTraits), sep="");
        names(GSPvalue) = paste("p.GS.", names(datTraits), sep="");
    
        return(list('modNames'=modNames, 'geneModuleMembership'=geneModuleMembership,
                'MMPvalue'=MMPvalue, 'geneTraitSignificance'=geneTraitSignificance,
                'GSPvalue'=GSPvalue))  
    }

longProcessStart <- function(session) {
    session$sendCustomMessage(type='showWaitMessage', list(value=TRUE))
}
            
longProcessStop <- function(session) {
    session$sendCustomMessage(type='showWaitMessage', list(value=FALSE))
}