## change tab 
observeEvent(input$GoTab1,{
  updateTabsetPanel(session, "myTabsetPanel", selected = 'Data Input')
})

observeEvent(input$GoTab2,{
  updateTabsetPanel(session, "myTabsetPanel", selected = "Network Construction")
})
        
observeEvent(input$BackTab0,{
  updateTabsetPanel(session, "myTabsetPanel", selected = "Introduction")
})

observeEvent(input$GoTab3,{
  updateTabsetPanel(session, "myTabsetPanel", selected = 'Module - Trait Relationship')
})

observeEvent(input$BackTab1,{
  updateTabsetPanel(session, "myTabsetPanel", selected = 'Data Input')
})

observeEvent(input$BackTab2,{
  updateTabsetPanel(session, "myTabsetPanel", selected = 'Network Construction')
})

## disable download buttons 
observe({ 
  if(tryCatch(is.null(sft()),error=function(e){TRUE})){
    session$sendCustomMessage('disable', message=list(value=FALSE,div='#downloadsft',parent=FALSE))
  }else{
    session$sendCustomMessage('disable', message=list(value=TRUE,div='#downloadsft',parent=FALSE))
  }
})

observe({ 
  if(tryCatch(is.null(moduleassignment()$assignment),error=function(e){TRUE})){
    session$sendCustomMessage('disable', message=list(value=FALSE,div='#downloadmoduleassignment',parent=FALSE))
  }else{
    session$sendCustomMessage('disable', message=list(value=TRUE,div='#downloadmoduleassignment',parent=FALSE))
  }
})

observe({ 
  if(tryCatch(is.null(moduleTrait()),error=function(e){TRUE})){
    session$sendCustomMessage('disable', message=list(value=FALSE,div='#downloadmoduletrait',parent=FALSE))
  }else{
    session$sendCustomMessage('disable', message=list(value=TRUE,div='#downloadmoduletrait',parent=FALSE))
  }
})

observe({ 
  if(tryCatch(is.null(gsMM()),error=function(e){TRUE})){
    session$sendCustomMessage('disable', message=list(value=FALSE,div='#downloadgsmm',parent=FALSE))
  }else{
    session$sendCustomMessage('disable', message=list(value=TRUE,div='#downloadgsmm',parent=FALSE))
  }
})

observe({
  if(tryCatch(is.null(network_to_show()),error=function(e){TRUE})){
      session$sendCustomMessage(type = 'disable',message = list(value=FALSE, div='#downloadshownnetwork',parent=FALSE))
  }
})

observe({
  if(tryCatch(is.null(net()),error=function(e){TRUE})){
    session$sendCustomMessage(type = 'disable',message = list(value=FALSE, div='#downloadwholenetwork',parent=FALSE))
  }else{
    session$sendCustomMessage(type = 'disable',message = list(value=TRUE, div='#downloadwholenetwork',parent=FALSE))
  }
})
        
## alert for invalid input parameters
observe(priority = 102, x = {
  # wait 1 sec before sending the alert message
  Sys.sleep(2)
  
  # input soft power value
  if(!is.null(input$soft_threshold)){
    if(tryCatch({is.na(input$soft_threshold) | input$soft_threshold < 1 | input$soft_threshold > 30},error=function(e){TRUE})){
      a <- '\nIt should be between 1 and 30.'
      session$sendCustomMessage(type = 'invalid',message = a)
      updateNumericInput(session,inputId = 'soft_threshold', value = 6)
    }
  }
  
  # input min module size (manual parameter)
  if(!is.null(input$minModuleSize)){
    if(tryCatch({is.na(input$minModuleSize) | !is.numeric(input$minModuleSize) | input$minModuleSize < 0},error=function(e){TRUE})){
      a <- '\nIt should be numeric.'
      session$sendCustomMessage(type = 'invalid',message = a)
      updateNumericInput(session,inputId = 'minModuleSize', value = 30)
    }
  }
  
  # input grey module cutheight (manual parameter)
  if(!is.null(input$cutheight)){
    if(tryCatch({is.na(input$cutheight) | input$cutheight<0|input$cutheight>1},error=function(e){TRUE})){
      a <- '\n It should be between 0 and 1.'
      session$sendCustomMessage(type = 'invalid',message = a)
      updateNumericInput(session,inputId = 'cutheight', value = 0.995)
    }
  }
  
  # input deepSplit parameter for dynamic cut tree method (manual parameter)
  if(!is.null(input$deepSplit)){
      if(tryCatch({is.na(input$deepSplit) | !input$deepSplit%in%c(0,1,2,3,4)},error=function(e){TRUE})){
	  a <- '\n It should be 0, 1, 2, 3 or 4.'
	  session$sendCustomMessage(type = 'invalid', message = a)
	  updateNumericInput(session,inputId = 'deepSplit', value = 2)
      }
  }
  
  # input module eigengene merge threshold (manual parameter)
  if(!is.null(input$MEDissThres)){
      if(tryCatch({is.na(input$MEDissThres) | input$MEDissThres<0 |input$MEDissThres>1},error=function(e){TRUE})){
	  a <- '\n It should be between 0 and 1.'
	  session$sendCustomMessage(type = 'invalid',message = a)
	  updateNumericInput(session,inputId = 'MEDissThres', value = 0.25)
      }
  }
  
  # input link threshold for network graph
  if(!is.null(input$link_threshold)){
      if(tryCatch({is.na(input$link_threshold) | input$link_threshold<0 |input$link_threshold>1},error=function(e){TRUE})){
	  a <- '\n It should be between 0 and 1.'
	  session$sendCustomMessage(type = 'invalid',message = a)
	  updateNumericInput(session,inputId = 'link_threshold', value = 0.25)
      }
  }
})

## Other alerts
# alert if only 3 or less modules are defined
observe(priority=100,{
  if(tryCatch({dim(as.matrix(MEDiss()))[1] <= 3},error=function(e){FALSE})){
    session$sendCustomMessage(type = 'only_one_module',message = list(a=MEDiss()))
  }
})


