#############################
## Data Input and Cleaning ##
#############################
# Check Data Input
#         if (length(dimEx) != 2) 
#             stop("datExpr has incorrect dimensions.")
#         if (any(is.na(datExpr))) {
#             datExpr.scaled.imputed = t(impute.knn(t(scale(datExpr)))$data)
#         }
#         else datExpr.scaled.imputed = scale(datExpr)
#         output$fake_plot <- renderPlot({})
#         cdata <- session$clientData
#         output$urlText <- renderText({
#             cnames <- names(cdata)
#             
#             allvalues <- lapply(cnames, function(name) {
#                 paste(name, cdata[[name]], sep=" = ")
#             })
#             paste(allvalues, collapse = "\n")
#         })

#################
## Choose data ##
#################

## Get data
data <- reactive({
  if(input$dataset=='fml'){
    datExpr <- fem_mice_liver_datExpr
    datTraits <- fem_mice_liver_datTraits
  }else if(input$dataset=='mml'){
    datExpr <- male_mice_liver_datExpr
    datTraits <- male_mice_liver_datTraits
  }
  return(list('datExpr'=datExpr,'datTraits'=datTraits))
})

## Visualise data
# Do the sample dendrogram
sampleTree <- reactive(hclust(dist(data()$datExpr), method = "average"))

# Convert traits to a color representation: blue means low, white means medium, red means 
# high and grey means missing entry
traitColors <- reactive(numbers2colors(scale(data()$datTraits), signed = TRUE))

# render the gene table
output$datatablegenes <- DT::renderDataTable({
    tmp <- DT::datatable(data.frame(Subject=row.names(data()$datExpr),data()$datExpr[,1:100]),
			 extensions = list(ColReorder=NULL,FixedColumns=NULL), 
			 options = list(pageLength = 5, dom = 'R<"clear">lftipr', 
					scrollX='100%',scrollY='300px',scrollCollapse=TRUE,
					autoWidth=FALSE,processing=F),
			 rownames=FALSE)
    return(tmp)
}) 

# render the clinical trait table
output$datatableclinical <- DT::renderDataTable({
  tmp <- DT::datatable(data.frame(Subject=row.names(data()$datTraits),data()$datTraits),
		       extensions =list(ColReorder=NULL,FixedColumns=NULL), 
		       options = list(pageLength = 5,dom = 'R<"clear">lfrtip',
				      scrollX='100%',scrollY='300px',scrollCollapse=TRUE,
				      autoWidth=FALSE,processing=F),
		       rownames=FALSE)
  return(tmp)
})

# Plot the sample dendrogram and the colors underneath.
output$visualize_plot <- renderPlot(
  height = function(){min(0.5*session$clientData$output_visualize_plot_width,500)},
  width = function(){min(session$clientData$output_visualize_plot_width,1000)},
  {
    plotDendroAndColors(sampleTree(), traitColors(), groupLabels = names(data()$datTraits), 
		        main = "Sample Dendrogram and Trait Heatmap",marAll = c(1,6,3,1),
		        cex.dendroLabels=0.6,cex.colorLabels=0.7)
  }
)