tabPanel('Data Input',
  h1('1. Data Input'),
  HTML("In this section, the user chooses and gets a first look at the dataset to use in the analysis."),
  
  ####################
  ## Select Dataset ##
  ####################
  h2('a. Choose Demo Dataset'),                    
  sidebarLayout(
    sidebarPanel(width=4,class='help',
      # help description
      includeHTML(path='www/html_text/data_input.html')
    ),
    mainPanel(width=8, 
      # button to choose datasets
      wellPanel(
	radioButtons(inputId = 'dataset',label = 'Demo Datasets',choices = c('Female Mice Liver'='fml', 'Male Mice Liver'="mml"))
      ),
      # visualise data tables (genes and clinical traits)
      fluidRow(
	column(6,
	  h4('Table of Gene Expression (100 first genes)'),
	  dataTableOutput('datatablegenes')
	),
	column(6,
	  h4('Table of Clinical Traits'),
	  dataTableOutput('datatableclinical')
	)
      ),
      br(),
      # visualise sample tree
      plotOutput('visualize_plot',height="auto", width="auto"),
      br(),
      # anchor back to top
      tags$div(style='margin-bottom:20px',
	HTML(text = "<a href='#top'>Back to Top</a>")
      ),
      # buttons previous and next step
      tags$div(
	actionButton(inputId = 'BackTab0',label = 'Go to Previous Step',class='btn-left'),   
	actionButton(inputId = 'GoTab2',label = 'Go to Next Step',class='btn-right')
      )
    )
  )
)