tabPanel('Network Construction',
  h1('2. Network Construction'),
  div(HTML('<p>In this section, the user will define the values of parameters and choose options to build the correlation network and define gene modules.</p>')),
  
  #########################
  ## Choose Network Type ##
  #########################
  h2('a. Choose Network Type'),
  sidebarLayout(
    sidebarPanel(width=4,class='help', 
      # help description
      includeHTML(path='www/html_text/network_construction/network_type.html')
    ),
    mainPanel(width=8, 
      wellPanel( 
	# choose network type
	flowLayout(
	  selectInput(inputId = 'network_type', 
	      label = "Choose Network Type", 
	      choices = c('Unsigned'="unsigned",'Signed'="signed","Signed Hybrid"="signed hybrid")
	  )
	),
	# compute button
	flowLayout(
	  actionButton(inputId = 'calc_sft',label = 'Compute')
	)
      )
    )
  ),
  hr(),
  
  #######################
  ## Choose Soft Power ##
  #######################
  h2('b. Choose Soft Power'),
  sidebarLayout(
    sidebarPanel(width=4,class='help',
      # help description
      includeHTML(path='www/html_text/network_construction/soft_power.html')
    ),
    mainPanel(width=8, 
      # visualise soft power result
      plotOutput('soft_power_plot',height="auto",width="auto"),
      # download soft power result as table
      downloadButton('downloadsft', 'Download Table'),
      # anchor back to top
      tags$div(style='margin-bottom:10px; margin-top:10px',
	HTML(text = "<a href='#top'>Back to Top</a>")
      )
    )
  ),
  hr(),
  
  ####################
  ## Create Network ##
  ####################
  h2('c. Create Network'),
  sidebarLayout(
    sidebarPanel(width=4,class='help',
      # help description with optional paragraph for manual construction
      includeHTML(path='www/html_text/network_construction/create_network1.html'),
      uiOutput('textManual'),
      includeHTML(path='www/html_text/network_construction/create_network3.html')
    ),
    mainPanel(width=8, 
      wellPanel(
	HTML("<h3 style='margin-top: 10px'>Compute Network</h3>"),
	# choose construction method, soft power and tom type for unsigned network
	flowLayout(
	  selectInput('network_construction_method', 'Construction Method', choices=c('Automatic','Manual'), selected = 'Automatic'),
	  numericInput(inputId = 'soft_threshold', label = "Choose Soft Power", min = 1, max = 30, value = 6, step = 0.01),
	  uiOutput('ui_tomtype')
	),
	# compute button to launch the calculation
	flowLayout(
	  actionButton('calc_network',label = 'Calculate Network')
	)
      ),
      # additional parameters for manual construction method
      uiOutput('ui_man_param'),
      # visualise module eingene tree
      plotOutput('METree_plot',height="auto", width="auto"),
      # visualise gene tree with module colors
      plotOutput('network_dendrogram',height="auto", width="auto"),
      # download module assignment button
      downloadButton('downloadmoduleassignment','Download Module Assignments'),
      br(),
      # anchor back to top
      tags$div(style='margin-bottom:10px; margin-top:10px',
	HTML(text = "<a href='#top'>Back to Top</a>")
      ),
      # buttons previous and next step
      tags$div(
	actionButton(inputId = 'BackTab1',label = 'Go to Previous Step',class='btn-left'),
	actionButton(inputId = 'GoTab3',label = 'Go to Next Step',class='btn-right')
      )
    )
  )
)