tabPanel('Module - Trait Relationship',
  h1('3. Module - Trait Relationship'),
  HTML("In this section, the user will explore relationships between gene 
  modules and clinical traits."),
  
  ###########################################
  ## Heatmap Correlation Eigengene - Trait ##
  ###########################################
  h2('a. Eigengene - Trait Analysis'),
  sidebarLayout(
    sidebarPanel(width=4,class='help',
      # help description
      includeHTML(path="www/html_text/module_trait/eigengene_trait.html")
    ), 
    mainPanel(width=8,
      # visualise heatmap
      plotOutput('moduleTraitMatrix',height="auto", width="auto"),
      # download table of correlations with p-values
      downloadButton('downloadmoduletrait','Download Module Trait Association')
    )
  ),
  hr(),
  
  #############################################
  ## Gene Significance and Module Membership ##
  #############################################
  h2('b. Gene - Trait Analysis'),
  sidebarLayout(
    sidebarPanel(width=4,class='help',
      # help description
      includeHTML(path='www/html_text/module_trait/gene_trait.html')
    ),
    mainPanel(width=8,
      # choose module and trait to analyse
      uiOutput('module_trait_ui'),
      fluidRow(
	# plot eigengene value by sample for specified module
	plotOutput('plot_GSvsMM3',height="auto", width="auto"),
    	splitLayout( style = "height:auto; float:left;",cellWidths = c("auto", "auto"),
	  # plot module significance for specified trait
	  plotOutput('plot_GSvsMM1',height="auto",width='100%'),
	  # plot gene significance for specified trait and gene module Membership
	  # for specified module
	  plotOutput('plot_GSvsMM2',height="auto",width='100%',brush = 'GSvsMM2_brush')
	)
      ),
      # show detail information for genes selected in plot_GSvsMM2
      dataTableOutput('data_selected'),
      downloadButton('downloadgsmm', 'Dowload Gene Significance and Module Membership'),
      # anchor back to top
      tags$div(style='margin-bottom:10px; margin-top:10px',
	HTML(text = "<a href='#top'>Back to Top</a>")
      )
    )
  ),
  hr(),
  
  #########################
  ## Show Module Network ##
  #########################
  h2('c. Network of Modules'),
  sidebarLayout(
    sidebarPanel(width=4,class='help',
      # help description
      includeHTML(path='www/html_text/module_trait/network_module.html')
    ),
    mainPanel(width=8,
      # choose parameter for the network (module, link threshold, singleton)
      uiOutput('network_param_ui'),
      # buttons to download shown and whole network
      flowLayout(
	downloadButton('downloadshownnetwork','Download Shown Network'),
	downloadButton('downloadwholenetwork','Download Whole Network')
      ),
      # show network 
      forceNetworkOutput('networkPlot'),
      # anchor back to top
      tags$div(style='margin-bottom:10px; margin-top:10px',
	HTML(text = "<a href='#top'>Back to Top</a>")
      ),
      # button previous step
      tags$div(
	actionButton(inputId = 'BackTab2',label = 'Go to Previous Step',class='btn-left')
      )
    )
  ), 
  
  #############################
  ## Go Further Explications ##
  #############################
  h1("4. To Go Further"),
  # help description
  tags$div(class="help",
    includeHTML(path='www/html_text/module_trait/go_further.html')
  )
)