shinyUI(
    navbarPage(title=div(img(src='etriks_logo.png', height = "30px")), windowTitle = 'WGCNA - Shiny', fluid = TRUE,
        HTML("<a name='top'></a>"),
        tabPanel(strong('Weighted Gene Correlation Network Analysis'),
            fluidPage(
                tagList(
                    tags$head(
                        tags$script(src="handlers.js"),
                        tags$link(rel="stylesheet", href="dt.css")
                    )
                ),
                h1(strong('Weighted Gene Correlation Network Analysis')),
                # include waiting dialog box
                includeHTML(path = "www/waiting.html"),
                # include small description of WGCNA
                includeHTML(path='www/html_text/welcome.html'),  
                
#                 tabsetPanel( # different workflows possible only main one implemented: Network Analysis
#                     tabPanel('Network Analysis', 
                tabsetPanel(id = 'myTabsetPanel',

                    ## Introduction Tab ##
                    tabPanel('Introduction',
                        fluidPage(
                            includeHTML(path='www/html_text/introduction.html'),
                            tags$div(
                                actionButton(inputId = 'GoTab1',label = 'Begin!',class='btn-right')   
                            )
                        )
                    ),
                    
                    ## Data Input Tab ##
                    source(file = 'sources/uis/tab1.R',local = TRUE)$value, 

                    ## Network Construction Tab ##
                    source(file = 'sources/uis/tab2.R', local=TRUE)$value, 
                    
                    ## Module Trait Relationship Tab ##
                    source(file = 'sources/uis/tab3.R', local=TRUE)$value 
                )
            )

#                 tabPanel('Consensus Analysis'),
#                 tabPanel('Meta Analysis')

#                 )
#             )
        )

#     tabPanel('Differential Co-Expression Analysis')
    )
)