/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.impl;

import java.util.Map;
import org.apache.uima.ResourceFactory;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.TextAnalysisEngine;
import org.apache.uima.analysis_engine.impl.AggregateAnalysisEngine_impl;
import org.apache.uima.analysis_engine.impl.MultiprocessingAnalysisEngine_impl;
import org.apache.uima.analysis_engine.impl.PrimitiveAnalysisEngine_impl;
import org.apache.uima.analysis_engine.impl.UimacppAnalysisEngineImpl;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisEngineFactory_impl
implements ResourceFactory {
    @Override
    public Resource produceResource(Class<? extends Resource> aResourceClass, ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        boolean multiprocessing = aAdditionalParams != null && aAdditionalParams.containsKey("NUM_SIMULTANEOUS_REQUESTS");
        Resource resource = null;
        if (aSpecifier instanceof ResourceCreationSpecifier && aResourceClass.isAssignableFrom(TextAnalysisEngine.class)) {
            ResourceCreationSpecifier spec = (ResourceCreationSpecifier)aSpecifier;
            if (multiprocessing) {
                resource = new MultiprocessingAnalysisEngine_impl();
            } else {
                String frameworkImpl = spec.getFrameworkImplementation();
                if (frameworkImpl == null || frameworkImpl.length() == 0) {
                    throw new ResourceInitializationException("missing_framework_implementation", new Object[]{aSpecifier.getSourceUrlString()});
                }
                if (frameworkImpl.startsWith("org.apache.uima.cpp")) {
                    resource = new UimacppAnalysisEngineImpl();
                } else if (frameworkImpl.startsWith("org.apache.uima.java")) {
                    resource = spec instanceof AnalysisEngineDescription && !((AnalysisEngineDescription)spec).isPrimitive() ? new AggregateAnalysisEngine_impl() : new PrimitiveAnalysisEngine_impl();
                } else {
                    throw new ResourceInitializationException("unsupported_framework_implementation", new Object[]{spec.getFrameworkImplementation(), aSpecifier.getSourceUrlString()});
                }
            }
        }
        if (resource != null && resource.initialize(aSpecifier, aAdditionalParams)) {
            return resource;
        }
        return null;
    }
}

