/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteSource;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteStreams;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closer;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files$1;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

final class Files$FileByteSource
extends ByteSource {
    private final File file;

    private Files$FileByteSource(File file) {
        this.file = (File)Preconditions.checkNotNull(file);
    }

    @Override
    public FileInputStream openStream() {
        return new FileInputStream(this.file);
    }

    @Override
    public byte[] read() {
        long l = this.file.length();
        if (l == 0L) {
            return super.read();
        }
        if (l > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("file is too large to fit in a byte array: " + l + " bytes");
        }
        byte[] byArray = new byte[(int)l];
        Closer closer = Closer.create();
        try {
            Object object;
            InputStream inputStream = (InputStream)closer.register(this.openStream());
            int n = 0;
            int n2 = 0;
            while ((long)n < l && (n2 = inputStream.read(byArray, n, (int)l - n)) != -1) {
                n += n2;
            }
            byte[] byArray2 = byArray;
            if ((long)n < l) {
                byArray2 = Arrays.copyOf(byArray, n);
            } else if (n2 != -1) {
                object = new ByteArrayOutputStream();
                ByteStreams.copy(inputStream, (OutputStream)object);
                byte[] byArray3 = ((ByteArrayOutputStream)object).toByteArray();
                byArray2 = new byte[byArray.length + byArray3.length];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                System.arraycopy(byArray3, 0, byArray2, byArray.length, byArray3.length);
            }
            object = byArray2;
            return object;
        }
        catch (Throwable throwable) {
            throw closer.rethrow(throwable);
        }
        finally {
            closer.close();
        }
    }

    public String toString() {
        return "Files.asByteSource(" + this.file + ")";
    }

    /* synthetic */ Files$FileByteSource(File file, Files$1 files$1) {
        this(file);
    }
}

