/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.Rethrow;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Charsets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closeables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.Gson;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.GsonBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.LongSerializationPolicy;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonWriter;
import com.carrotsearch.ant.tasks.junit4.events.IEvent;
import com.carrotsearch.ant.tasks.junit4.events.QuitEvent;
import com.carrotsearch.ant.tasks.junit4.events.json.JsonAnnotationAdapter;
import com.carrotsearch.ant.tasks.junit4.events.json.JsonByteArrayAdapter;
import com.carrotsearch.ant.tasks.junit4.events.json.JsonClassAdapter;
import com.carrotsearch.ant.tasks.junit4.events.json.JsonDescriptionAdapter;
import com.carrotsearch.ant.tasks.junit4.slave.SlaveMain;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import org.junit.runner.Description;

public class Serializer
implements Closeable {
    private final Object lock = new Object();
    private Writer writer;
    private Gson gson;
    private final ArrayDeque events = new ArrayDeque();

    public Serializer(OutputStream outputStream) {
        this.writer = new OutputStreamWriter(outputStream, Charsets.UTF_8);
        this.gson = Serializer.createGSon(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializer serialize(IEvent iEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (this.writer == null) {
                throw new IOException("Serializer already closed.");
            }
            this.events.addLast(iEvent);
            if (this.events.size() > 1) {
                return this;
            }
            do {
                iEvent = (IEvent)this.events.peekFirst();
                try {
                    JsonWriter jsonWriter = new JsonWriter(this.writer);
                    jsonWriter.setIndent("  ");
                    jsonWriter.beginArray();
                    jsonWriter.value(iEvent.getType().name());
                    this.gson.toJson(iEvent, iEvent.getClass(), jsonWriter);
                    jsonWriter.endArray();
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(this.writer);
                    this.writer = null;
                    SlaveMain.warn("Unhandled exception in event serialization.", throwable);
                    Rethrow.rethrow(throwable);
                }
                this.events.removeFirst();
                this.writer.write("\n\n");
            } while (this.writer != null && !this.events.isEmpty());
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializer flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.writer != null) {
                this.writer.flush();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.writer != null) {
                if (this.events.isEmpty()) {
                    this.serialize(new QuitEvent());
                }
                this.writer.close();
                this.writer = null;
            }
        }
    }

    static Gson createGSon(ClassLoader classLoader) {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)byte[].class), new JsonByteArrayAdapter()).registerTypeHierarchyAdapter(Annotation.class, new JsonAnnotationAdapter(classLoader)).registerTypeHierarchyAdapter(Class.class, new JsonClassAdapter(classLoader)).registerTypeAdapter((Type)((Object)Description.class), new JsonDescriptionAdapter()).setLongSerializationPolicy(LongSerializationPolicy.DEFAULT).disableHtmlEscaping().create();
    }
}

