/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.SolrZooKeeper;
import org.apache.solr.common.cloud.ZkClientConnectionStrategy;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionManager
implements Watcher {
    protected static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    private final String name;
    private CountDownLatch clientConnected;
    private Watcher.Event.KeeperState state;
    private boolean connected;
    private final ZkClientConnectionStrategy connectionStrategy;
    private final String zkServerAddress;
    private final int zkClientTimeout;
    private final SolrZkClient client;
    private final OnReconnect onReconnect;
    private volatile boolean isClosed = false;

    public ConnectionManager(String name, SolrZkClient client, String zkServerAddress, int zkClientTimeout, ZkClientConnectionStrategy strat, OnReconnect onConnect) {
        this.name = name;
        this.client = client;
        this.connectionStrategy = strat;
        this.zkServerAddress = zkServerAddress;
        this.zkClientTimeout = zkClientTimeout;
        this.onReconnect = onConnect;
        this.reset();
    }

    private synchronized void reset() {
        this.clientConnected = new CountDownLatch(1);
        this.state = Watcher.Event.KeeperState.Disconnected;
        this.connected = false;
    }

    public synchronized void process(WatchedEvent event) {
        if (log.isInfoEnabled()) {
            log.info("Watcher " + this + " name:" + this.name + " got event " + event + " path:" + event.getPath() + " type:" + event.getType());
        }
        if (this.isClosed) {
            log.info("Client->ZooKeeper status change trigger but we are already closed");
            return;
        }
        this.state = event.getState();
        if (this.state == Watcher.Event.KeeperState.SyncConnected) {
            this.connected = true;
            this.clientConnected.countDown();
            this.connectionStrategy.connected();
        } else if (this.state == Watcher.Event.KeeperState.Expired) {
            this.connected = false;
            log.info("Our previous ZooKeeper session was expired. Attempting to reconnect to recover relationship with ZooKeeper...");
            try {
                this.connectionStrategy.reconnect(this.zkServerAddress, this.zkClientTimeout, this, new ZkClientConnectionStrategy.ZkUpdate(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void update(SolrZooKeeper keeper) {
                        try {
                            ConnectionManager.this.waitForConnected(Long.MAX_VALUE);
                        }
                        catch (Exception e1) {
                            ConnectionManager.this.closeKeeper(keeper);
                            throw new RuntimeException(e1);
                        }
                        log.info("Connection with ZooKeeper reestablished.");
                        try {
                            ConnectionManager.this.client.updateKeeper(keeper);
                        }
                        catch (InterruptedException e) {
                            ConnectionManager.this.closeKeeper(keeper);
                            Thread.currentThread().interrupt();
                            throw new RuntimeException(e);
                        }
                        catch (Throwable t) {
                            ConnectionManager.this.closeKeeper(keeper);
                            throw new RuntimeException(t);
                        }
                        if (ConnectionManager.this.onReconnect != null) {
                            ConnectionManager.this.onReconnect.command();
                        }
                        ConnectionManager connectionManager = ConnectionManager.this;
                        synchronized (connectionManager) {
                            ConnectionManager.this.connected = true;
                        }
                    }
                });
            }
            catch (Exception e) {
                SolrException.log(log, "", e);
            }
            log.info("Connected:" + this.connected);
        } else if (this.state == Watcher.Event.KeeperState.Disconnected) {
            log.info("zkClient has disconnected");
            this.connected = false;
            this.connectionStrategy.disconnected();
        } else {
            this.connected = false;
        }
        this.notifyAll();
    }

    public synchronized boolean isConnected() {
        return !this.isClosed && this.connected;
    }

    public void close() {
        this.isClosed = true;
    }

    public synchronized Watcher.Event.KeeperState state() {
        return this.state;
    }

    public synchronized void waitForConnected(long waitForConnection) throws TimeoutException {
        log.info("Waiting for client to connect to ZooKeeper");
        long expire = System.currentTimeMillis() + waitForConnection;
        long left = 1L;
        while (!this.connected && left > 0L && !this.isClosed) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            left = expire - System.currentTimeMillis();
        }
        if (!this.connected) {
            throw new TimeoutException("Could not connect to ZooKeeper " + this.zkServerAddress + " within " + waitForConnection + " ms");
        }
        log.info("Client is connected to ZooKeeper");
    }

    public synchronized void waitForDisconnected(long timeout) throws InterruptedException, TimeoutException {
        long expire = System.currentTimeMillis() + timeout;
        long left = timeout;
        while (this.connected && left > 0L) {
            this.wait(left);
            left = expire - System.currentTimeMillis();
        }
        if (this.connected) {
            throw new TimeoutException("Did not disconnect");
        }
    }

    private void closeKeeper(SolrZooKeeper keeper) {
        try {
            keeper.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
    }
}

