/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.ByteUtils;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.FastOutputStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.noggit.CharArr;

public class JavaBinCodec {
    public static final byte NULL = 0;
    public static final byte BOOL_TRUE = 1;
    public static final byte BOOL_FALSE = 2;
    public static final byte BYTE = 3;
    public static final byte SHORT = 4;
    public static final byte DOUBLE = 5;
    public static final byte INT = 6;
    public static final byte LONG = 7;
    public static final byte FLOAT = 8;
    public static final byte DATE = 9;
    public static final byte MAP = 10;
    public static final byte SOLRDOC = 11;
    public static final byte SOLRDOCLST = 12;
    public static final byte BYTEARR = 13;
    public static final byte ITERATOR = 14;
    public static final byte END = 15;
    public static final byte SOLRINPUTDOC = 16;
    public static final byte TAG_AND_LEN = 32;
    public static final byte STR = 32;
    public static final byte SINT = 64;
    public static final byte SLONG = 96;
    public static final byte ARR = -128;
    public static final byte ORDERED_MAP = -96;
    public static final byte NAMED_LST = -64;
    public static final byte EXTERN_STRING = -32;
    private static byte VERSION = (byte)2;
    private ObjectResolver resolver;
    protected FastOutputStream daos;
    byte version;
    protected static final Object END_OBJ = new Object();
    protected byte tagByte;
    byte[] bytes;
    CharArr arr = new CharArr();
    private int stringsCount = 0;
    private Map<String, Integer> stringsMap;
    private List<String> stringsList;

    public JavaBinCodec() {
    }

    public JavaBinCodec(ObjectResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object nl, OutputStream os) throws IOException {
        this.init(FastOutputStream.wrap(os));
        try {
            this.daos.writeByte(VERSION);
            this.writeVal(nl);
        }
        finally {
            this.daos.flushBuffer();
        }
    }

    public void init(FastOutputStream os) {
        this.daos = os;
    }

    public Object unmarshal(InputStream is) throws IOException {
        FastInputStream dis = FastInputStream.wrap(is);
        this.version = dis.readByte();
        if (this.version != VERSION) {
            throw new RuntimeException("Invalid version (expected " + VERSION + ", but " + this.version + ") or the data in not in 'javabin' format");
        }
        return this.readVal(dis);
    }

    public SimpleOrderedMap<Object> readOrderedMap(DataInputInputStream dis) throws IOException {
        int sz = this.readSize(dis);
        SimpleOrderedMap<Object> nl = new SimpleOrderedMap<Object>();
        for (int i = 0; i < sz; ++i) {
            String name = (String)this.readVal(dis);
            Object val = this.readVal(dis);
            nl.add(name, val);
        }
        return nl;
    }

    public NamedList<Object> readNamedList(DataInputInputStream dis) throws IOException {
        int sz = this.readSize(dis);
        NamedList<Object> nl = new NamedList<Object>();
        for (int i = 0; i < sz; ++i) {
            String name = (String)this.readVal(dis);
            Object val = this.readVal(dis);
            nl.add(name, val);
        }
        return nl;
    }

    public void writeNamedList(NamedList<?> nl) throws IOException {
        this.writeTag(nl instanceof SimpleOrderedMap ? (byte)-96 : -64, nl.size());
        for (int i = 0; i < nl.size(); ++i) {
            String name = nl.getName(i);
            this.writeExternString(name);
            Object val = nl.getVal(i);
            this.writeVal(val);
        }
    }

    public void writeVal(Object val) throws IOException {
        if (this.writeKnownType(val)) {
            return;
        }
        Object tmpVal = val;
        if (this.resolver != null) {
            tmpVal = this.resolver.resolve(val, this);
            if (tmpVal == null) {
                return;
            }
            if (this.writeKnownType(tmpVal)) {
                return;
            }
        }
        this.writeVal(val.getClass().getName() + ':' + val.toString());
    }

    public Object readVal(DataInputInputStream dis) throws IOException {
        this.tagByte = dis.readByte();
        switch (this.tagByte >>> 5) {
            case 1: {
                return this.readStr(dis);
            }
            case 2: {
                return this.readSmallInt(dis);
            }
            case 3: {
                return this.readSmallLong(dis);
            }
            case 0x7FFFFFC: {
                return this.readArray(dis);
            }
            case 0x7FFFFFD: {
                return this.readOrderedMap(dis);
            }
            case 0x7FFFFFE: {
                return this.readNamedList(dis);
            }
            case 0x7FFFFFF: {
                return this.readExternString(dis);
            }
        }
        switch (this.tagByte) {
            case 0: {
                return null;
            }
            case 9: {
                return new Date(dis.readLong());
            }
            case 6: {
                return dis.readInt();
            }
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return Boolean.FALSE;
            }
            case 8: {
                return Float.valueOf(dis.readFloat());
            }
            case 5: {
                return dis.readDouble();
            }
            case 7: {
                return dis.readLong();
            }
            case 3: {
                return dis.readByte();
            }
            case 4: {
                return dis.readShort();
            }
            case 10: {
                return this.readMap(dis);
            }
            case 11: {
                return this.readSolrDocument(dis);
            }
            case 12: {
                return this.readSolrDocumentList(dis);
            }
            case 13: {
                return this.readByteArray(dis);
            }
            case 14: {
                return this.readIterator(dis);
            }
            case 15: {
                return END_OBJ;
            }
            case 16: {
                return this.readSolrInputDocument(dis);
            }
        }
        throw new RuntimeException("Unknown type " + this.tagByte);
    }

    public boolean writeKnownType(Object val) throws IOException {
        if (this.writePrimitive(val)) {
            return true;
        }
        if (val instanceof NamedList) {
            this.writeNamedList((NamedList)val);
            return true;
        }
        if (val instanceof SolrDocumentList) {
            this.writeSolrDocumentList((SolrDocumentList)val);
            return true;
        }
        if (val instanceof Collection) {
            this.writeArray((Collection)val);
            return true;
        }
        if (val instanceof Object[]) {
            this.writeArray((Object[])val);
            return true;
        }
        if (val instanceof SolrDocument) {
            if (this.resolver == null) {
                this.writeSolrDocument((SolrDocument)val);
            } else {
                Object retVal = this.resolver.resolve(val, this);
                if (retVal != null) {
                    if (retVal instanceof SolrDocument) {
                        this.writeSolrDocument((SolrDocument)retVal);
                    } else {
                        this.writeVal(retVal);
                    }
                }
            }
            return true;
        }
        if (val instanceof SolrInputDocument) {
            this.writeSolrInputDocument((SolrInputDocument)val);
            return true;
        }
        if (val instanceof Map) {
            this.writeMap((Map)val);
            return true;
        }
        if (val instanceof Iterator) {
            this.writeIterator((Iterator)val);
            return true;
        }
        if (val instanceof Iterable) {
            this.writeIterator(((Iterable)val).iterator());
            return true;
        }
        return false;
    }

    public void writeTag(byte tag) throws IOException {
        this.daos.writeByte(tag);
    }

    public void writeTag(byte tag, int size) throws IOException {
        if ((tag & 0xE0) != 0) {
            if (size < 31) {
                this.daos.writeByte(tag | size);
            } else {
                this.daos.writeByte(tag | 0x1F);
                JavaBinCodec.writeVInt(size - 31, this.daos);
            }
        } else {
            this.daos.writeByte(tag);
            JavaBinCodec.writeVInt(size, this.daos);
        }
    }

    public void writeByteArray(byte[] arr, int offset, int len) throws IOException {
        this.writeTag((byte)13, len);
        this.daos.write(arr, offset, len);
    }

    public byte[] readByteArray(DataInputInputStream dis) throws IOException {
        byte[] arr = new byte[JavaBinCodec.readVInt(dis)];
        dis.readFully(arr);
        return arr;
    }

    public void writeSolrDocument(SolrDocument doc) throws IOException {
        this.writeTag((byte)11);
        this.writeTag((byte)-96, doc.size());
        for (Map.Entry<String, Object> entry : doc) {
            String name = entry.getKey();
            this.writeExternString(name);
            Object val = entry.getValue();
            this.writeVal(val);
        }
    }

    public SolrDocument readSolrDocument(DataInputInputStream dis) throws IOException {
        NamedList nl = (NamedList)this.readVal(dis);
        SolrDocument doc = new SolrDocument();
        for (int i = 0; i < nl.size(); ++i) {
            String name = nl.getName(i);
            Object val = nl.getVal(i);
            doc.setField(name, val);
        }
        return doc;
    }

    public SolrDocumentList readSolrDocumentList(DataInputInputStream dis) throws IOException {
        SolrDocumentList solrDocs = new SolrDocumentList();
        List list = (List)this.readVal(dis);
        solrDocs.setNumFound((Long)list.get(0));
        solrDocs.setStart((Long)list.get(1));
        solrDocs.setMaxScore((Float)list.get(2));
        List l = (List)this.readVal(dis);
        solrDocs.addAll(l);
        return solrDocs;
    }

    public void writeSolrDocumentList(SolrDocumentList docs) throws IOException {
        this.writeTag((byte)12);
        ArrayList<Number> l = new ArrayList<Number>(3);
        l.add(docs.getNumFound());
        l.add(docs.getStart());
        l.add(docs.getMaxScore());
        this.writeArray(l);
        this.writeArray(docs);
    }

    public SolrInputDocument readSolrInputDocument(DataInputInputStream dis) throws IOException {
        int sz = JavaBinCodec.readVInt(dis);
        float docBoost = ((Float)this.readVal(dis)).floatValue();
        SolrInputDocument sdoc = new SolrInputDocument();
        sdoc.setDocumentBoost(docBoost);
        for (int i = 0; i < sz; ++i) {
            String fieldName;
            float boost = 1.0f;
            Object obj = this.readVal(dis);
            if (obj instanceof Float) {
                boost = ((Float)obj).floatValue();
                fieldName = (String)this.readVal(dis);
            } else {
                if (obj instanceof SolrInputDocument) {
                    sdoc.addChildDocument((SolrInputDocument)obj);
                    continue;
                }
                fieldName = (String)obj;
            }
            Object fieldVal = this.readVal(dis);
            sdoc.setField(fieldName, fieldVal, boost);
        }
        return sdoc;
    }

    public void writeSolrInputDocument(SolrInputDocument sdoc) throws IOException {
        List<SolrInputDocument> children = sdoc.getChildDocuments();
        int sz = sdoc.size() + (children == null ? 0 : children.size());
        this.writeTag((byte)16, sz);
        this.writeFloat(sdoc.getDocumentBoost());
        for (SolrInputField inputField : sdoc.values()) {
            if (inputField.getBoost() != 1.0f) {
                this.writeFloat(inputField.getBoost());
            }
            this.writeExternString(inputField.getName());
            this.writeVal(inputField.getValue());
        }
        if (children != null) {
            for (SolrInputDocument child : sdoc.getChildDocuments()) {
                this.writeSolrInputDocument(child);
            }
        }
    }

    public Map<Object, Object> readMap(DataInputInputStream dis) throws IOException {
        int sz = JavaBinCodec.readVInt(dis);
        LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < sz; ++i) {
            Object key = this.readVal(dis);
            Object val = this.readVal(dis);
            m.put(key, val);
        }
        return m;
    }

    public void writeIterator(Iterator iter) throws IOException {
        this.writeTag((byte)14);
        while (iter.hasNext()) {
            this.writeVal(iter.next());
        }
        this.writeVal(END_OBJ);
    }

    public List<Object> readIterator(DataInputInputStream fis) throws IOException {
        Object o;
        ArrayList<Object> l = new ArrayList<Object>();
        while ((o = this.readVal(fis)) != END_OBJ) {
            l.add(o);
        }
        return l;
    }

    public void writeArray(List l) throws IOException {
        this.writeTag((byte)-128, l.size());
        for (int i = 0; i < l.size(); ++i) {
            this.writeVal(l.get(i));
        }
    }

    public void writeArray(Collection coll) throws IOException {
        this.writeTag((byte)-128, coll.size());
        for (Object o : coll) {
            this.writeVal(o);
        }
    }

    public void writeArray(Object[] arr) throws IOException {
        this.writeTag((byte)-128, arr.length);
        for (int i = 0; i < arr.length; ++i) {
            Object o = arr[i];
            this.writeVal(o);
        }
    }

    public List<Object> readArray(DataInputInputStream dis) throws IOException {
        int sz = this.readSize(dis);
        ArrayList<Object> l = new ArrayList<Object>(sz);
        for (int i = 0; i < sz; ++i) {
            l.add(this.readVal(dis));
        }
        return l;
    }

    public void writeStr(String s) throws IOException {
        if (s == null) {
            this.writeTag((byte)0);
            return;
        }
        int end = s.length();
        int maxSize = end * 4;
        if (this.bytes == null || this.bytes.length < maxSize) {
            this.bytes = new byte[maxSize];
        }
        int sz = ByteUtils.UTF16toUTF8(s, 0, end, this.bytes, 0);
        this.writeTag((byte)32, sz);
        this.daos.write(this.bytes, 0, sz);
    }

    public String readStr(DataInputInputStream dis) throws IOException {
        int sz = this.readSize(dis);
        if (this.bytes == null || this.bytes.length < sz) {
            this.bytes = new byte[sz];
        }
        dis.readFully(this.bytes, 0, sz);
        this.arr.reset();
        ByteUtils.UTF8toUTF16(this.bytes, 0, sz, this.arr);
        return this.arr.toString();
    }

    public void writeInt(int val) throws IOException {
        if (val > 0) {
            int b = 0x40 | val & 0xF;
            if (val >= 15) {
                this.daos.writeByte(b |= 0x10);
                JavaBinCodec.writeVInt(val >>> 4, this.daos);
            } else {
                this.daos.writeByte(b);
            }
        } else {
            this.daos.writeByte(6);
            this.daos.writeInt(val);
        }
    }

    public int readSmallInt(DataInputInputStream dis) throws IOException {
        int v = this.tagByte & 0xF;
        if ((this.tagByte & 0x10) != 0) {
            v = JavaBinCodec.readVInt(dis) << 4 | v;
        }
        return v;
    }

    public void writeLong(long val) throws IOException {
        if ((val & 0xFF00000000000000L) == 0L) {
            int b = 0x60 | (int)val & 0xF;
            if (val >= 15L) {
                this.daos.writeByte(b |= 0x10);
                JavaBinCodec.writeVLong(val >>> 4, this.daos);
            } else {
                this.daos.writeByte(b);
            }
        } else {
            this.daos.writeByte(7);
            this.daos.writeLong(val);
        }
    }

    public long readSmallLong(DataInputInputStream dis) throws IOException {
        long v = this.tagByte & 0xF;
        if ((this.tagByte & 0x10) != 0) {
            v = JavaBinCodec.readVLong(dis) << 4 | v;
        }
        return v;
    }

    public void writeFloat(float val) throws IOException {
        this.daos.writeByte(8);
        this.daos.writeFloat(val);
    }

    public boolean writePrimitive(Object val) throws IOException {
        if (val == null) {
            this.daos.writeByte(0);
            return true;
        }
        if (val instanceof String) {
            this.writeStr((String)val);
            return true;
        }
        if (val instanceof Number) {
            if (val instanceof Integer) {
                this.writeInt((Integer)val);
                return true;
            }
            if (val instanceof Long) {
                this.writeLong((Long)val);
                return true;
            }
            if (val instanceof Float) {
                this.writeFloat(((Float)val).floatValue());
                return true;
            }
            if (val instanceof Double) {
                this.daos.writeByte(5);
                this.daos.writeDouble((Double)val);
                return true;
            }
            if (val instanceof Byte) {
                this.daos.writeByte(3);
                this.daos.writeByte(((Byte)val).intValue());
                return true;
            }
            if (val instanceof Short) {
                this.daos.writeByte(4);
                this.daos.writeShort(((Short)val).intValue());
                return true;
            }
            return false;
        }
        if (val instanceof Date) {
            this.daos.writeByte(9);
            this.daos.writeLong(((Date)val).getTime());
            return true;
        }
        if (val instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                this.daos.writeByte(1);
            } else {
                this.daos.writeByte(2);
            }
            return true;
        }
        if (val instanceof byte[]) {
            this.writeByteArray((byte[])val, 0, ((byte[])val).length);
            return true;
        }
        if (val instanceof ByteBuffer) {
            ByteBuffer buf = (ByteBuffer)val;
            this.writeByteArray(buf.array(), buf.position(), buf.limit() - buf.position());
            return true;
        }
        if (val == END_OBJ) {
            this.writeTag((byte)15);
            return true;
        }
        return false;
    }

    public void writeMap(Map<?, ?> val) throws IOException {
        this.writeTag((byte)10, val.size());
        for (Map.Entry<?, ?> entry : val.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                this.writeExternString((String)key);
            } else {
                this.writeVal(key);
            }
            this.writeVal(entry.getValue());
        }
    }

    public int readSize(DataInputInputStream in) throws IOException {
        int sz = this.tagByte & 0x1F;
        if (sz == 31) {
            sz += JavaBinCodec.readVInt(in);
        }
        return sz;
    }

    public static void writeVInt(int i, FastOutputStream out) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            out.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        out.writeByte((byte)i);
    }

    public static int readVInt(DataInputInputStream in) throws IOException {
        byte b = in.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public static void writeVLong(long i, FastOutputStream out) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        out.writeByte((byte)i);
    }

    public static long readVLong(DataInputInputStream in) throws IOException {
        byte b = in.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            i |= (long)(b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public void writeExternString(String s) throws IOException {
        Integer idx;
        if (s == null) {
            this.writeTag((byte)0);
            return;
        }
        Integer n = idx = this.stringsMap == null ? null : this.stringsMap.get(s);
        if (idx == null) {
            idx = 0;
        }
        this.writeTag((byte)-32, idx);
        if (idx == 0) {
            this.writeStr(s);
            if (this.stringsMap == null) {
                this.stringsMap = new HashMap<String, Integer>();
            }
            this.stringsMap.put(s, ++this.stringsCount);
        }
    }

    public String readExternString(DataInputInputStream fis) throws IOException {
        int idx = this.readSize(fis);
        if (idx != 0) {
            return this.stringsList.get(idx - 1);
        }
        String s = (String)this.readVal(fis);
        if (this.stringsList == null) {
            this.stringsList = new ArrayList<String>();
        }
        this.stringsList.add(s);
        return s;
    }

    public static interface ObjectResolver {
        public Object resolve(Object var1, JavaBinCodec var2) throws IOException;
    }
}

