/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.LongDoubleProcedure;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractLongDoubleMap
extends AbstractSet {
    public boolean containsKey(final long key) {
        return !this.forEachKey(new LongProcedure(){

            public boolean apply(long iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final double value) {
        return !this.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long iterKey, double iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractLongDoubleMap copy() {
        return (AbstractLongDoubleMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractLongDoubleMap)) {
            return false;
        }
        final AbstractLongDoubleMap other = (AbstractLongDoubleMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long key, double value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long key, double value) {
                return AbstractLongDoubleMap.this.containsKey(key) && AbstractLongDoubleMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(LongProcedure var1);

    public boolean forEachPair(final LongDoubleProcedure procedure) {
        return this.forEachKey(new LongProcedure(){

            public boolean apply(long key) {
                return procedure.apply(key, AbstractLongDoubleMap.this.get(key));
            }
        });
    }

    public abstract double get(long var1);

    public LongArrayList keys() {
        LongArrayList list = new LongArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final LongArrayList list) {
        list.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(LongArrayList keyList) {
        this.pairsSortedByValue(keyList, new DoubleArrayList(this.size()));
    }

    public void pairsMatching(final LongDoubleProcedure condition, final LongArrayList keyList, final DoubleArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long key, double value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(LongArrayList keyList, DoubleArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(LongArrayList keyList, DoubleArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final long[] k = keyList.elements();
        final double[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                double t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                long t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(long var1, double var3);

    public abstract boolean removeKey(long var1);

    public String toString() {
        LongArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            long key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        LongArrayList theKeys = new LongArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            long key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public DoubleArrayList values() {
        DoubleArrayList list = new DoubleArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final DoubleArrayList list) {
        list.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long key) {
                list.add(AbstractLongDoubleMap.this.get(key));
                return true;
            }
        });
    }

    public void assign(final DoubleFunction function) {
        this.copy().forEachPair(new LongDoubleProcedure(){

            public boolean apply(long key, double value) {
                AbstractLongDoubleMap.this.put(key, function.apply(value));
                return true;
            }
        });
    }

    public void assign(AbstractLongDoubleMap other) {
        this.clear();
        other.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long key, double value) {
                AbstractLongDoubleMap.this.put(key, value);
                return true;
            }
        });
    }

    public double adjustOrPutValue(long key, double newValue, double incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

