/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.stc;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.text.clustering.MultilingualClusteringDescriptor;
import org.carrot2.text.preprocessing.pipeline.IPreprocessingPipeline;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class STCClusteringAlgorithmDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.clustering.stc.STCClusteringAlgorithm";
    public final String prefix = "STCClusteringAlgorithm";
    public final String title = "Suffix Tree Clustering (STC) algorithm";
    public final String label = "STC Clustering";
    public final String description = "Pretty much as described in: <i>Oren Zamir, Oren Etzioni, Grouper: A Dynamic Clustering Interface to Web Search Results, 1999.</i> Some liberties were taken wherever STC's description was not clear enough or where we thought some improvements could be made.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "STCClusteringAlgorithm";
    }

    public String getTitle() {
        return "Suffix Tree Clustering (STC) algorithm";
    }

    public String getLabel() {
        return "STC Clustering";
    }

    public String getDescription() {
        return "Pretty much as described in: <i>Oren Zamir, Oren Etzioni, Grouper: A Dynamic Clustering Interface to Web Search Results, 1999.</i> Some liberties were taken wherever STC's description was not clear enough or where we thought some improvements could be made.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.query);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.documents);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.clusters);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.ignoreWordIfInFewerDocs);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.ignoreWordIfInHigherDocsPercent);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.minBaseClusterScore);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.maxBaseClusters);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.minBaseClusterSize);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.maxClusters);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.mergeThreshold);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.maxPhraseOverlap);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.mostGeneralPhraseCoverage);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.maxDescPhraseLength);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.maxPhrases);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.singleTermBoost);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.optimalPhraseLength);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.optimalPhraseLengthDev);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.documentCountBoost);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.preprocessingPipeline);
        ownAttrs.add(STCClusteringAlgorithmDescriptor.attributes.scoreWeight);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.query);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.documents);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.clusters);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.ignoreWordIfInFewerDocs);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.ignoreWordIfInHigherDocsPercent);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.minBaseClusterScore);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.maxBaseClusters);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.minBaseClusterSize);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.maxClusters);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.mergeThreshold);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.maxPhraseOverlap);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.mostGeneralPhraseCoverage);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.maxDescPhraseLength);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.maxPhrases);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.singleTermBoost);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.optimalPhraseLength);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.optimalPhraseLengthDev);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.documentCountBoost);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.preprocessingPipeline);
        allAttrs.add(STCClusteringAlgorithmDescriptor.attributes.scoreWeight);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder query(String value) {
            this.map.put("query", value);
            return this;
        }

        public AttributeBuilder query(IObjectFactory<? extends String> value) {
            this.map.put("query", value);
            return this;
        }

        public AttributeBuilder documents(List<Document> value) {
            this.map.put("documents", value);
            return this;
        }

        public AttributeBuilder documents(IObjectFactory<? extends List<Document>> value) {
            this.map.put("documents", value);
            return this;
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }

        public AttributeBuilder ignoreWordIfInFewerDocs(int value) {
            this.map.put("STCClusteringAlgorithm.ignoreWordIfInFewerDocs", value);
            return this;
        }

        public AttributeBuilder ignoreWordIfInFewerDocs(IObjectFactory<? extends Integer> value) {
            this.map.put("STCClusteringAlgorithm.ignoreWordIfInFewerDocs", value);
            return this;
        }

        public AttributeBuilder ignoreWordIfInHigherDocsPercent(double value) {
            this.map.put("STCClusteringAlgorithm.ignoreWordIfInHigherDocsPercent", value);
            return this;
        }

        public AttributeBuilder ignoreWordIfInHigherDocsPercent(IObjectFactory<? extends Double> value) {
            this.map.put("STCClusteringAlgorithm.ignoreWordIfInHigherDocsPercent", value);
            return this;
        }

        public AttributeBuilder minBaseClusterScore(double value) {
            this.map.put("STCClusteringAlgorithm.minBaseClusterScore", value);
            return this;
        }

        public AttributeBuilder minBaseClusterScore(IObjectFactory<? extends Double> value) {
            this.map.put("STCClusteringAlgorithm.minBaseClusterScore", value);
            return this;
        }

        public AttributeBuilder maxBaseClusters(int value) {
            this.map.put("STCClusteringAlgorithm.maxBaseClusters", value);
            return this;
        }

        public AttributeBuilder maxBaseClusters(IObjectFactory<? extends Integer> value) {
            this.map.put("STCClusteringAlgorithm.maxBaseClusters", value);
            return this;
        }

        public AttributeBuilder minBaseClusterSize(int value) {
            this.map.put("STCClusteringAlgorithm.minBaseClusterSize", value);
            return this;
        }

        public AttributeBuilder minBaseClusterSize(IObjectFactory<? extends Integer> value) {
            this.map.put("STCClusteringAlgorithm.minBaseClusterSize", value);
            return this;
        }

        public AttributeBuilder maxClusters(int value) {
            this.map.put("STCClusteringAlgorithm.maxClusters", value);
            return this;
        }

        public AttributeBuilder maxClusters(IObjectFactory<? extends Integer> value) {
            this.map.put("STCClusteringAlgorithm.maxClusters", value);
            return this;
        }

        public AttributeBuilder mergeThreshold(double value) {
            this.map.put("STCClusteringAlgorithm.mergeThreshold", value);
            return this;
        }

        public AttributeBuilder mergeThreshold(IObjectFactory<? extends Double> value) {
            this.map.put("STCClusteringAlgorithm.mergeThreshold", value);
            return this;
        }

        public AttributeBuilder maxPhraseOverlap(double value) {
            this.map.put("STCClusteringAlgorithm.maxPhraseOverlap", value);
            return this;
        }

        public AttributeBuilder maxPhraseOverlap(IObjectFactory<? extends Double> value) {
            this.map.put("STCClusteringAlgorithm.maxPhraseOverlap", value);
            return this;
        }

        public AttributeBuilder mostGeneralPhraseCoverage(double value) {
            this.map.put("STCClusteringAlgorithm.mostGeneralPhraseCoverage", value);
            return this;
        }

        public AttributeBuilder mostGeneralPhraseCoverage(IObjectFactory<? extends Double> value) {
            this.map.put("STCClusteringAlgorithm.mostGeneralPhraseCoverage", value);
            return this;
        }

        public AttributeBuilder maxDescPhraseLength(int value) {
            this.map.put("STCClusteringAlgorithm.maxDescPhraseLength", value);
            return this;
        }

        public AttributeBuilder maxDescPhraseLength(IObjectFactory<? extends Integer> value) {
            this.map.put("STCClusteringAlgorithm.maxDescPhraseLength", value);
            return this;
        }

        public AttributeBuilder maxPhrases(int value) {
            this.map.put("STCClusteringAlgorithm.maxPhrases", value);
            return this;
        }

        public AttributeBuilder maxPhrases(IObjectFactory<? extends Integer> value) {
            this.map.put("STCClusteringAlgorithm.maxPhrases", value);
            return this;
        }

        public AttributeBuilder singleTermBoost(double value) {
            this.map.put("STCClusteringAlgorithm.singleTermBoost", value);
            return this;
        }

        public AttributeBuilder singleTermBoost(IObjectFactory<? extends Double> value) {
            this.map.put("STCClusteringAlgorithm.singleTermBoost", value);
            return this;
        }

        public AttributeBuilder optimalPhraseLength(int value) {
            this.map.put("STCClusteringAlgorithm.optimalPhraseLength", value);
            return this;
        }

        public AttributeBuilder optimalPhraseLength(IObjectFactory<? extends Integer> value) {
            this.map.put("STCClusteringAlgorithm.optimalPhraseLength", value);
            return this;
        }

        public AttributeBuilder optimalPhraseLengthDev(double value) {
            this.map.put("STCClusteringAlgorithm.optimalPhraseLengthDev", value);
            return this;
        }

        public AttributeBuilder optimalPhraseLengthDev(IObjectFactory<? extends Double> value) {
            this.map.put("STCClusteringAlgorithm.optimalPhraseLengthDev", value);
            return this;
        }

        public AttributeBuilder documentCountBoost(double value) {
            this.map.put("STCClusteringAlgorithm.documentCountBoost", value);
            return this;
        }

        public AttributeBuilder documentCountBoost(IObjectFactory<? extends Double> value) {
            this.map.put("STCClusteringAlgorithm.documentCountBoost", value);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(IPreprocessingPipeline value) {
            this.map.put("STCClusteringAlgorithm.preprocessingPipeline", value);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(Class<?> clazz) {
            this.map.put("STCClusteringAlgorithm.preprocessingPipeline", clazz);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(IObjectFactory<? extends IPreprocessingPipeline> value) {
            this.map.put("STCClusteringAlgorithm.preprocessingPipeline", value);
            return this;
        }

        public AttributeBuilder scoreWeight(double value) {
            this.map.put("STCClusteringAlgorithm.scoreWeight", value);
            return this;
        }

        public AttributeBuilder scoreWeight(IObjectFactory<? extends Double> value) {
            this.map.put("STCClusteringAlgorithm.scoreWeight", value);
            return this;
        }

        public MultilingualClusteringDescriptor.AttributeBuilder multilingualClustering() {
            return MultilingualClusteringDescriptor.attributeBuilder(this.map);
        }
    }

    public static final class Attributes {
        public final AttributeInfo query;
        public final AttributeInfo documents;
        public final AttributeInfo clusters;
        public final AttributeInfo ignoreWordIfInFewerDocs;
        public final AttributeInfo ignoreWordIfInHigherDocsPercent;
        public final AttributeInfo minBaseClusterScore;
        public final AttributeInfo maxBaseClusters;
        public final AttributeInfo minBaseClusterSize;
        public final AttributeInfo maxClusters;
        public final AttributeInfo mergeThreshold;
        public final AttributeInfo maxPhraseOverlap;
        public final AttributeInfo mostGeneralPhraseCoverage;
        public final AttributeInfo maxDescPhraseLength;
        public final AttributeInfo maxPhrases;
        public final AttributeInfo singleTermBoost;
        public final AttributeInfo optimalPhraseLength;
        public final AttributeInfo optimalPhraseLengthDev;
        public final AttributeInfo documentCountBoost;
        public final AttributeInfo preprocessingPipeline;
        public final AttributeInfo scoreWeight;
        public final MultilingualClusteringDescriptor.Attributes multilingualClustering;

        private Attributes() {
            this.query = new AttributeInfo("query", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "query", "Query that produced the documents. The query will help the algorithm to create\nbetter clusters. Therefore, providing the query is optional but desirable.", null, "Query that produced the documents", "The query will help the algorithm to create better clusters. Therefore, providing the query is optional but desirable.", null, null, CommonAttributesDescriptor.attributes.query);
            this.documents = new AttributeInfo("documents", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "documents", "Documents to cluster.", null, "Documents to cluster", null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.clusters = new AttributeInfo("clusters", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "clusters", "Clusters created by the algorithm.", null, "Clusters created by the algorithm", null, null, null, CommonAttributesDescriptor.attributes.clusters);
            this.ignoreWordIfInFewerDocs = new AttributeInfo("STCClusteringAlgorithm.ignoreWordIfInFewerDocs", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "ignoreWordIfInFewerDocs", "Minimum word-document recurrences.", null, "Minimum word-document recurrences", null, "Word filtering", AttributeLevel.MEDIUM, null);
            this.ignoreWordIfInHigherDocsPercent = new AttributeInfo("STCClusteringAlgorithm.ignoreWordIfInHigherDocsPercent", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "ignoreWordIfInHigherDocsPercent", "Maximum word-document ratio. A number between 0 and 1, if a word exists in more\nsnippets than this ratio, it is ignored.", null, "Maximum word-document ratio", "A number between 0 and 1, if a word exists in more snippets than this ratio, it is ignored.", "Word filtering", AttributeLevel.MEDIUM, null);
            this.minBaseClusterScore = new AttributeInfo("STCClusteringAlgorithm.minBaseClusterScore", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "minBaseClusterScore", "Minimum base cluster score.", null, "Minimum base cluster score", null, "Base clusters", AttributeLevel.ADVANCED, null);
            this.maxBaseClusters = new AttributeInfo("STCClusteringAlgorithm.maxBaseClusters", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "maxBaseClusters", "Maximum base clusters count. Trims the base cluster array after N-th position for\nthe merging phase.", null, "Maximum base clusters count", "Trims the base cluster array after N-th position for the merging phase.", "Base clusters", AttributeLevel.ADVANCED, null);
            this.minBaseClusterSize = new AttributeInfo("STCClusteringAlgorithm.minBaseClusterSize", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "minBaseClusterSize", "Minimum documents per base cluster.", null, "Minimum documents per base cluster", null, "Base clusters", AttributeLevel.ADVANCED, null);
            this.maxClusters = new AttributeInfo("STCClusteringAlgorithm.maxClusters", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "maxClusters", "Maximum final clusters.", null, "Maximum final clusters", null, "Merging and output", AttributeLevel.BASIC, null);
            this.mergeThreshold = new AttributeInfo("STCClusteringAlgorithm.mergeThreshold", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "mergeThreshold", "Base cluster merge threshold.", null, "Base cluster merge threshold", null, "Merging and output", AttributeLevel.ADVANCED, null);
            this.maxPhraseOverlap = new AttributeInfo("STCClusteringAlgorithm.maxPhraseOverlap", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "maxPhraseOverlap", "Maximum cluster phrase overlap.", null, "Maximum cluster phrase overlap", null, "Labels", AttributeLevel.ADVANCED, null);
            this.mostGeneralPhraseCoverage = new AttributeInfo("STCClusteringAlgorithm.mostGeneralPhraseCoverage", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "mostGeneralPhraseCoverage", "Minimum general phrase coverage. Minimum phrase coverage to appear in cluster\ndescription.", null, "Minimum general phrase coverage", "Minimum phrase coverage to appear in cluster description.", "Labels", AttributeLevel.ADVANCED, null);
            this.maxDescPhraseLength = new AttributeInfo("STCClusteringAlgorithm.maxDescPhraseLength", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "maxDescPhraseLength", "Maximum words per label. Base clusters formed by phrases with more words than this\nratio are trimmed.", null, "Maximum words per label", "Base clusters formed by phrases with more words than this ratio are trimmed.", "Labels", AttributeLevel.BASIC, null);
            this.maxPhrases = new AttributeInfo("STCClusteringAlgorithm.maxPhrases", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "maxPhrases", "Maximum phrases per label. Maximum number of phrases from base clusters promoted\nto the cluster's label.", null, "Maximum phrases per label", "Maximum number of phrases from base clusters promoted to the cluster's label.", "Labels", AttributeLevel.BASIC, null);
            this.singleTermBoost = new AttributeInfo("STCClusteringAlgorithm.singleTermBoost", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "singleTermBoost", "Single term boost. A factor in calculation of the base cluster score. If greater\nthen zero, single-term base clusters are assigned this value regardless of the\npenalty function.", null, "Single term boost", "A factor in calculation of the base cluster score. If greater then zero, single-term base clusters are assigned this value regardless of the penalty function.", "Base clusters", AttributeLevel.MEDIUM, null);
            this.optimalPhraseLength = new AttributeInfo("STCClusteringAlgorithm.optimalPhraseLength", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "optimalPhraseLength", "Optimal label length. A factor in calculation of the base cluster score.", null, "Optimal label length", "A factor in calculation of the base cluster score.", "Base clusters", AttributeLevel.BASIC, null);
            this.optimalPhraseLengthDev = new AttributeInfo("STCClusteringAlgorithm.optimalPhraseLengthDev", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "optimalPhraseLengthDev", "Phrase length tolerance. A factor in calculation of the base cluster score.", null, "Phrase length tolerance", "A factor in calculation of the base cluster score.", "Base clusters", AttributeLevel.MEDIUM, null);
            this.documentCountBoost = new AttributeInfo("STCClusteringAlgorithm.documentCountBoost", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "documentCountBoost", "Document count boost. A factor in calculation of the base cluster score, boosting\nthe score depending on the number of documents found in the base cluster.", null, "Document count boost", "A factor in calculation of the base cluster score, boosting the score depending on the number of documents found in the base cluster.", "Base clusters", AttributeLevel.MEDIUM, null);
            this.preprocessingPipeline = new AttributeInfo("STCClusteringAlgorithm.preprocessingPipeline", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "preprocessingPipeline", "Common preprocessing tasks handler.", null, "Common preprocessing tasks handler", null, null, AttributeLevel.ADVANCED, null);
            this.scoreWeight = new AttributeInfo("STCClusteringAlgorithm.scoreWeight", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "scoreWeight", "Balance between cluster score and size during cluster sorting. Value equal to 0.0\nwill sort clusters based only on cluster size. Value equal to 1.0\nwill sort clusters based only on cluster score.", "Size-Score sorting ratio", "Balance between cluster score and size during cluster sorting", "Value equal to 0.0 will sort clusters based only on cluster size. Value equal to 1.0 will sort clusters based only on cluster score.", "Clusters", AttributeLevel.MEDIUM, null);
            this.multilingualClustering = MultilingualClusteringDescriptor.attributes;
        }
    }

    public static class Keys {
        public static final String QUERY = "query";
        public static final String DOCUMENTS = "documents";
        public static final String CLUSTERS = "clusters";
        public static final String IGNORE_WORD_IF_IN_FEWER_DOCS = "STCClusteringAlgorithm.ignoreWordIfInFewerDocs";
        public static final String IGNORE_WORD_IF_IN_HIGHER_DOCS_PERCENT = "STCClusteringAlgorithm.ignoreWordIfInHigherDocsPercent";
        public static final String MIN_BASE_CLUSTER_SCORE = "STCClusteringAlgorithm.minBaseClusterScore";
        public static final String MAX_BASE_CLUSTERS = "STCClusteringAlgorithm.maxBaseClusters";
        public static final String MIN_BASE_CLUSTER_SIZE = "STCClusteringAlgorithm.minBaseClusterSize";
        public static final String MAX_CLUSTERS = "STCClusteringAlgorithm.maxClusters";
        public static final String MERGE_THRESHOLD = "STCClusteringAlgorithm.mergeThreshold";
        public static final String MAX_PHRASE_OVERLAP = "STCClusteringAlgorithm.maxPhraseOverlap";
        public static final String MOST_GENERAL_PHRASE_COVERAGE = "STCClusteringAlgorithm.mostGeneralPhraseCoverage";
        public static final String MAX_DESC_PHRASE_LENGTH = "STCClusteringAlgorithm.maxDescPhraseLength";
        public static final String MAX_PHRASES = "STCClusteringAlgorithm.maxPhrases";
        public static final String SINGLE_TERM_BOOST = "STCClusteringAlgorithm.singleTermBoost";
        public static final String OPTIMAL_PHRASE_LENGTH = "STCClusteringAlgorithm.optimalPhraseLength";
        public static final String OPTIMAL_PHRASE_LENGTH_DEV = "STCClusteringAlgorithm.optimalPhraseLengthDev";
        public static final String DOCUMENT_COUNT_BOOST = "STCClusteringAlgorithm.documentCountBoost";
        public static final String PREPROCESSING_PIPELINE = "STCClusteringAlgorithm.preprocessingPipeline";
        public static final String SCORE_WEIGHT = "STCClusteringAlgorithm.scoreWeight";

        protected Keys() {
        }
    }
}

