/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic.lucene;

import java.io.IOException;
import java.io.Reader;
import java.text.BreakIterator;
import java.util.Locale;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.th.ThaiWordFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.Version;
import org.carrot2.text.analysis.ITokenizer;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.util.ExceptionUtils;

public final class ThaiTokenizerAdapter
implements ITokenizer {
    private TokenStream wordTokenFilter;
    private CharTermAttribute term = null;
    private TypeAttribute type = null;
    private final MutableCharArray tempCharSequence = new MutableCharArray(new char[0]);

    public ThaiTokenizerAdapter() {
        if (!ThaiTokenizerAdapter.platformSupportsThai()) {
            throw new RuntimeException("Thai segmentation not supported on this platform.");
        }
    }

    @Override
    public short nextToken() throws IOException {
        boolean hasNextToken = this.wordTokenFilter.incrementToken();
        if (hasNextToken) {
            char[] image = this.term.buffer();
            int length = this.term.length();
            this.tempCharSequence.reset(image, 0, length);
            int flags = 0;
            String typeString = this.type.type();
            flags = typeString.equals("<SOUTHEAST_ASIAN>") || typeString.equals("<ALPHANUM>") ? 1 : (typeString.equals("<NUM>") ? 2 : 3);
            return (short)flags;
        }
        return -1;
    }

    @Override
    public void setTermBuffer(MutableCharArray array) {
        array.reset(this.term.buffer(), 0, this.term.length());
    }

    @Override
    public void reset(Reader input) throws IOException {
        assert (input != null);
        try {
            this.wordTokenFilter = new ThaiWordFilter(Version.LUCENE_CURRENT, (TokenStream)new StandardTokenizer(Version.LUCENE_CURRENT, input));
            this.term = (CharTermAttribute)this.wordTokenFilter.addAttribute(CharTermAttribute.class);
            this.type = (TypeAttribute)this.wordTokenFilter.addAttribute(TypeAttribute.class);
            this.wordTokenFilter.reset();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsRuntimeException(e);
        }
    }

    public static boolean platformSupportsThai() {
        try {
            BreakIterator proto = BreakIterator.getWordInstance(new Locale("th"));
            proto.setText("\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22");
            return proto.isBoundary(4);
        }
        catch (Throwable e) {
            return false;
        }
    }
}

