/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfoPerCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.util.LuceneTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RandomMergePolicy
extends MergePolicy {
    public static Logger log = LoggerFactory.getLogger(RandomMergePolicy.class);
    MergePolicy inner;

    public RandomMergePolicy() {
        this(LuceneTestCase.newMergePolicy());
    }

    private RandomMergePolicy(MergePolicy inner) {
        super(inner.getNoCFSRatio(), (long)(inner.getMaxCFSSegmentSizeMB() * 1024.0 * 1024.0));
        this.inner = inner;
        log.info("RandomMergePolicy wrapping {}: {}", inner.getClass(), (Object)inner);
    }

    public RandomMergePolicy clone() {
        RandomMergePolicy clone = (RandomMergePolicy)super.clone();
        clone.inner = this.inner.clone();
        return clone;
    }

    public void close() {
        this.inner.close();
    }

    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos) throws IOException {
        return this.inner.findForcedDeletesMerges(segmentInfos);
    }

    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentInfoPerCommit, Boolean> segmentsToMerge) throws IOException {
        return this.inner.findForcedMerges(segmentInfos, maxSegmentCount, segmentsToMerge);
    }

    public MergePolicy.MergeSpecification findMerges(MergePolicy.MergeTrigger mergeTrigger, SegmentInfos segmentInfos) throws IOException {
        return this.inner.findMerges(mergeTrigger, segmentInfos);
    }

    public void setIndexWriter(IndexWriter writer) {
        this.inner.setIndexWriter(writer);
    }

    public boolean useCompoundFile(SegmentInfos infos, SegmentInfoPerCommit mergedInfo) throws IOException {
        return this.inner.useCompoundFile(infos, mergedInfo);
    }
}

