/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.Properties;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.util.PropertiesUtil;

public class CloudDescriptor {
    private String shardId;
    private String collectionName;
    private SolrParams params;
    private String roles = null;
    private Integer numShards;
    private String nodeName = null;
    volatile String shardRange = null;
    volatile String shardState = Slice.ACTIVE;
    volatile boolean isLeader = false;
    volatile String lastPublished = "active";
    public static final String SHARD_STATE = "shardState";
    public static final String NUM_SHARDS = "numShards";
    public static final String SHARD_RANGE = "shardRange";

    public CloudDescriptor(String coreName, Properties props) {
        this.shardId = props.getProperty("shard", null);
        this.collectionName = props.getProperty("collection", coreName);
        this.roles = props.getProperty("roles", null);
        this.nodeName = props.getProperty("coreNodeName");
        this.shardState = props.getProperty(SHARD_STATE, Slice.ACTIVE);
        this.numShards = PropertiesUtil.toInteger(props.getProperty(NUM_SHARDS), null);
        this.shardRange = props.getProperty(SHARD_RANGE, null);
    }

    public String getLastPublished() {
        return this.lastPublished;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public void setLeader(boolean isLeader) {
        this.isLeader = isLeader;
    }

    public void setShardId(String shardId) {
        this.shardId = shardId;
    }

    public String getShardId() {
        return this.shardId;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public SolrParams getParams() {
        return this.params;
    }

    public void setParams(SolrParams params) {
        this.params = params;
    }

    public Integer getNumShards() {
        return this.numShards;
    }

    public void setNumShards(int numShards) {
        this.numShards = numShards;
    }

    public String getCoreNodeName() {
        return this.nodeName;
    }

    public void setCoreNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getShardRange() {
        return this.shardRange;
    }

    public void setShardRange(String shardRange) {
        this.shardRange = shardRange;
    }

    public String getShardState() {
        return this.shardState;
    }

    public void setShardState(String shardState) {
        this.shardState = shardState;
    }
}

