/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClosableThread;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PlainIdRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerCollectionProcessor
implements Runnable,
ClosableThread {
    public static final String NUM_SLICES = "numShards";
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String MAX_SHARDS_PER_NODE = "maxShardsPerNode";
    public static final String CREATE_NODE_SET = "createNodeSet";
    public static final String DELETECOLLECTION = "deletecollection";
    public static final String CREATECOLLECTION = "createcollection";
    public static final String RELOADCOLLECTION = "reloadcollection";
    public static final String CREATEALIAS = "createalias";
    public static final String DELETEALIAS = "deletealias";
    public static final String SPLITSHARD = "splitshard";
    public static final String DELETESHARD = "deleteshard";
    public static final String ROUTER = "router";
    public static final String SHARDS_PROP = "shards";
    public static final String CREATESHARD = "createshard";
    public static final String COLL_CONF = "collection.configName";
    public static final Map<String, Object> COLL_PROPS = ZkNodeProps.makeMap((Object[])new Object[]{"router", "compositeId", "replicationFactor", "1", "maxShardsPerNode", "1"});
    private static final String QUEUE_OPERATION = "operation";
    private static Logger log = LoggerFactory.getLogger(OverseerCollectionProcessor.class);
    private DistributedQueue workQueue;
    private String myId;
    private ShardHandler shardHandler;
    private String adminPath;
    private ZkStateReader zkStateReader;
    private boolean isClosed;

    public OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath) {
        this(zkStateReader, myId, shardHandler, adminPath, Overseer.getCollectionQueue(zkStateReader.getZkClient()));
    }

    protected OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath, DistributedQueue workQueue) {
        this.zkStateReader = zkStateReader;
        this.myId = myId;
        this.shardHandler = shardHandler;
        this.adminPath = adminPath;
        this.workQueue = workQueue;
    }

    @Override
    public void run() {
        log.info("Process current queue of collection creations");
        while (this.amILeader() && !this.isClosed) {
            try {
                DistributedQueue.QueueEvent head = this.workQueue.peek(true);
                ZkNodeProps message = ZkNodeProps.load((byte[])head.getBytes());
                log.info("Overseer Collection Processor: Get the message id:" + head.getId() + " message:" + message.toString());
                String operation = message.getStr(QUEUE_OPERATION);
                SolrResponse response = this.processMessage(message, operation);
                head.setBytes(SolrResponse.serializable((SolrResponse)response));
                this.workQueue.remove(head);
                log.info("Overseer Collection Processor: Message id:" + head.getId() + " complete, response:" + response.getResponse().toString());
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                    log.warn("Overseer cannot talk to ZK");
                    return;
                }
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable e) {
                SolrException.log((Logger)log, (String)"", (Throwable)e);
            }
        }
    }

    public void close() {
        this.isClosed = true;
    }

    protected boolean amILeader() {
        try {
            ZkNodeProps props = ZkNodeProps.load((byte[])this.zkStateReader.getZkClient().getData("/overseer_elect/leader", null, null, true));
            if (this.myId.equals(props.getStr("id"))) {
                return true;
            }
        }
        catch (KeeperException e) {
            log.warn("", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
        return false;
    }

    protected SolrResponse processMessage(ZkNodeProps message, String operation) {
        NamedList results;
        block10: {
            log.warn("OverseerCollectionProcessor.processMessage : " + operation + " , " + message.toString());
            results = new NamedList();
            try {
                if (CREATECOLLECTION.equals(operation)) {
                    this.createCollection(this.zkStateReader.getClusterState(), message, results);
                    break block10;
                }
                if (DELETECOLLECTION.equals(operation)) {
                    this.deleteCollection(message, results);
                    break block10;
                }
                if (RELOADCOLLECTION.equals(operation)) {
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RELOAD.toString()});
                    this.collectionCmd(this.zkStateReader.getClusterState(), message, params, results, "active");
                    break block10;
                }
                if (CREATEALIAS.equals(operation)) {
                    this.createAlias(this.zkStateReader.getAliases(), message);
                    break block10;
                }
                if (DELETEALIAS.equals(operation)) {
                    this.deleteAlias(this.zkStateReader.getAliases(), message);
                    break block10;
                }
                if (SPLITSHARD.equals(operation)) {
                    this.splitShard(this.zkStateReader.getClusterState(), message, results);
                    break block10;
                }
                if (CREATESHARD.equals(operation)) {
                    this.createShard(this.zkStateReader.getClusterState(), message, results);
                    break block10;
                }
                if (DELETESHARD.equals(operation)) {
                    this.deleteShard(this.zkStateReader.getClusterState(), message, results);
                    break block10;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
            }
            catch (Throwable t) {
                SolrException.log((Logger)log, (String)("Collection " + operation + " of " + operation + " failed"), (Throwable)t);
                results.add("Operation " + operation + " caused exception:", (Object)t);
                SimpleOrderedMap nl = new SimpleOrderedMap();
                nl.add("msg", (Object)t.getMessage());
                nl.add("rspCode", (Object)(t instanceof SolrException ? ((SolrException)t).code() : -1));
                results.add("exception", (Object)nl);
            }
        }
        return new OverseerSolrResponse(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCollection(ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collection = message.getStr("name");
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
            params.set("deleteInstanceDir", true);
            params.set("deleteDataDir", true);
            this.collectionCmd(this.zkStateReader.getClusterState(), message, params, results, null);
            ZkNodeProps m = new ZkNodeProps(new String[]{QUEUE_OPERATION, "removecollection", "name", collection});
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)m));
            long now = System.currentTimeMillis();
            long timeout = now + 30000L;
            boolean removed = false;
            while (System.currentTimeMillis() < timeout) {
                Thread.sleep(100L);
                removed = !this.zkStateReader.getClusterState().getCollections().contains(message.getStr("name"));
                if (!removed) continue;
                Thread.sleep(100L);
                break;
            }
            if (!removed) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully remove collection: " + message.getStr("name"));
            }
        }
        finally {
            try {
                if (this.zkStateReader.getZkClient().exists("/collections/" + collection, true).booleanValue()) {
                    this.zkStateReader.getZkClient().clean("/collections/" + collection);
                }
            }
            catch (InterruptedException e) {
                SolrException.log((Logger)log, (String)("Cleaning up collection in zk was interrupted:" + collection), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (KeeperException e) {
                SolrException.log((Logger)log, (String)("Problem cleaning up collection in zk:" + collection), (Throwable)e);
            }
        }
    }

    private void createAlias(Aliases aliases, ZkNodeProps message) {
        String aliasName = message.getStr("name");
        String collections = message.getStr("collections");
        HashMap newAliasesMap = new HashMap();
        HashMap<String, String> newCollectionAliasesMap = new HashMap<String, String>();
        Map prevColAliases = aliases.getCollectionAliasMap();
        if (prevColAliases != null) {
            newCollectionAliasesMap.putAll(prevColAliases);
        }
        newCollectionAliasesMap.put(aliasName, collections);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = ZkStateReader.toJSON((Object)newAliases.getAliasMap());
        }
        try {
            this.zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAlias(aliasName, collections);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkForAlias(String name, String value) {
        long now = System.currentTimeMillis();
        long timeout = now + 30000L;
        boolean success = false;
        Aliases aliases = null;
        while (System.currentTimeMillis() < timeout) {
            aliases = this.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections == null || !collections.equals(value)) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }

    private void checkForAliasAbsence(String name) {
        long now = System.currentTimeMillis();
        long timeout = now + 30000L;
        boolean success = false;
        Aliases aliases = null;
        while (System.currentTimeMillis() < timeout) {
            aliases = this.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections != null) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }

    private void deleteAlias(Aliases aliases, ZkNodeProps message) {
        String aliasName = message.getStr("name");
        HashMap newAliasesMap = new HashMap();
        HashMap newCollectionAliasesMap = new HashMap();
        newCollectionAliasesMap.putAll(aliases.getCollectionAliasMap());
        newCollectionAliasesMap.remove(aliasName);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = ZkStateReader.toJSON((Object)newAliases.getAliasMap());
        }
        try {
            this.zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAliasAbsence(aliasName);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private boolean createShard(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        ShardResponse srsp;
        log.info("create shard invoked");
        String collectionName = message.getStr("collection");
        String shard = message.getStr("shard");
        if (collectionName == null || shard == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'collection' and 'shard' are required parameters");
        }
        int numSlices = 1;
        DocCollection collection = clusterState.getCollection(collectionName);
        int maxShardsPerNode = collection.getInt(MAX_SHARDS_PER_NODE, Integer.valueOf(1));
        int repFactor = message.getInt(REPLICATION_FACTOR, collection.getInt(MAX_SHARDS_PER_NODE, Integer.valueOf(1)));
        String createNodeSetStr = message.getStr(CREATE_NODE_SET);
        ArrayList<Assign.Node> sortedNodeList = Assign.getNodesForNewShard(clusterState, collectionName, numSlices, maxShardsPerNode, repFactor, createNodeSetStr);
        Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)message));
        long waitUntil = System.currentTimeMillis() + 30000L;
        boolean created = false;
        while (System.currentTimeMillis() < waitUntil) {
            Thread.sleep(100L);
            created = this.zkStateReader.getClusterState().getCollection(collectionName).getSlice(shard) != null;
            if (!created) continue;
        }
        if (!created) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully create shard: " + message.getStr("name"));
        }
        String configName = message.getStr(COLL_CONF);
        String sliceName = shard;
        for (int j = 1; j <= repFactor; ++j) {
            String nodeName = sortedNodeList.get((int)((j - 1) % sortedNodeList.size())).nodeName;
            String shardName = collectionName + "_" + sliceName + "_replica" + j;
            log.info("Creating shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
            params.set("name", new String[]{shardName});
            params.set(COLL_CONF, new String[]{configName});
            params.set("collection", new String[]{collectionName});
            params.set("shard", new String[]{sliceName});
            params.set(NUM_SLICES, numSlices);
            ShardRequest sreq = new ShardRequest();
            params.set("qt", new String[]{this.adminPath});
            sreq.purpose = 1;
            String replica = this.zkStateReader.getZkClient().getBaseUrlForNodeName(nodeName);
            if (replica.startsWith("http://")) {
                replica = replica.substring(7);
            }
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.params = params;
            this.shardHandler.submit(sreq, replica, sreq.params);
        }
        do {
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp);
        } while (srsp != null);
        log.info("Finished create command on all shards for collection: " + collectionName);
        return true;
    }

    private boolean splitShard(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        log.info("Split shard invoked");
        String collectionName = message.getStr("collection");
        String slice = message.getStr("shard");
        Slice parentSlice = clusterState.getSlice(collectionName, slice);
        if (parentSlice == null) {
            if (clusterState.getCollections().contains(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with the specified name exists: " + slice);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection with the specified name exists: " + collectionName);
        }
        Replica parentShardLeader = clusterState.getLeader(collectionName, slice);
        DocCollection collection = clusterState.getCollection(collectionName);
        DocRouter router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
        DocRouter.Range range = parentSlice.getRange();
        if (range == null) {
            range = new PlainIdRouter().fullRange();
        }
        List subRanges = router.partitionRange(2, range);
        try {
            int i;
            String subShardName;
            String subSlice;
            int i2;
            ArrayList<String> subSlices = new ArrayList<String>(subRanges.size());
            ArrayList<String> subShardNames = new ArrayList<String>(subRanges.size());
            String nodeName = parentShardLeader.getNodeName();
            for (i2 = 0; i2 < subRanges.size(); ++i2) {
                subSlice = slice + "_" + i2;
                subSlices.add(subSlice);
                subShardName = collectionName + "_" + subSlice + "_replica1";
                subShardNames.add(subShardName);
                Slice oSlice = clusterState.getSlice(collectionName, subSlice);
                if (oSlice == null) continue;
                if (Slice.ACTIVE.equals(oSlice.getState())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sub-shard: " + subSlice + " exists in active state. Aborting split shard.");
                }
                if (!Slice.CONSTRUCTION.equals(oSlice.getState())) continue;
                for (Replica replica : oSlice.getReplicas()) {
                    if (clusterState.liveNodesContain(replica.getNodeName())) {
                        String core = replica.getStr("core");
                        log.info("Unloading core: " + core + " from node: " + replica.getNodeName());
                        ModifiableSolrParams params = new ModifiableSolrParams();
                        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
                        params.set("core", new String[]{core});
                        params.set("deleteIndex", new String[]{"true"});
                        this.sendShardRequest(replica.getNodeName(), params);
                        continue;
                    }
                    log.warn("Replica {} exists in shard {} but is not live and cannot be unloaded", (Object)replica, (Object)oSlice);
                }
            }
            this.collectShardResponses(results, false, null);
            for (i2 = 0; i2 < subRanges.size(); ++i2) {
                subSlice = (String)subSlices.get(i2);
                subShardName = (String)subShardNames.get(i2);
                DocRouter.Range subRange = (DocRouter.Range)subRanges.get(i2);
                log.info("Creating shard " + subShardName + " as part of slice " + subSlice + " of collection " + collectionName + " on " + nodeName);
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                params.set("name", new String[]{subShardName});
                params.set("collection", new String[]{collectionName});
                params.set("shard", new String[]{subSlice});
                params.set("shard.range", new String[]{subRange.toString()});
                params.set("shard.state", new String[]{Slice.CONSTRUCTION});
                this.sendShardRequest(nodeName, params);
            }
            this.collectShardResponses(results, true, "SPLTSHARD failed to create subshard leaders");
            for (String subShardName2 : subShardNames) {
                log.info("Asking parent leader to wait for: " + subShardName2 + " to be alive on: " + nodeName);
                String coreNodeName = this.waitForCoreNodeName(collection, this.zkStateReader.getZkClient().getBaseUrlForNodeName(nodeName), subShardName2);
                CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
                cmd.setCoreName(subShardName2);
                cmd.setNodeName(nodeName);
                cmd.setCoreNodeName(coreNodeName);
                cmd.setState("active");
                cmd.setCheckLive(Boolean.valueOf(true));
                cmd.setOnlyIfLeader(true);
                this.sendShardRequest(nodeName, new ModifiableSolrParams(cmd.getParams()));
            }
            this.collectShardResponses(results, true, "SPLTSHARD timed out waiting for subshard leaders to come up");
            log.info("Successfully created all sub-shards for collection " + collectionName + " parent shard: " + slice + " on: " + parentShardLeader);
            log.info("Splitting shard " + parentShardLeader.getName() + " as part of slice " + slice + " of collection " + collectionName + " on " + parentShardLeader);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.SPLIT.toString()});
            params.set("core", new String[]{parentShardLeader.getStr("core")});
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                params.add("targetCore", new String[]{subShardName});
            }
            this.sendShardRequest(parentShardLeader.getNodeName(), params);
            this.collectShardResponses(results, true, "SPLITSHARD failed to invoke SPLIT core admin command");
            log.info("Index on shard: " + nodeName + " split into two successfully");
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                log.info("Applying buffered updates on : " + subShardName);
                params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString()});
                params.set("name", new String[]{subShardName});
                this.sendShardRequest(nodeName, params);
            }
            this.collectShardResponses(results, true, "SPLITSHARD failed while asking sub shard leaders to apply buffered updates");
            log.info("Successfully applied buffered updates on : " + subShardNames);
            int repFactor = clusterState.getSlice(collectionName, slice).getReplicas().size();
            Set nodes = clusterState.getLiveNodes();
            ArrayList nodeList = new ArrayList(nodes.size());
            nodeList.addAll(nodes);
            Collections.shuffle(nodeList);
            nodeList.remove(nodeName);
            for (int i3 = 1; i3 <= subSlices.size(); ++i3) {
                Collections.shuffle(nodeList);
                String sliceName = (String)subSlices.get(i3 - 1);
                for (int j = 2; j <= repFactor; ++j) {
                    String subShardNodeName = (String)nodeList.get((repFactor * (i3 - 1) + (j - 2)) % nodeList.size());
                    String shardName = collectionName + "_" + sliceName + "_replica" + j;
                    log.info("Creating replica shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + subShardNodeName);
                    params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                    params.set("name", new String[]{shardName});
                    params.set("collection", new String[]{collectionName});
                    params.set("shard", new String[]{sliceName});
                    this.sendShardRequest(subShardNodeName, params);
                    String coreNodeName = this.waitForCoreNodeName(collection, this.zkStateReader.getZkClient().getBaseUrlForNodeName(subShardNodeName), shardName);
                    log.info("Asking sub shard leader to wait for: " + shardName + " to be alive on: " + subShardNodeName);
                    CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
                    cmd.setCoreName((String)subShardNames.get(i3 - 1));
                    cmd.setNodeName(subShardNodeName);
                    cmd.setCoreNodeName(coreNodeName);
                    cmd.setState("active");
                    cmd.setCheckLive(Boolean.valueOf(true));
                    cmd.setOnlyIfLeader(true);
                    this.sendShardRequest(nodeName, new ModifiableSolrParams(cmd.getParams()));
                }
            }
            this.collectShardResponses(results, true, "SPLTSHARD failed to create subshard replicas or timed out waiting for them to come up");
            String coreUrl = new ZkCoreNodeProps((ZkNodeProps)parentShardLeader).getCoreUrl();
            UpdateResponse updateResponse = null;
            try {
                updateResponse = OverseerCollectionProcessor.commit(coreUrl, true);
                this.processResponse(results, null, coreUrl, (SolrResponse)updateResponse, slice);
            }
            catch (Exception e) {
                this.processResponse(results, e, coreUrl, (SolrResponse)updateResponse, slice);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to call distrib commit on: " + coreUrl, (Throwable)e);
            }
            log.info("Successfully created all replica shards for all sub-slices " + subSlices);
            log.info("Requesting update shard state");
            DistributedQueue inQueue = Overseer.getInQueue(this.zkStateReader.getZkClient());
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put(QUEUE_OPERATION, "updateshardstate");
            propMap.put(slice, Slice.INACTIVE);
            for (String subSlice2 : subSlices) {
                propMap.put(subSlice2, Slice.ACTIVE);
            }
            propMap.put("collection", collectionName);
            ZkNodeProps m = new ZkNodeProps(propMap);
            inQueue.offer(ZkStateReader.toJSON((Object)m));
            return true;
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error executing split operation for collection: " + collectionName + " parent shard: " + slice, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UpdateResponse commit(String url, boolean openSearcher) throws SolrServerException, IOException {
        HttpSolrServer server = null;
        try {
            server = new HttpSolrServer(url);
            server.setConnectionTimeout(30000);
            server.setSoTimeout(60000);
            UpdateRequest ureq = new UpdateRequest();
            ureq.setParams(new ModifiableSolrParams());
            ureq.getParams().set("openSearcher", openSearcher);
            ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true);
            UpdateResponse updateResponse = ureq.process((SolrServer)server);
            return updateResponse;
        }
        finally {
            if (server != null) {
                server.shutdown();
            }
        }
    }

    private String waitForCoreNodeName(DocCollection collection, String msgBaseUrl, String msgCore) {
        int retryCount = 320;
        while (retryCount-- > 0) {
            Map slicesMap = this.zkStateReader.getClusterState().getSlicesMap(collection.getName());
            if (slicesMap != null) {
                for (Slice slice : slicesMap.values()) {
                    for (Replica replica : slice.getReplicas()) {
                        String baseUrl = replica.getStr("base_url");
                        String core = replica.getStr("core");
                        if (!baseUrl.equals(msgBaseUrl) || !core.equals(msgCore)) continue;
                        return replica.getName();
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find coreNodeName");
    }

    private void collectShardResponses(NamedList results, boolean abortOnError, String msgOnError) {
        ShardResponse srsp;
        do {
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp);
            Throwable exception = srsp.getException();
            if (!abortOnError || exception == null) continue;
            while (srsp != null) {
                srsp = this.shardHandler.takeCompletedOrError();
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msgOnError, exception);
        } while (srsp != null);
    }

    private void deleteShard(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        log.info("Delete shard invoked");
        String collection = message.getStr("collection");
        String sliceId = message.getStr("shard");
        Slice slice = clusterState.getSlice(collection, sliceId);
        if (slice == null) {
            if (clusterState.getCollections().contains(collection)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with the specified name exists: " + slice);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection with the specified name exists: " + collection);
        }
        if (slice.getRange() != null && !slice.getState().equals(Slice.INACTIVE)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The slice: " + slice.getName() + " is currently " + slice.getState() + ". Only INACTIVE (or custom-hashed) slices can be deleted.");
        }
        try {
            ShardResponse srsp;
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
            params.set("deleteIndex", new String[]{"true"});
            this.sliceCmd(clusterState, params, null, slice);
            do {
                if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
                this.processResponse(results, srsp);
            } while (srsp != null);
            ZkNodeProps m = new ZkNodeProps(new String[]{QUEUE_OPERATION, "removeshard", "collection", collection, "shard", sliceId});
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)m));
            long now = System.currentTimeMillis();
            long timeout = now + 30000L;
            boolean removed = false;
            while (System.currentTimeMillis() < timeout) {
                Thread.sleep(100L);
                removed = this.zkStateReader.getClusterState().getSlice(collection, sliceId) == null;
                if (!removed) continue;
                Thread.sleep(100L);
                break;
            }
            if (!removed) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully remove collection: " + collection + " shard: " + sliceId);
            }
            log.info("Successfully deleted collection: " + collection + ", shard: " + sliceId);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error executing delete operation for collection: " + collection + " shard: " + sliceId, (Throwable)e);
        }
    }

    private void sendShardRequest(String nodeName, ModifiableSolrParams params) {
        ShardRequest sreq = new ShardRequest();
        params.set("qt", new String[]{this.adminPath});
        sreq.purpose = 1;
        String replica = this.zkStateReader.getZkClient().getBaseUrlForNodeName(nodeName);
        if (replica.startsWith("http://")) {
            replica = replica.substring(7);
        }
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = params;
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    private void createCollection(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collectionName = message.getStr("name");
        if (clusterState.getCollections().contains(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection already exists: " + collectionName);
        }
        try {
            ShardResponse srsp;
            int requestedShardsToCreate;
            int maxShardsAllowedToCreate;
            List createNodeList;
            int repFactor = message.getInt(REPLICATION_FACTOR, Integer.valueOf(1));
            Integer numSlices = message.getInt(NUM_SLICES, null);
            String router = message.getStr("router.name", "compositeId");
            ArrayList<String> shardNames = new ArrayList<String>();
            if ("implicit".equals(router)) {
                Overseer.getShardNames(shardNames, message.getStr(SHARDS_PROP, null));
                numSlices = shardNames.size();
            } else {
                Overseer.getShardNames(numSlices, shardNames);
            }
            if (numSlices == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param");
            }
            int maxShardsPerNode = message.getInt(MAX_SHARDS_PER_NODE, Integer.valueOf(1));
            String createNodeSetStr = message.getStr(CREATE_NODE_SET);
            List list = createNodeList = createNodeSetStr == null ? null : StrUtils.splitSmart((String)createNodeSetStr, (String)",", (boolean)true);
            if (repFactor <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "replicationFactor must be greater than or equal to 0");
            }
            if (numSlices <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards must be > 0");
            }
            Set nodes = clusterState.getLiveNodes();
            ArrayList nodeList = new ArrayList(nodes.size());
            nodeList.addAll(nodes);
            if (createNodeList != null) {
                nodeList.retainAll(createNodeList);
            }
            Collections.shuffle(nodeList);
            if (nodeList.size() <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". No live Solr-instances" + (createNodeList != null ? " among Solr-instances specified in createNodeSet:" + createNodeSetStr : ""));
            }
            if (repFactor > nodeList.size()) {
                log.warn("Specified replicationFactor of " + repFactor + " on collection " + collectionName + " is higher than or equal to the number of Solr instances currently live or part of your " + CREATE_NODE_SET + "(" + nodeList.size() + "). Its unusual to run two replica of the same slice on the same Solr-instance.");
            }
            if ((maxShardsAllowedToCreate = maxShardsPerNode * nodeList.size()) < (requestedShardsToCreate = numSlices * repFactor)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". Value of " + MAX_SHARDS_PER_NODE + " is " + maxShardsPerNode + ", and the number of live nodes is " + nodeList.size() + ". This allows a maximum of " + maxShardsAllowedToCreate + " to be created. Value of " + NUM_SLICES + " is " + numSlices + " and value of " + REPLICATION_FACTOR + " is " + repFactor + ". This requires " + requestedShardsToCreate + " shards to be created (higher than the allowed number)");
            }
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)message));
            long waitUntil = System.currentTimeMillis() + 30000L;
            boolean created = false;
            while (System.currentTimeMillis() < waitUntil) {
                Thread.sleep(100L);
                created = this.zkStateReader.getClusterState().getCollections().contains(message.getStr("name"));
                if (!created) continue;
            }
            if (!created) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully createcollection: " + message.getStr("name"));
            }
            String configName = message.getStr(COLL_CONF);
            log.info("going to create cores replicas shardNames {} , repFactor : {}", shardNames, (Object)repFactor);
            for (int i = 1; i <= shardNames.size(); ++i) {
                String sliceName = (String)shardNames.get(i - 1);
                for (int j = 1; j <= repFactor; ++j) {
                    String nodeName = (String)nodeList.get((repFactor * (i - 1) + (j - 1)) % nodeList.size());
                    String shardName = collectionName + "_" + sliceName + "_replica" + j;
                    log.info("Creating shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                    params.set("name", new String[]{shardName});
                    params.set(COLL_CONF, new String[]{configName});
                    params.set("collection", new String[]{collectionName});
                    params.set("shard", new String[]{sliceName});
                    params.set(NUM_SLICES, numSlices.intValue());
                    ShardRequest sreq = new ShardRequest();
                    params.set("qt", new String[]{this.adminPath});
                    sreq.purpose = 1;
                    String replica = this.zkStateReader.getZkClient().getBaseUrlForNodeName(nodeName);
                    if (replica.startsWith("http://")) {
                        replica = replica.substring(7);
                    }
                    sreq.shards = new String[]{replica};
                    sreq.actualShards = sreq.shards;
                    sreq.params = params;
                    this.shardHandler.submit(sreq, replica, sreq.params);
                }
            }
            do {
                if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
                this.processResponse(results, srsp);
            } while (srsp != null);
            log.info("Finished create command on all shards for collection: " + collectionName);
        }
        catch (SolrException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)ex);
        }
    }

    private void collectionCmd(ClusterState clusterState, ZkNodeProps message, ModifiableSolrParams params, NamedList results, String stateMatcher) {
        ShardResponse srsp;
        log.info("Executing Collection Cmd : " + params);
        String collectionName = message.getStr("name");
        DocCollection coll = clusterState.getCollection(collectionName);
        for (Map.Entry entry : coll.getSlicesMap().entrySet()) {
            Slice slice = (Slice)entry.getValue();
            this.sliceCmd(clusterState, params, stateMatcher, slice);
        }
        do {
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp);
        } while (srsp != null);
    }

    private void sliceCmd(ClusterState clusterState, ModifiableSolrParams params, String stateMatcher, Slice slice) {
        Map shards = slice.getReplicasMap();
        Set shardEntries = shards.entrySet();
        for (Map.Entry shardEntry : shardEntries) {
            ZkNodeProps node = (ZkNodeProps)shardEntry.getValue();
            if (!clusterState.liveNodesContain(node.getStr("node_name")) || stateMatcher != null && !node.getStr("state").equals(stateMatcher)) continue;
            ModifiableSolrParams cloneParams = new ModifiableSolrParams();
            cloneParams.add((SolrParams)params);
            cloneParams.set("core", new String[]{node.getStr("core")});
            String replica = node.getStr("base_url");
            ShardRequest sreq = new ShardRequest();
            sreq.nodeName = node.getStr("node_name");
            cloneParams.set("qt", new String[]{this.adminPath});
            sreq.purpose = 1;
            if (replica.startsWith("http://")) {
                replica = replica.substring(7);
            }
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.params = cloneParams;
            log.info("Collection Admin sending CoreAdmin cmd to " + replica + " params:" + sreq.params);
            this.shardHandler.submit(sreq, replica, sreq.params);
        }
    }

    private void processResponse(NamedList results, ShardResponse srsp) {
        Throwable e = srsp.getException();
        String nodeName = srsp.getNodeName();
        SolrResponse solrResponse = srsp.getSolrResponse();
        String shard = srsp.getShard();
        this.processResponse(results, e, nodeName, solrResponse, shard);
    }

    private void processResponse(NamedList results, Throwable e, String nodeName, SolrResponse solrResponse, String shard) {
        if (e != null) {
            log.error("Error from shard: " + shard, e);
            SimpleOrderedMap failure = (SimpleOrderedMap)results.get("failure");
            if (failure == null) {
                failure = new SimpleOrderedMap();
                results.add("failure", (Object)failure);
            }
            failure.add(nodeName, (Object)(e.getClass().getName() + ":" + e.getMessage()));
        } else {
            SimpleOrderedMap success = (SimpleOrderedMap)results.get("success");
            if (success == null) {
                success = new SimpleOrderedMap();
                results.add("success", (Object)success);
            }
            success.add(nodeName, (Object)solrResponse.getResponse());
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

