/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.IOUtils;
import org.apache.solr.util.PropertiesUtil;

public class CoreDescriptor {
    public static final String CORE_NAME = "name";
    public static final String CORE_CONFIG = "config";
    public static final String CORE_INSTDIR = "instanceDir";
    public static final String CORE_ABS_INSTDIR = "absoluteInstDir";
    public static final String CORE_DATADIR = "dataDir";
    public static final String CORE_ULOGDIR = "ulogDir";
    public static final String CORE_SCHEMA = "schema";
    public static final String CORE_SHARD = "shard";
    public static final String CORE_COLLECTION = "collection";
    public static final String CORE_ROLES = "roles";
    public static final String CORE_PROPERTIES = "properties";
    public static final String CORE_LOADONSTARTUP = "loadOnStartup";
    public static final String CORE_TRANSIENT = "transient";
    public static final String CORE_NODE_NAME = "coreNodeName";
    public static final String SOLR_CORE_PROP_PREFIX = "solr.core.";
    public static final String DEFAULT_EXTERNAL_PROPERTIES_FILE = "conf" + File.separator + "solrcore.properties";
    private static ImmutableMap<String, String> defaultProperties = ImmutableMap.of((Object)"config", (Object)"solrconfig.xml", (Object)"schema", (Object)"schema.xml", (Object)"dataDir", (Object)("data" + File.separator), (Object)"transient", (Object)"false", (Object)"loadOnStartup", (Object)"true");
    private static ImmutableList<String> requiredProperties = ImmutableList.of((Object)"name", (Object)"instanceDir", (Object)"absoluteInstDir");
    public static ImmutableList<String> standardPropNames = ImmutableList.of((Object)"name", (Object)"config", (Object)"instanceDir", (Object)"dataDir", (Object)"ulogDir", (Object)"schema", (Object)"properties", (Object)"loadOnStartup", (Object)"transient", (Object)"shard", (Object)"collection", (Object)"roles", (Object[])new String[]{"coreNodeName", "numShards", "shardState"});
    private final CoreContainer coreContainer;
    private final CloudDescriptor cloudDesc;
    protected final Properties originalCoreProperties = new Properties();
    protected final Properties originalExtraProperties = new Properties();
    protected final Properties coreProperties = new Properties();
    protected final Properties substitutableProperties = new Properties();

    public Properties getPersistableStandardProperties() {
        return this.originalCoreProperties;
    }

    public Properties getPersistableUserProperties() {
        return this.originalExtraProperties;
    }

    public CoreDescriptor(CoreContainer container, String name, String instanceDir, Properties coreProps) {
        this.coreContainer = container;
        this.originalCoreProperties.setProperty(CORE_NAME, name);
        this.originalCoreProperties.setProperty(CORE_INSTDIR, instanceDir);
        Properties containerProperties = container.getContainerProperties();
        name = PropertiesUtil.substituteProperty(CoreDescriptor.checkPropertyIsNotEmpty(name, CORE_NAME), containerProperties);
        instanceDir = PropertiesUtil.substituteProperty(CoreDescriptor.checkPropertyIsNotEmpty(instanceDir, CORE_INSTDIR), containerProperties);
        this.coreProperties.putAll((Map<?, ?>)defaultProperties);
        this.coreProperties.put(CORE_NAME, name);
        this.coreProperties.put(CORE_INSTDIR, instanceDir);
        this.coreProperties.put(CORE_ABS_INSTDIR, CoreDescriptor.convertToAbsolute(instanceDir, container.getSolrHome()));
        for (String propname : coreProps.stringPropertyNames()) {
            String propvalue = coreProps.getProperty(propname);
            if (CoreDescriptor.isUserDefinedProperty(propname)) {
                this.originalExtraProperties.put(propname, propvalue);
            } else {
                this.originalCoreProperties.put(propname, propvalue);
            }
            if (requiredProperties.contains((Object)propname)) continue;
            this.coreProperties.setProperty(propname, PropertiesUtil.substituteProperty(propvalue, containerProperties));
        }
        this.loadExtraProperties();
        this.buildSubstitutableProperties();
        this.cloudDesc = container.isZooKeeperAware() ? new CloudDescriptor(name, this.coreProperties) : null;
    }

    protected void loadExtraProperties() {
        String filename = this.coreProperties.getProperty(CORE_PROPERTIES, DEFAULT_EXTERNAL_PROPERTIES_FILE);
        File propertiesFile = this.resolvePaths(filename);
        if (propertiesFile.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(propertiesFile);
                Properties externalProps = new Properties();
                externalProps.load(new InputStreamReader((InputStream)in, "UTF-8"));
                this.coreProperties.putAll((Map<?, ?>)externalProps);
            }
            catch (IOException e) {
                try {
                    String message = String.format(Locale.ROOT, "Could not load properties from %s: %s:", propertiesFile.getAbsoluteFile(), e.toString());
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, message);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(in);
        }
    }

    protected void buildSubstitutableProperties() {
        for (String propName : this.coreProperties.stringPropertyNames()) {
            String propValue = this.coreProperties.getProperty(propName);
            if (!CoreDescriptor.isUserDefinedProperty(propName)) {
                propName = SOLR_CORE_PROP_PREFIX + propName;
            }
            this.substitutableProperties.setProperty(propName, propValue);
        }
    }

    protected File resolvePaths(String filepath) {
        File file = new File(filepath);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.getInstanceDir(), filepath);
    }

    protected static boolean isUserDefinedProperty(String propName) {
        return !standardPropNames.contains((Object)propName);
    }

    public static String checkPropertyIsNotEmpty(String value, String propName) {
        if (StringUtils.isEmpty((String)value)) {
            String message = String.format(Locale.ROOT, "Cannot create core with empty %s value", propName);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, message);
        }
        return value;
    }

    public CoreDescriptor(CoreContainer container, String name, String instanceDir) {
        this(container, name, instanceDir, new Properties());
    }

    public CoreDescriptor(String coreName, CoreDescriptor other) {
        this.coreContainer = other.coreContainer;
        this.cloudDesc = other.cloudDesc;
        this.originalExtraProperties.putAll((Map<?, ?>)other.originalExtraProperties);
        this.originalCoreProperties.putAll((Map<?, ?>)other.originalCoreProperties);
        this.coreProperties.putAll((Map<?, ?>)other.coreProperties);
        this.substitutableProperties.putAll((Map<?, ?>)other.substitutableProperties);
        this.coreProperties.setProperty(CORE_NAME, coreName);
        this.originalCoreProperties.setProperty(CORE_NAME, coreName);
        this.substitutableProperties.setProperty("solr.core.name", coreName);
    }

    public String getPropertiesName() {
        return this.coreProperties.getProperty(CORE_PROPERTIES);
    }

    public String getDataDir() {
        return this.coreProperties.getProperty(CORE_DATADIR);
    }

    public boolean usingDefaultDataDir() {
        return ((String)defaultProperties.get((Object)CORE_DATADIR)).equals(this.coreProperties.getProperty(CORE_DATADIR));
    }

    public String getRawInstanceDir() {
        return this.coreProperties.getProperty(CORE_INSTDIR);
    }

    private static String convertToAbsolute(String instDir, String solrHome) {
        Preconditions.checkNotNull((Object)instDir);
        File f = new File(instDir);
        if (f.isAbsolute()) {
            return SolrResourceLoader.normalizeDir(instDir);
        }
        return SolrResourceLoader.normalizeDir(solrHome + SolrResourceLoader.normalizeDir(instDir));
    }

    public String getInstanceDir() {
        return this.coreProperties.getProperty(CORE_ABS_INSTDIR);
    }

    public String getConfigName() {
        return this.coreProperties.getProperty(CORE_CONFIG);
    }

    public String getSchemaName() {
        return this.coreProperties.getProperty(CORE_SCHEMA);
    }

    public String getName() {
        return this.coreProperties.getProperty(CORE_NAME);
    }

    public String getCollectionName() {
        return this.cloudDesc == null ? null : this.cloudDesc.getCollectionName();
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    public CloudDescriptor getCloudDescriptor() {
        return this.cloudDesc;
    }

    public boolean isLoadOnStartup() {
        String tmp = this.coreProperties.getProperty(CORE_LOADONSTARTUP, "false");
        return Boolean.parseBoolean(tmp);
    }

    public boolean isTransient() {
        String tmp = this.coreProperties.getProperty(CORE_TRANSIENT, "false");
        return PropertiesUtil.toBoolean(tmp);
    }

    public String getUlogDir() {
        return this.coreProperties.getProperty(CORE_ULOGDIR);
    }

    public String getCoreProperty(String prop, String defVal) {
        return this.coreProperties.getProperty(prop, defVal);
    }

    public Properties getSubstitutableProperties() {
        return this.substitutableProperties;
    }

    public String toString() {
        return "CoreDescriptor[name=" + this.getName() + ";instanceDir=" + this.getInstanceDir() + "]";
    }
}

