/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.core.ConfigSolrXmlOld;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CoresLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrXMLCoresLocator
implements CoresLocator {
    private static final Logger logger = LoggerFactory.getLogger(SolrXMLCoresLocator.class);
    private final String solrXmlTemplate;
    private final ConfigSolrXmlOld cfg;
    public static final String DEFAULT_CORE_NAME = "collection1";
    private static Pattern POPULATED_CORES_TAG = Pattern.compile("^(.*<cores[^>]*>)(.*)(</cores>.*)$", 32);
    private static Pattern EMPTY_CORES_TAG = Pattern.compile("^(.*<cores[^>]*)/>(.*)$", 32);
    private static Pattern SHARD_HANDLER_TAG = Pattern.compile("(<shardHandlerFactory[^>]*>.*</shardHandlerFactory>)|(<shardHandlerFactory[^>]*/>)", 32);
    private static String CORES_PLACEHOLDER = "{{CORES_PLACEHOLDER}}";
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String INDENT = "    ";

    public SolrXMLCoresLocator(String originalXML, ConfigSolrXmlOld cfg) {
        this.solrXmlTemplate = SolrXMLCoresLocator.buildTemplate(originalXML);
        this.cfg = cfg;
    }

    static String buildTemplate(String originalXML) {
        Matcher popMatcher;
        String shardHandlerConfig = "";
        Matcher shfMatcher = SHARD_HANDLER_TAG.matcher(originalXML);
        if (shfMatcher.find()) {
            shardHandlerConfig = shfMatcher.group(0);
        }
        if ((popMatcher = POPULATED_CORES_TAG.matcher(originalXML)).matches()) {
            return popMatcher.group(1) + CORES_PLACEHOLDER + shardHandlerConfig + popMatcher.group(3);
        }
        Matcher emptyMatcher = EMPTY_CORES_TAG.matcher(originalXML);
        if (emptyMatcher.matches()) {
            return emptyMatcher.group(1) + ">" + CORES_PLACEHOLDER + "</cores>" + emptyMatcher.group(2);
        }
        return originalXML.replace("</solr>", "<cores>" + CORES_PLACEHOLDER + "</cores></solr>");
    }

    protected String buildSolrXML(List<CoreDescriptor> cds) {
        StringBuilder builder = new StringBuilder();
        for (CoreDescriptor cd : cds) {
            builder.append(SolrXMLCoresLocator.buildCoreTag(cd));
        }
        return this.solrXmlTemplate.replace(CORES_PLACEHOLDER, builder.toString());
    }

    protected static String buildCoreTag(CoreDescriptor cd) {
        StringBuilder builder = new StringBuilder(NEWLINE).append(INDENT).append("<core");
        for (Map.Entry<Object, Object> entry : cd.getPersistableStandardProperties().entrySet()) {
            builder.append(" ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        Properties userProperties = cd.getPersistableUserProperties();
        if (userProperties.isEmpty()) {
            return builder.append("/>").append(NEWLINE).toString();
        }
        builder.append(">").append(NEWLINE);
        for (Map.Entry<Object, Object> entry : userProperties.entrySet()) {
            builder.append(INDENT).append(INDENT).append("<property name=\"").append(entry.getKey()).append("\" value=\"").append(entry.getValue()).append("\"/>").append(NEWLINE);
        }
        return builder.append("</core>").append(NEWLINE).toString();
    }

    @Override
    public final void persist(CoreContainer cc, CoreDescriptor ... coreDescriptors) {
        this.doPersist(this.buildSolrXML(cc.getCoreDescriptors()));
    }

    protected void doPersist(String xml) {
        File file = new File(this.cfg.config.getResourceLoader().getInstanceDir(), "solr.xml");
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);
            writer.write(xml);
            ((Writer)writer).close();
            logger.info("Persisted core descriptions to {}", (Object)file.getAbsolutePath());
        }
        catch (IOException e) {
            logger.error("Couldn't persist core descriptions to {} : {}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }

    @Override
    public void create(CoreContainer cc, CoreDescriptor ... coreDescriptors) {
        this.persist(cc, coreDescriptors);
    }

    @Override
    public void delete(CoreContainer cc, CoreDescriptor ... coreDescriptors) {
        this.persist(cc, coreDescriptors);
    }

    @Override
    public void rename(CoreContainer cc, CoreDescriptor oldCD, CoreDescriptor newCD) {
        this.persist(cc, oldCD, newCD);
    }

    @Override
    public List<CoreDescriptor> discover(CoreContainer cc) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (String coreName : this.cfg.getAllCoreNames()) {
            String name = this.cfg.getProperty(coreName, "name", DEFAULT_CORE_NAME);
            String instanceDir = this.cfg.getProperty(coreName, "instanceDir", "");
            Properties coreProperties = new Properties();
            for (String propName : CoreDescriptor.standardPropNames) {
                String propValue = this.cfg.getProperty(coreName, propName, "");
                if (!StringUtils.isNotEmpty((String)propValue)) continue;
                coreProperties.setProperty(propName, propValue);
            }
            coreProperties.putAll((Map<?, ?>)this.cfg.getCoreProperties(coreName));
            listBuilder.add((Object)new CoreDescriptor(cc, name, instanceDir, coreProperties));
        }
        return listBuilder.build();
    }

    String getTemplate() {
        return this.solrXmlTemplate;
    }

    public static class NonPersistingLocator
    extends SolrXMLCoresLocator {
        public String xml;

        public NonPersistingLocator(String originalXML, ConfigSolrXmlOld cfg) {
            super(originalXML, cfg);
            this.xml = originalXML;
        }

        @Override
        public void doPersist(String xml) {
            this.xml = xml;
        }
    }
}

