/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.transform.ElevatedMarkerFactory;
import org.apache.solr.response.transform.ExcludedMarkerFactory;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.grouping.GroupingSpecification;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.VersionedFile;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class QueryElevationComponent
extends SearchComponent
implements SolrCoreAware {
    private static Logger log = LoggerFactory.getLogger(QueryElevationComponent.class);
    static final String FIELD_TYPE = "queryFieldType";
    static final String CONFIG_FILE = "config-file";
    static final String EXCLUDE = "exclude";
    public static final String BOOSTED = "BOOSTED";
    public static final String EXCLUDED = "EXCLUDED";
    private SolrParams initArgs = null;
    private Analyzer analyzer = null;
    private String idField = null;
    private FieldType idSchemaFT;
    boolean forceElevation = false;
    final Map<IndexReader, Map<String, ElevationObj>> elevationCache = new WeakHashMap<IndexReader, Map<String, ElevationObj>>();

    @Override
    public void init(NamedList args) {
        this.initArgs = SolrParams.toSolrParams((NamedList)args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inform(SolrCore core) {
        SchemaField sf;
        IndexSchema schema = core.getLatestSchema();
        String a = this.initArgs.get(FIELD_TYPE);
        if (a != null) {
            FieldType ft = schema.getFieldTypes().get(a);
            if (ft == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown FieldType: '" + a + "' used in QueryElevationComponent");
            }
            this.analyzer = ft.getQueryAnalyzer();
        }
        if ((sf = schema.getUniqueKeyField()) == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "QueryElevationComponent requires the schema to have a uniqueKeyField.");
        }
        this.idSchemaFT = sf.getType();
        this.idField = sf.getName();
        String excludeName = this.initArgs.get("excludeMarkerFieldName", "excluded");
        if (excludeName == null || excludeName.equals("")) {
            excludeName = "excluded";
        }
        ExcludedMarkerFactory excludedMarkerFactory = new ExcludedMarkerFactory();
        core.addTransformerFactory(excludeName, excludedMarkerFactory);
        ElevatedMarkerFactory elevatedMarkerFactory = new ElevatedMarkerFactory();
        String markerName = this.initArgs.get("editorialMarkerFieldName", "elevated");
        if (markerName == null || markerName.equals("")) {
            markerName = "elevated";
        }
        core.addTransformerFactory(markerName, elevatedMarkerFactory);
        this.forceElevation = this.initArgs.getBool("forceElevation", this.forceElevation);
        try {
            Map<IndexReader, Map<String, ElevationObj>> map = this.elevationCache;
            synchronized (map) {
                this.elevationCache.clear();
                String f = this.initArgs.get(CONFIG_FILE);
                if (f == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "QueryElevationComponent must specify argument: 'config-file' -- path to elevate.xml");
                }
                boolean exists = false;
                ZkController zkController = core.getCoreDescriptor().getCoreContainer().getZkController();
                if (zkController != null) {
                    exists = zkController.configFileExists(zkController.readConfigName(core.getCoreDescriptor().getCloudDescriptor().getCollectionName()), f);
                } else {
                    File fC = new File(core.getResourceLoader().getConfigDir(), f);
                    File fD = new File(core.getDataDir(), f);
                    if (fC.exists() == fD.exists()) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "QueryElevationComponent missing config file: '" + f + "\n" + "either: " + fC.getAbsolutePath() + " or " + fD.getAbsolutePath() + " must exist, but not both.");
                    }
                    if (fC.exists()) {
                        exists = true;
                        log.info("Loading QueryElevation from: " + fC.getAbsolutePath());
                        Config cfg = new Config(core.getResourceLoader(), f);
                        this.elevationCache.put(null, this.loadElevationMap(cfg));
                    }
                }
                if (!exists) {
                    RefCounted<SolrIndexSearcher> searchHolder = null;
                    try {
                        searchHolder = core.getNewestSearcher(false);
                        DirectoryReader reader = searchHolder.get().getIndexReader();
                        this.getElevationMap((IndexReader)reader, core);
                    }
                    finally {
                        if (searchHolder != null) {
                            searchHolder.decref();
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error initializing QueryElevationComponent.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, ElevationObj> getElevationMap(IndexReader reader, SolrCore core) throws Exception {
        Map<IndexReader, Map<String, ElevationObj>> map = this.elevationCache;
        synchronized (map) {
            Map<String, ElevationObj> map2 = this.elevationCache.get(null);
            if (map2 != null) {
                return map2;
            }
            map2 = this.elevationCache.get(reader);
            if (map2 == null) {
                Config cfg;
                String f = this.initArgs.get(CONFIG_FILE);
                if (f == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "QueryElevationComponent must specify argument: config-file");
                }
                log.info("Loading QueryElevation from data dir: " + f);
                ZkController zkController = core.getCoreDescriptor().getCoreContainer().getZkController();
                if (zkController != null) {
                    cfg = new Config(core.getResourceLoader(), f, null, null);
                } else {
                    InputStream is = VersionedFile.getLatestFile(core.getDataDir(), f);
                    cfg = new Config(core.getResourceLoader(), f, new InputSource(is), null);
                }
                map2 = this.loadElevationMap(cfg);
                this.elevationCache.put(reader, map2);
            }
            return map2;
        }
    }

    private Map<String, ElevationObj> loadElevationMap(Config cfg) throws IOException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        HashMap<String, ElevationObj> map = new HashMap<String, ElevationObj>();
        NodeList nodes = (NodeList)cfg.evaluate("elevate/query", XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String qstr = DOMUtil.getAttr(node, "text", "missing query 'text'");
            NodeList children = null;
            try {
                children = (NodeList)xpath.evaluate("doc", node, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "query requires '<doc .../>' child");
            }
            ArrayList<String> include = new ArrayList<String>();
            ArrayList<String> exclude = new ArrayList<String>();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                String id = DOMUtil.getAttr(child, "id", "missing 'id'");
                String e = DOMUtil.getAttr(child, EXCLUDE, null);
                if (e != null && Boolean.valueOf(e).booleanValue()) {
                    exclude.add(id);
                    continue;
                }
                include.add(id);
            }
            ElevationObj elev = new ElevationObj(qstr, include, exclude);
            if (map.containsKey(elev.analyzed)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Boosting query defined twice for query: '" + elev.text + "' (" + elev.analyzed + "')");
            }
            map.put(elev.analyzed, elev);
        }
        return map;
    }

    void setTopQueryResults(IndexReader reader, String query, String[] ids, String[] ex) throws IOException {
        Map<String, ElevationObj> elev;
        if (ids == null) {
            ids = new String[]{};
        }
        if (ex == null) {
            ex = new String[]{};
        }
        if ((elev = this.elevationCache.get(reader)) == null) {
            elev = new HashMap<String, ElevationObj>();
            this.elevationCache.put(reader, elev);
        }
        ElevationObj obj = new ElevationObj(query, Arrays.asList(ids), Arrays.asList(ex));
        elev.put(obj.analyzed, obj);
    }

    String getAnalyzedQuery(String query) throws IOException {
        if (this.analyzer == null) {
            return query;
        }
        StringBuilder norm = new StringBuilder();
        TokenStream tokens = this.analyzer.tokenStream("", query);
        tokens.reset();
        CharTermAttribute termAtt = (CharTermAttribute)tokens.addAttribute(CharTermAttribute.class);
        while (tokens.incrementToken()) {
            norm.append(termAtt.buffer(), 0, termAtt.length());
        }
        tokens.end();
        tokens.close();
        return norm.toString();
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (!params.getBool("enableElevation", true)) {
            return;
        }
        boolean exclusive = params.getBool("exclusive", false);
        boolean force = params.getBool("forceElevation", this.forceElevation);
        boolean markExcludes = params.getBool("markExcludes", false);
        Query query = rb.getQuery();
        String qstr = rb.getQueryString();
        if (query == null || qstr == null) {
            return;
        }
        qstr = this.getAnalyzedQuery(qstr);
        DirectoryReader reader = req.getSearcher().getIndexReader();
        ElevationObj booster = null;
        try {
            booster = this.getElevationMap((IndexReader)reader, req.getCore()).get(qstr);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading elevation", (Throwable)ex);
        }
        if (booster != null) {
            rb.req.getContext().put(BOOSTED, booster.ids);
            if (exclusive) {
                rb.setQuery((Query)booster.include);
            } else {
                BooleanQuery newq = new BooleanQuery(true);
                newq.add(query, BooleanClause.Occur.SHOULD);
                newq.add((Query)booster.include, BooleanClause.Occur.SHOULD);
                if (booster.exclude != null) {
                    if (!markExcludes) {
                        for (TermQuery tq : booster.exclude) {
                            newq.add(new BooleanClause((Query)tq, BooleanClause.Occur.MUST_NOT));
                        }
                    } else {
                        rb.req.getContext().put(EXCLUDED, booster.excludeIds);
                    }
                }
                rb.setQuery((Query)newq);
            }
            ElevationComparatorSource comparator = new ElevationComparatorSource(booster);
            SortSpec sortSpec = rb.getSortSpec();
            if (sortSpec.getSort() == null) {
                sortSpec.setSort(new Sort(new SortField[]{new SortField("_elevate_", (FieldComparatorSource)comparator, true), new SortField(null, SortField.Type.SCORE, false)}));
            } else {
                SortField[] current = sortSpec.getSort().getSort();
                Sort modified = this.modifySort(current, force, comparator);
                if (modified != null) {
                    sortSpec.setSort(modified);
                }
            }
            GroupingSpecification groupingSpec = rb.getGroupingSpec();
            if (groupingSpec != null) {
                SortField[] withinGroupSort;
                Sort modWithinGroupSort;
                SortField[] groupSort = groupingSpec.getGroupSort().getSort();
                Sort modGroupSort = this.modifySort(groupSort, force, comparator);
                if (modGroupSort != null) {
                    groupingSpec.setGroupSort(modGroupSort);
                }
                if ((modWithinGroupSort = this.modifySort(withinGroupSort = groupingSpec.getSortWithinGroup().getSort(), force, comparator)) != null) {
                    groupingSpec.setSortWithinGroup(modWithinGroupSort);
                }
            }
        }
        if (rb.isDebug()) {
            ArrayList<String> match = null;
            if (booster != null) {
                match = new ArrayList<String>(booster.priority.size());
                for (BooleanClause o : booster.include.clauses()) {
                    TermQuery tq = (TermQuery)o.getQuery();
                    match.add(tq.getTerm().text());
                }
            }
            SimpleOrderedMap dbg = new SimpleOrderedMap();
            dbg.add("q", (Object)qstr);
            dbg.add("match", match);
            if (rb.isDebugQuery()) {
                rb.addDebugInfo("queryBoosting", dbg);
            }
        }
    }

    private Sort modifySort(SortField[] current, boolean force, ElevationComparatorSource comparator) {
        boolean modify = false;
        ArrayList<SortField> sorts = new ArrayList<SortField>(current.length + 1);
        if (force && current[0].getType() != SortField.Type.SCORE) {
            sorts.add(new SortField("_elevate_", (FieldComparatorSource)comparator, true));
            modify = true;
        }
        for (SortField sf : current) {
            if (sf.getType() == SortField.Type.SCORE) {
                sorts.add(new SortField("_elevate_", (FieldComparatorSource)comparator, !sf.getReverse()));
                modify = true;
            }
            sorts.add(sf);
        }
        return modify ? new Sort(sorts.toArray(new SortField[sorts.size()])) : null;
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
    }

    @Override
    public String getDescription() {
        return "Query Boosting -- boost particular documents for a given query";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_5/solr/core/src/java/org/apache/solr/handler/component/QueryElevationComponent.java $";
    }

    @Override
    public URL[] getDocs() {
        try {
            return new URL[]{new URL("http://wiki.apache.org/solr/QueryElevationComponent")};
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    class ElevationComparatorSource
    extends FieldComparatorSource {
        private ElevationObj elevations;
        private SentinelIntSet ordSet;
        private BytesRef[] termValues;

        public ElevationComparatorSource(ElevationObj elevations) {
            this.elevations = elevations;
            int size = elevations.ids.size();
            this.ordSet = new SentinelIntSet(size, -1);
            this.termValues = new BytesRef[this.ordSet.keys.length];
        }

        public FieldComparator<Integer> newComparator(String fieldname, final int numHits, int sortPos, boolean reversed) throws IOException {
            return new FieldComparator<Integer>(){
                private final int[] values;
                private int bottomVal;
                private TermsEnum termsEnum;
                private DocsEnum docsEnum;
                Set<String> seen;
                {
                    this.values = new int[numHits];
                    this.seen = new HashSet<String>(((ElevationComparatorSource)ElevationComparatorSource.this).elevations.ids.size());
                }

                public int compare(int slot1, int slot2) {
                    return this.values[slot1] - this.values[slot2];
                }

                public void setBottom(int slot) {
                    this.bottomVal = this.values[slot];
                }

                private int docVal(int doc) {
                    int slot;
                    if (ElevationComparatorSource.this.ordSet.size() > 0 && (slot = ElevationComparatorSource.this.ordSet.find(doc)) >= 0) {
                        BytesRef id = ElevationComparatorSource.this.termValues[slot];
                        Integer prio = ((ElevationComparatorSource)ElevationComparatorSource.this).elevations.priority.get(id);
                        return prio == null ? 0 : prio;
                    }
                    return 0;
                }

                public int compareBottom(int doc) {
                    return this.bottomVal - this.docVal(doc);
                }

                public void copy(int slot, int doc) {
                    this.values[slot] = this.docVal(doc);
                }

                public FieldComparator setNextReader(AtomicReaderContext context) throws IOException {
                    ElevationComparatorSource.this.ordSet.clear();
                    Fields fields = context.reader().fields();
                    if (fields == null) {
                        return this;
                    }
                    Terms terms = fields.terms(QueryElevationComponent.this.idField);
                    if (terms == null) {
                        return this;
                    }
                    this.termsEnum = terms.iterator(this.termsEnum);
                    BytesRef term = new BytesRef();
                    Bits liveDocs = context.reader().getLiveDocs();
                    for (String id : ((ElevationComparatorSource)ElevationComparatorSource.this).elevations.ids) {
                        int docId;
                        term.copyChars((CharSequence)id);
                        if (this.seen.contains(id) || !this.termsEnum.seekExact(term)) continue;
                        this.docsEnum = this.termsEnum.docs(liveDocs, this.docsEnum, 0);
                        if (this.docsEnum == null || (docId = this.docsEnum.nextDoc()) == Integer.MAX_VALUE) continue;
                        ((ElevationComparatorSource)ElevationComparatorSource.this).termValues[((ElevationComparatorSource)ElevationComparatorSource.this).ordSet.put((int)docId)] = BytesRef.deepCopyOf((BytesRef)term);
                        this.seen.add(id);
                        assert (this.docsEnum.nextDoc() == Integer.MAX_VALUE);
                    }
                    return this;
                }

                public Integer value(int slot) {
                    return this.values[slot];
                }

                public int compareDocToValue(int doc, Integer valueObj) {
                    int value = valueObj;
                    int docValue = this.docVal(doc);
                    return docValue - value;
                }
            };
        }
    }

    class ElevationObj {
        final String text;
        final String analyzed;
        final TermQuery[] exclude;
        final BooleanQuery include;
        final Map<BytesRef, Integer> priority;
        final Set<String> ids;
        final Set<String> excludeIds;

        ElevationObj(String qstr, List<String> elevate, List<String> exclude) throws IOException {
            this.text = qstr;
            this.analyzed = QueryElevationComponent.this.getAnalyzedQuery(this.text);
            this.ids = new HashSet<String>();
            this.excludeIds = new HashSet<String>();
            this.include = new BooleanQuery();
            this.include.setBoost(0.0f);
            this.priority = new HashMap<BytesRef, Integer>();
            int max = elevate.size() + 5;
            for (String id : elevate) {
                id = QueryElevationComponent.this.idSchemaFT.readableToIndexed(id);
                this.ids.add(id);
                TermQuery tq = new TermQuery(new Term(QueryElevationComponent.this.idField, id));
                this.include.add((Query)tq, BooleanClause.Occur.SHOULD);
                this.priority.put(new BytesRef((CharSequence)id), max--);
            }
            if (exclude == null || exclude.isEmpty()) {
                this.exclude = null;
            } else {
                this.exclude = new TermQuery[exclude.size()];
                for (int i = 0; i < exclude.size(); ++i) {
                    String id;
                    id = QueryElevationComponent.this.idSchemaFT.readableToIndexed(exclude.get(i));
                    this.excludeIds.add(id);
                    this.exclude[i] = new TermQuery(new Term(QueryElevationComponent.this.idField, id));
                }
            }
        }
    }
}

