/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.ParseUtils;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialArgsParser;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialQueryable;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SpatialOptions;
import org.apache.solr.util.MapListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpatialFieldType<T extends SpatialStrategy>
extends FieldType
implements SpatialQueryable {
    public static final String SCORE_PARAM = "score";
    public static final String FILTER_PARAM = "filter";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected SpatialContext ctx;
    protected SpatialArgsParser argsParser;
    private final Cache<String, T> fieldStrategyCache = CacheBuilder.newBuilder().build();

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        String units = args.remove("units");
        if (!"degrees".equals(units)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Must specify units=\"degrees\" on field types with class " + this.getClass().getSimpleName());
        }
        MapListener<String, String> argsWrap = new MapListener<String, String>(args);
        this.ctx = SpatialContextFactory.makeSpatialContext(argsWrap, (ClassLoader)schema.getResourceLoader().getClassLoader());
        args.keySet().removeAll(argsWrap.getSeenKeys());
        this.argsParser = new SpatialArgsParser();
    }

    public final Field createField(SchemaField field, Object val, float boost) {
        throw new IllegalStateException("instead call createFields() because isPolyField() is true");
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object val, float boost) {
        String shapeStr = null;
        Shape shape = null;
        if (val instanceof Shape) {
            shape = (Shape)val;
        } else {
            shapeStr = val.toString();
            shape = this.parseShape(shapeStr);
        }
        if (shape == null) {
            this.log.debug("Field {}: null shape for input: {}", (Object)field, val);
            return Collections.emptyList();
        }
        ArrayList<IndexableField> result = new ArrayList<IndexableField>();
        if (field.indexed()) {
            T strategy = this.getStrategy(field.getName());
            result.addAll(Arrays.asList(strategy.createIndexableFields(shape)));
        }
        if (field.stored()) {
            if (shapeStr == null) {
                shapeStr = this.shapeToString(shape);
            }
            result.add((IndexableField)new StoredField(field.getName(), shapeStr));
        }
        return result;
    }

    protected Shape parseShape(String shapeStr) {
        try {
            return this.ctx.readShape(shapeStr);
        }
        catch (InvalidShapeException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    protected String shapeToString(Shape shape) {
        return this.ctx.toString(shape);
    }

    protected abstract T newSpatialStrategy(String var1);

    @Override
    public final boolean isPolyField() {
        return true;
    }

    @Override
    public Query createSpatialQuery(QParser parser, SpatialOptions options) {
        double[] point = null;
        try {
            point = ParseUtils.parseLatitudeLongitude((String)options.pointStr);
        }
        catch (InvalidShapeException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        double latCenter = point[0];
        double lonCenter = point[1];
        double distDeg = DistanceUtils.dist2Degrees((double)options.distance, (double)options.radius);
        Circle shape = this.ctx.makeCircle(lonCenter, latCenter, distDeg);
        if (options.bbox) {
            shape = shape.getBoundingBox();
        }
        SpatialArgs spatialArgs = new SpatialArgs(SpatialOperation.Intersects, (Shape)shape);
        return this.getQueryFromSpatialArgs(parser, options.field, spatialArgs);
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        if (!minInclusive || !maxInclusive) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both sides of spatial range query must be inclusive: " + field.getName());
        }
        Shape shape1 = this.parseShape(part1);
        Shape shape2 = this.parseShape(part2);
        if (!(shape1 instanceof Point) || !(shape2 instanceof Point)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both sides of spatial range query must be points: " + field.getName());
        }
        Point p1 = (Point)shape1;
        Point p2 = (Point)shape2;
        Rectangle bbox = this.ctx.makeRectangle(p1, p2);
        SpatialArgs spatialArgs = new SpatialArgs(SpatialOperation.Intersects, (Shape)bbox);
        return this.getQueryFromSpatialArgs(parser, field, spatialArgs);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "A ValueSource isn't directly available from this field. Instead try a query using the distance as the score.");
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        return this.getQueryFromSpatialArgs(parser, field, this.parseSpatialArgs(externalVal));
    }

    protected SpatialArgs parseSpatialArgs(String externalVal) {
        try {
            return this.argsParser.parse(externalVal, this.ctx);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    private Query getQueryFromSpatialArgs(QParser parser, SchemaField field, SpatialArgs spatialArgs) {
        ValueSource valueSource;
        String score;
        T strategy = this.getStrategy(field.getName());
        SolrParams localParams = parser.getLocalParams();
        String string = score = localParams == null ? null : localParams.get(SCORE_PARAM);
        if (score == null || "none".equals(score) || "".equals(score)) {
            return strategy.makeQuery(spatialArgs);
        }
        if ("distance".equals(score)) {
            double multiplier = 1.0;
            valueSource = strategy.makeDistanceValueSource(spatialArgs.getShape().getCenter(), multiplier);
        } else if ("recipDistance".equals(score)) {
            valueSource = strategy.makeRecipDistanceValueSource(spatialArgs.getShape());
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'score' local-param must be one of 'none', 'distance', or 'recipDistance'");
        }
        FunctionQuery functionQuery = new FunctionQuery(valueSource);
        if (localParams != null && !localParams.getBool(FILTER_PARAM, true)) {
            return functionQuery;
        }
        Filter filter = strategy.makeFilter(spatialArgs);
        return new FilteredQuery((Query)functionQuery, filter);
    }

    public T getStrategy(final String fieldName) {
        try {
            return (T)((SpatialStrategy)this.fieldStrategyCache.get((Object)fieldName, new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return AbstractSpatialFieldType.this.newSpatialStrategy(fieldName);
                }
            }));
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sorting not supported on SpatialField: " + field.getName() + ", instead try sorting by query.");
    }
}

