/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.ParseUtils;
import com.spatial4j.core.shape.Point;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.ConstNumberSource;
import org.apache.lucene.queries.function.valuesource.DoubleConstValueSource;
import org.apache.lucene.queries.function.valuesource.MultiValueSource;
import org.apache.lucene.queries.function.valuesource.VectorValueSource;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.search.function.distance.HaversineConstFunction;
import org.apache.solr.search.function.distance.HaversineFunction;

public class GeoDistValueSourceParser
extends ValueSourceParser {
    @Override
    public ValueSource parse(FunctionQParser fp) throws SyntaxError {
        List<ValueSource> sources = fp.parseValueSourceList();
        MultiValueSource mv1 = null;
        MultiValueSource mv2 = null;
        if (sources.size() != 0) {
            ValueSource vs2;
            ValueSource vs1;
            if (sources.size() == 1) {
                ValueSource vs = sources.get(0);
                if (!(vs instanceof MultiValueSource)) {
                    throw new SyntaxError("geodist - invalid parameters:" + sources);
                }
                mv1 = (MultiValueSource)vs;
            } else if (sources.size() == 2) {
                vs1 = sources.get(0);
                vs2 = sources.get(1);
                if (vs1 instanceof MultiValueSource && vs2 instanceof MultiValueSource) {
                    mv1 = (MultiValueSource)vs1;
                    mv2 = (MultiValueSource)vs2;
                } else {
                    mv1 = this.makeMV(sources, sources);
                }
            } else if (sources.size() == 3) {
                vs1 = sources.get(0);
                vs2 = sources.get(1);
                if (vs1 instanceof MultiValueSource) {
                    mv1 = (MultiValueSource)vs1;
                    mv2 = this.makeMV(sources.subList(1, 3), sources);
                } else {
                    mv1 = this.makeMV(sources.subList(0, 2), sources);
                    vs1 = sources.get(2);
                    if (!(vs1 instanceof MultiValueSource)) {
                        throw new SyntaxError("geodist - invalid parameters:" + sources);
                    }
                    mv2 = (MultiValueSource)vs1;
                }
            } else if (sources.size() == 4) {
                mv1 = this.makeMV(sources.subList(0, 2), sources);
                mv2 = this.makeMV(sources.subList(2, 4), sources);
            } else if (sources.size() > 4) {
                throw new SyntaxError("geodist - invalid parameters:" + sources);
            }
        }
        if (mv1 == null) {
            mv1 = this.parsePoint(fp);
            mv2 = this.parseSfield(fp);
        } else if (mv2 == null && (mv2 = this.parsePoint(fp)) == null) {
            mv2 = this.parseSfield(fp);
        }
        if (mv1 == null || mv2 == null) {
            throw new SyntaxError("geodist - not enough parameters:" + sources);
        }
        double[] constants = this.getConstants(mv1);
        MultiValueSource other = mv2;
        if (constants == null) {
            constants = this.getConstants(mv2);
            other = mv1;
        }
        if (mv2 instanceof SpatialStrategyMultiValueSource) {
            if (constants == null) {
                throw new SyntaxError("When using AbstractSpatialFieldType (e.g. RPT not LatLonType), the point must be supplied as constants");
            }
            SpatialStrategy strategy = ((SpatialStrategyMultiValueSource)mv2).strategy;
            Point queryPoint = strategy.getSpatialContext().makePoint(constants[1], constants[0]);
            double multiplier = DistanceUtils.degrees2Dist((double)1.0, (double)6371.0087714);
            return strategy.makeDistanceValueSource(queryPoint, multiplier);
        }
        if (constants != null && other instanceof VectorValueSource) {
            return new HaversineConstFunction(constants[0], constants[1], (VectorValueSource)other);
        }
        return new HaversineFunction(mv1, mv2, 6371.0087714, true);
    }

    private VectorValueSource makeMV(List<ValueSource> sources, List<ValueSource> orig) throws SyntaxError {
        ValueSource vs1 = sources.get(0);
        ValueSource vs2 = sources.get(1);
        if (vs1 instanceof MultiValueSource || vs2 instanceof MultiValueSource) {
            throw new SyntaxError("geodist - invalid parameters:" + orig);
        }
        return new VectorValueSource(sources);
    }

    private MultiValueSource parsePoint(FunctionQParser fp) throws SyntaxError {
        String pt = fp.getParam("pt");
        if (pt == null) {
            return null;
        }
        double[] point = null;
        try {
            point = ParseUtils.parseLatitudeLongitude((String)pt);
        }
        catch (InvalidShapeException e) {
            throw new SyntaxError("Bad spatial pt:" + pt);
        }
        return new VectorValueSource(Arrays.asList(new DoubleConstValueSource(point[0]), new DoubleConstValueSource(point[1])));
    }

    private double[] getConstants(MultiValueSource vs) {
        if (!(vs instanceof VectorValueSource)) {
            return null;
        }
        List sources = ((VectorValueSource)vs).getSources();
        if (sources.get(0) instanceof ConstNumberSource && sources.get(1) instanceof ConstNumberSource) {
            return new double[]{((ConstNumberSource)sources.get(0)).getDouble(), ((ConstNumberSource)sources.get(1)).getDouble()};
        }
        return null;
    }

    private MultiValueSource parseSfield(FunctionQParser fp) throws SyntaxError {
        String sfield = fp.getParam("sfield");
        if (sfield == null) {
            return null;
        }
        SchemaField sf = fp.getReq().getSchema().getField(sfield);
        FieldType type = sf.getType();
        if (type instanceof AbstractSpatialFieldType) {
            AbstractSpatialFieldType asft = (AbstractSpatialFieldType)type;
            return new SpatialStrategyMultiValueSource((SpatialStrategy)asft.getStrategy(sfield));
        }
        ValueSource vs = type.getValueSource(sf, fp);
        if (vs instanceof MultiValueSource) {
            return (MultiValueSource)vs;
        }
        throw new SyntaxError("Spatial field must implement MultiValueSource or extend AbstractSpatialFieldType:" + sf);
    }

    private static class SpatialStrategyMultiValueSource
    extends VectorValueSource {
        final SpatialStrategy strategy;

        public SpatialStrategyMultiValueSource(SpatialStrategy strategy) {
            super(Collections.EMPTY_LIST);
            this.strategy = strategy;
        }

        public List<ValueSource> getSources() {
            throw new IllegalStateException();
        }
    }
}

