/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.endresulttransformer;

import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;
import org.apache.solr.search.grouping.endresulttransformer.EndResultTransformer;

public class GroupedEndResultTransformer
implements EndResultTransformer {
    private final SolrIndexSearcher searcher;

    public GroupedEndResultTransformer(SolrIndexSearcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public void transform(Map<String, ?> result, ResponseBuilder rb, EndResultTransformer.SolrDocumentSource solrDocumentSource) {
        SimpleOrderedMap commands = new SimpleOrderedMap();
        for (Map.Entry<String, ?> entry : result.entrySet()) {
            SimpleOrderedMap command;
            Object value = entry.getValue();
            if (TopGroups.class.isInstance(value)) {
                TopGroups topGroups = (TopGroups)value;
                command = new SimpleOrderedMap();
                command.add("matches", (Object)rb.totalHitCount);
                Integer totalGroupCount = rb.mergedGroupCounts.get(entry.getKey());
                if (totalGroupCount != null) {
                    command.add("ngroups", (Object)totalGroupCount);
                }
                ArrayList<SimpleOrderedMap> groups = new ArrayList<SimpleOrderedMap>();
                SchemaField groupField = this.searcher.getSchema().getField(entry.getKey());
                FieldType groupFieldType = groupField.getType();
                for (GroupDocs group : topGroups.groups) {
                    SimpleOrderedMap groupResult = new SimpleOrderedMap();
                    if (group.groupValue != null) {
                        groupResult.add("groupValue", groupFieldType.toObject(groupField.createField(((BytesRef)group.groupValue).utf8ToString(), 1.0f)));
                    } else {
                        groupResult.add("groupValue", null);
                    }
                    SolrDocumentList docList = new SolrDocumentList();
                    docList.setNumFound((long)group.totalHits);
                    if (!Float.isNaN(group.maxScore)) {
                        docList.setMaxScore(Float.valueOf(group.maxScore));
                    }
                    docList.setStart((long)rb.getGroupingSpec().getGroupOffset());
                    for (ScoreDoc scoreDoc : group.scoreDocs) {
                        docList.add((Object)solrDocumentSource.retrieve(scoreDoc));
                    }
                    groupResult.add("doclist", (Object)docList);
                    groups.add(groupResult);
                }
                command.add("groups", groups);
                commands.add(entry.getKey(), (Object)command);
                continue;
            }
            if (!QueryCommandResult.class.isInstance(value)) continue;
            QueryCommandResult queryCommandResult = (QueryCommandResult)value;
            command = new SimpleOrderedMap();
            command.add("matches", (Object)queryCommandResult.getMatches());
            SolrDocumentList docList = new SolrDocumentList();
            docList.setNumFound((long)queryCommandResult.getTopDocs().totalHits);
            if (!Float.isNaN(queryCommandResult.getTopDocs().getMaxScore())) {
                docList.setMaxScore(Float.valueOf(queryCommandResult.getTopDocs().getMaxScore()));
            }
            docList.setStart((long)rb.getGroupingSpec().getGroupOffset());
            for (ScoreDoc scoreDoc : queryCommandResult.getTopDocs().scoreDocs) {
                docList.add((Object)solrDocumentSource.retrieve(scoreDoc));
            }
            command.add("doclist", (Object)docList);
            commands.add(entry.getKey(), (Object)command);
        }
        rb.rsp.add("grouped", commands);
    }
}

