/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public class IgnoreAcceptDocsQuery
extends Query {
    private final Query q;

    public IgnoreAcceptDocsQuery(Query q) {
        this.q = q;
    }

    public void setBoost(float b) {
        this.q.setBoost(b);
    }

    public float getBoost() {
        return this.q.getBoost();
    }

    public String toString() {
        return this.q.toString();
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Weight inner = this.q.createWeight(searcher);
        return new IADWeight(inner);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query n = this.q.rewrite(reader);
        if (this.q == n) {
            return this;
        }
        return new IgnoreAcceptDocsQuery(n);
    }

    public void extractTerms(Set<Term> terms) {
        this.q.extractTerms(terms);
    }

    public int hashCode() {
        return this.q.hashCode() * 31;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IgnoreAcceptDocsQuery)) {
            return false;
        }
        IgnoreAcceptDocsQuery other = (IgnoreAcceptDocsQuery)((Object)o);
        return this.q.equals((Object)other.q);
    }

    public String toString(String field) {
        return "IgnoreAcceptDocs(" + this.q + ")";
    }

    private class IADWeight
    extends Weight {
        Weight w;

        IADWeight(Weight delegate) {
            this.w = delegate;
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return this.w.explain(context, doc);
        }

        public Query getQuery() {
            return IgnoreAcceptDocsQuery.this.q;
        }

        public float getValueForNormalization() throws IOException {
            return this.w.getValueForNormalization();
        }

        public void normalize(float norm, float topLevelBoost) {
            this.w.normalize(norm, topLevelBoost);
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            return this.w.scorer(context, scoreDocsInOrder, topScorer, null);
        }
    }
}

