/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.HashBasedRouter;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexSplitter {
    public static Logger log = LoggerFactory.getLogger(SolrIndexSplitter.class);
    SolrIndexSearcher searcher;
    SchemaField field;
    List<DocRouter.Range> ranges;
    DocRouter.Range[] rangesArr;
    List<String> paths;
    List<SolrCore> cores;
    DocRouter router;
    HashBasedRouter hashRouter;
    int numPieces;
    int currPartition = 0;

    public SolrIndexSplitter(SplitIndexCommand cmd) {
        this.searcher = cmd.getReq().getSearcher();
        this.field = this.searcher.getSchema().getUniqueKeyField();
        this.ranges = cmd.ranges;
        this.paths = cmd.paths;
        this.cores = cmd.cores;
        this.router = cmd.router;
        HashBasedRouter hashBasedRouter = this.hashRouter = this.router instanceof HashBasedRouter ? (HashBasedRouter)this.router : null;
        if (this.ranges == null) {
            this.numPieces = this.paths != null ? this.paths.size() : this.cores.size();
        } else {
            this.numPieces = this.ranges.size();
            this.rangesArr = this.ranges.toArray(new DocRouter.Range[this.ranges.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split() throws IOException {
        List leaves = this.searcher.getTopReaderContext().leaves();
        ArrayList<OpenBitSet[]> segmentDocSets = new ArrayList<OpenBitSet[]>(leaves.size());
        log.info("SolrIndexSplitter: partitions=" + this.numPieces + " segments=" + leaves.size());
        for (AtomicReaderContext readerContext : leaves) {
            assert (readerContext.ordInParent == segmentDocSets.size());
            OpenBitSet[] docSets = this.split(readerContext);
            segmentDocSets.add(docSets);
        }
        IndexReader[] subReaders = new IndexReader[leaves.size()];
        for (int partitionNumber = 0; partitionNumber < this.numPieces; ++partitionNumber) {
            IndexWriter iw;
            block13: {
                log.info("SolrIndexSplitter: partition #" + partitionNumber + (this.ranges != null ? " range=" + this.ranges.get(partitionNumber) : ""));
                for (int segmentNumber = 0; segmentNumber < subReaders.length; ++segmentNumber) {
                    subReaders[segmentNumber] = new LiveDocsReader((AtomicReaderContext)leaves.get(segmentNumber), ((OpenBitSet[])segmentDocSets.get(segmentNumber))[partitionNumber]);
                }
                boolean success = false;
                RefCounted<IndexWriter> iwRef = null;
                iw = null;
                if (this.cores != null) {
                    SolrCore subCore = this.cores.get(partitionNumber);
                    iwRef = subCore.getUpdateHandler().getSolrCoreState().getIndexWriter(subCore);
                    iw = iwRef.get();
                } else {
                    SolrCore core = this.searcher.getCore();
                    String path = this.paths.get(partitionNumber);
                    iw = SolrIndexWriter.create("SplittingIndexWriter" + partitionNumber + (this.ranges != null ? " " + this.ranges.get(partitionNumber) : ""), path, core.getDirectoryFactory(), true, core.getLatestSchema(), core.getSolrConfig().indexConfig, core.getDeletionPolicy(), core.getCodec());
                }
                try {
                    iw.addIndexes(subReaders);
                    success = true;
                    if (iwRef != null) {
                        iwRef.decref();
                        continue;
                    }
                    if (!success) break block13;
                }
                catch (Throwable throwable) {
                    if (iwRef != null) {
                        iwRef.decref();
                    } else if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{iw});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{iw});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{iw});
                continue;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{iw});
        }
    }

    OpenBitSet[] split(AtomicReaderContext readerContext) throws IOException {
        TermsEnum termsEnum;
        AtomicReader reader = readerContext.reader();
        OpenBitSet[] docSets = new OpenBitSet[this.numPieces];
        for (int i = 0; i < docSets.length; ++i) {
            docSets[i] = new OpenBitSet((long)reader.maxDoc());
        }
        Bits liveDocs = reader.getLiveDocs();
        Fields fields = reader.fields();
        Terms terms = fields == null ? null : fields.terms(this.field.getName());
        TermsEnum termsEnum2 = termsEnum = terms == null ? null : terms.iterator(null);
        if (termsEnum == null) {
            return docSets;
        }
        BytesRef term = null;
        DocsEnum docsEnum = null;
        CharsRef idRef = new CharsRef(100);
        while ((term = termsEnum.next()) != null) {
            int doc;
            idRef = this.field.getType().indexedToReadable(term, idRef);
            String idString = idRef.toString();
            int hash = 0;
            if (this.hashRouter != null) {
                hash = this.hashRouter.sliceHash(idString, null, null, null);
            }
            docsEnum = termsEnum.docs(liveDocs, docsEnum, 0);
            while ((doc = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                if (this.ranges == null) {
                    docSets[this.currPartition].fastSet(doc);
                    this.currPartition = (this.currPartition + 1) % this.numPieces;
                    continue;
                }
                for (int i = 0; i < this.rangesArr.length; ++i) {
                    if (!this.rangesArr[i].includes(hash)) continue;
                    docSets[i].fastSet(doc);
                }
            }
        }
        return docSets;
    }

    static class LiveDocsReader
    extends FilterAtomicReader {
        final OpenBitSet liveDocs;
        final int numDocs;

        public LiveDocsReader(AtomicReaderContext context, OpenBitSet liveDocs) throws IOException {
            super(context.reader());
            this.liveDocs = liveDocs;
            this.numDocs = (int)liveDocs.cardinality();
        }

        public int numDocs() {
            return this.numDocs;
        }

        public Bits getLiveDocs() {
            return this.liveDocs;
        }
    }
}

