/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering.carrot2;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.clustering.SearchClusteringEngine;
import org.apache.solr.handler.clustering.carrot2.CarrotParams;
import org.apache.solr.handler.clustering.carrot2.LuceneCarrot2StemmerFactory;
import org.apache.solr.handler.clustering.carrot2.LuceneCarrot2TokenizerFactory;
import org.apache.solr.handler.clustering.carrot2.SolrResourceLocator;
import org.apache.solr.handler.clustering.carrot2.SolrStopwordsCarrot2LexicalDataFactory;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.SolrIndexSearcher;
import org.carrot2.core.Cluster;
import org.carrot2.core.Controller;
import org.carrot2.core.ControllerFactory;
import org.carrot2.core.Document;
import org.carrot2.core.IClusteringAlgorithm;
import org.carrot2.core.LanguageCode;
import org.carrot2.text.linguistic.DefaultLexicalDataFactoryDescriptor;
import org.carrot2.text.preprocessing.pipeline.BasicPreprocessingPipelineDescriptor;
import org.carrot2.util.attribute.AttributeValueSet;
import org.carrot2.util.attribute.AttributeValueSets;
import org.carrot2.util.resource.ClassLoaderLocator;
import org.carrot2.util.resource.IResourceLocator;
import org.carrot2.util.resource.ResourceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarrotClusteringEngine
extends SearchClusteringEngine {
    static transient Logger log = LoggerFactory.getLogger(CarrotClusteringEngine.class);
    static final String CARROT_RESOURCES_PREFIX = "clustering/carrot2";
    private static final String SOLR_DOCUMENT_ID = "solrId";
    private String idFieldName;
    private Controller controller = ControllerFactory.createPooling();
    private Class<? extends IClusteringAlgorithm> clusteringAlgorithmClass;
    private SolrCore core;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String init(NamedList config, SolrCore core) {
        ClassLoader prev;
        Thread ct;
        Object[] attributeXmls;
        this.core = core;
        String result = super.init(config, core);
        SolrParams initParams = SolrParams.toSolrParams((NamedList)config);
        HashMap<String, Object> initAttributes = new HashMap<String, Object>();
        ResourceLookup resourceLookup = new ResourceLookup(new IResourceLocator[]{new SolrResourceLocator(core, initParams), new ClassLoaderLocator(core.getResourceLoader().getClassLoader())});
        DefaultLexicalDataFactoryDescriptor.attributeBuilder(initAttributes).resourceLookup(resourceLookup);
        String componentName = initParams.get("name");
        log.info("Initializing Clustering Engine '" + (String)Objects.firstNonNull((Object)componentName, (Object)"<no 'name' attribute>") + "'");
        if (!Strings.isNullOrEmpty((String)componentName) && (attributeXmls = resourceLookup.getAll(componentName + "-attributes.xml")).length > 0) {
            if (attributeXmls.length > 1) {
                log.warn("More than one attribute file found, first one will be used: " + Arrays.toString(attributeXmls));
            }
            ct = Thread.currentThread();
            prev = ct.getContextClassLoader();
            try {
                ct.setContextClassLoader(core.getResourceLoader().getClassLoader());
                AttributeValueSets avs = AttributeValueSets.deserialize((InputStream)attributeXmls[0].open());
                AttributeValueSet defaultSet = avs.getDefaultAttributeValueSet();
                initAttributes.putAll(defaultSet.getAttributeValues());
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not read attributes XML for clustering component: " + componentName, (Throwable)e);
            }
            finally {
                ct.setContextClassLoader(prev);
            }
        }
        this.extractCarrotAttributes(initParams, initAttributes);
        BasicPreprocessingPipelineDescriptor.AttributeBuilder attributeBuilder = BasicPreprocessingPipelineDescriptor.attributeBuilder(initAttributes);
        attributeBuilder.lexicalDataFactory(SolrStopwordsCarrot2LexicalDataFactory.class);
        if (!initAttributes.containsKey("PreprocessingPipeline.tokenizerFactory")) {
            attributeBuilder.tokenizerFactory(LuceneCarrot2TokenizerFactory.class);
        }
        if (!initAttributes.containsKey("PreprocessingPipeline.stemmerFactory")) {
            attributeBuilder.stemmerFactory(LuceneCarrot2StemmerFactory.class);
        }
        initAttributes.put("solrCore", core);
        ct = Thread.currentThread();
        prev = ct.getContextClassLoader();
        try {
            ct.setContextClassLoader(core.getResourceLoader().getClassLoader());
            this.controller.init(initAttributes);
        }
        finally {
            ct.setContextClassLoader(prev);
        }
        SchemaField uniqueField = core.getLatestSchema().getUniqueKeyField();
        if (uniqueField == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, CarrotClusteringEngine.class.getSimpleName() + " requires the schema to have a uniqueKeyField");
        }
        this.idFieldName = uniqueField.getName();
        String carrotAlgorithmClassName = initParams.get(CarrotParams.ALGORITHM);
        this.clusteringAlgorithmClass = core.getResourceLoader().findClass(carrotAlgorithmClassName, IClusteringAlgorithm.class);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object cluster(Query query, SolrDocumentList solrDocList, Map<SolrDocument, Integer> docIds, SolrQueryRequest sreq) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        List<Document> documents = this.getDocuments(solrDocList, docIds, query, sreq);
        attributes.put("documents", documents);
        attributes.put("query", query.toString());
        attributes.put("solrFieldNames", this.getFieldsForClustering(sreq));
        this.extractCarrotAttributes(sreq.getParams(), attributes);
        Thread ct = Thread.currentThread();
        ClassLoader prev = ct.getContextClassLoader();
        try {
            ct.setContextClassLoader(this.core.getResourceLoader().getClassLoader());
            List<NamedList<Object>> list = this.clustersToNamedList(this.controller.process(attributes, new Class[]{this.clusteringAlgorithmClass}).getClusters(), sreq.getParams());
            ct.setContextClassLoader(prev);
            return list;
        }
        catch (Throwable throwable) {
            try {
                ct.setContextClassLoader(prev);
                throw throwable;
            }
            catch (Exception e) {
                log.error("Carrot2 clustering failed", (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Carrot2 clustering failed", (Throwable)e);
            }
        }
    }

    @Override
    protected Set<String> getFieldsToLoad(SolrQueryRequest sreq) {
        SolrParams solrParams = sreq.getParams();
        HashSet fields = Sets.newHashSet(this.getFieldsForClustering(sreq));
        fields.add(this.idFieldName);
        fields.add(solrParams.get(CarrotParams.URL_FIELD_NAME, "url"));
        fields.addAll(this.getCustomFieldsMap(solrParams).keySet());
        String languageField = solrParams.get(CarrotParams.LANGUAGE_FIELD_NAME);
        if (StringUtils.isNotBlank((String)languageField)) {
            fields.add(languageField);
        }
        return fields;
    }

    private Set<String> getFieldsForClustering(SolrQueryRequest sreq) {
        String titleFieldSpec;
        SolrParams solrParams = sreq.getParams();
        String snippetFieldSpec = solrParams.get(CarrotParams.SNIPPET_FIELD_NAME, titleFieldSpec = solrParams.get(CarrotParams.TITLE_FIELD_NAME, "title"));
        if (StringUtils.isBlank((String)snippetFieldSpec)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, CarrotParams.SNIPPET_FIELD_NAME + " must not be blank.");
        }
        HashSet fields = Sets.newHashSet();
        fields.addAll(Arrays.asList(titleFieldSpec.split("[, ]")));
        fields.addAll(Arrays.asList(snippetFieldSpec.split("[, ]")));
        return fields;
    }

    private List<Document> getDocuments(SolrDocumentList solrDocList, Map<SolrDocument, Integer> docIds, Query query, final SolrQueryRequest sreq) throws IOException {
        SolrHighlighter highlighter = null;
        SolrParams solrParams = sreq.getParams();
        SolrCore core = sreq.getCore();
        String urlField = solrParams.get(CarrotParams.URL_FIELD_NAME, "url");
        String titleFieldSpec = solrParams.get(CarrotParams.TITLE_FIELD_NAME, "title");
        String snippetFieldSpec = solrParams.get(CarrotParams.SNIPPET_FIELD_NAME, titleFieldSpec);
        String languageField = solrParams.get(CarrotParams.LANGUAGE_FIELD_NAME, null);
        Map<String, String> customFields = this.getCustomFieldsMap(solrParams);
        HashMap languageCodeMap = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)languageField)) {
            for (String pair : solrParams.get(CarrotParams.LANGUAGE_CODE_MAP, "").split("[, ]")) {
                String[] split = pair.split(":");
                if (split.length == 2 && StringUtils.isNotBlank((String)split[0]) && StringUtils.isNotBlank((String)split[1])) {
                    languageCodeMap.put(split[0], split[1]);
                    continue;
                }
                log.warn("Unsupported format for " + CarrotParams.LANGUAGE_CODE_MAP + ": '" + pair + "'. Skipping this mapping.");
            }
        }
        boolean produceSummary = solrParams.getBool(CarrotParams.PRODUCE_SUMMARY, false);
        LocalSolrQueryRequest req = null;
        String[] snippetFieldAry = null;
        if (produceSummary) {
            highlighter = HighlightComponent.getHighlighter((SolrCore)core);
            if (highlighter != null) {
                HashMap args = Maps.newHashMap();
                snippetFieldAry = snippetFieldSpec.split("[, ]");
                args.put("hl.fl", snippetFieldAry);
                args.put("hl", "true");
                args.put("hl.simple.pre", "");
                args.put("hl.simple.post", "");
                args.put("hl.fragsize", solrParams.getInt(CarrotParams.SUMMARY_FRAGSIZE, solrParams.getInt("hl.fragsize", 100)));
                args.put("hl.snippets", solrParams.getInt(CarrotParams.SUMMARY_SNIPPETS, solrParams.getInt("hl.snippets", 1)));
                req = new LocalSolrQueryRequest(core, query.toString(), "", 0, 1, args){

                    public SolrIndexSearcher getSearcher() {
                        return sreq.getSearcher();
                    }
                };
            } else {
                log.warn("No highlighter configured, cannot produce summary");
                produceSummary = false;
            }
        }
        Iterator docsIter = solrDocList.iterator();
        ArrayList<Document> result = new ArrayList<Document>(solrDocList.size());
        float[] scores = new float[]{1.0f};
        int[] docsHolder = new int[1];
        Query theQuery = query;
        while (docsIter.hasNext()) {
            Collection languages;
            SolrDocument sdoc = (SolrDocument)docsIter.next();
            String snippet = null;
            if (produceSummary && docIds != null) {
                docsHolder[0] = docIds.get(sdoc);
                DocSlice docAsList = new DocSlice(0, 1, docsHolder, scores, 1, 1.0f);
                NamedList highlights = highlighter.doHighlighting((DocList)docAsList, theQuery, req, snippetFieldAry);
                if (highlights != null && highlights.size() == 1) {
                    NamedList tmp = (NamedList)highlights.getVal(0);
                    StringBuilder sb = new StringBuilder();
                    for (int j = 0; j < snippetFieldAry.length; ++j) {
                        String[] highlt = (String[])tmp.get(snippetFieldAry[j]);
                        if (highlt == null || highlt.length <= 0) continue;
                        for (int i = 0; i < highlt.length; ++i) {
                            sb.append(highlt[i]);
                            sb.append(" . ");
                        }
                    }
                    snippet = sb.toString();
                }
            }
            if (snippet == null) {
                snippet = this.getConcatenated(sdoc, snippetFieldSpec);
            }
            Document carrotDocument = new Document(this.getConcatenated(sdoc, titleFieldSpec), snippet, ObjectUtils.toString((Object)sdoc.getFieldValue(urlField), (String)""));
            carrotDocument.setField(SOLR_DOCUMENT_ID, sdoc.getFieldValue(this.idFieldName));
            if (StringUtils.isNotBlank((String)languageField) && (languages = sdoc.getFieldValues(languageField)) != null) {
                for (Object l : languages) {
                    LanguageCode carrot2Language;
                    String lang = ObjectUtils.toString(l, (String)"");
                    if (languageCodeMap.containsKey(lang)) {
                        lang = (String)languageCodeMap.get(lang);
                    }
                    if (lang.indexOf(45) > 0) {
                        lang = lang.replace('-', '_');
                    }
                    if ((carrot2Language = LanguageCode.forISOCode((String)lang)) == null) continue;
                    carrotDocument.setLanguage(carrot2Language);
                    break;
                }
            }
            if (customFields != null) {
                for (Map.Entry<String, String> entry : customFields.entrySet()) {
                    carrotDocument.setField(entry.getValue(), sdoc.getFieldValue(entry.getKey()));
                }
            }
            result.add(carrotDocument);
        }
        return result;
    }

    Class<? extends IClusteringAlgorithm> getClusteringAlgorithmClass() {
        return this.clusteringAlgorithmClass;
    }

    private Map<String, String> getCustomFieldsMap(SolrParams solrParams) {
        HashMap customFields = Maps.newHashMap();
        String[] customFieldsSpec = solrParams.getParams(CarrotParams.CUSTOM_FIELD_NAME);
        if (customFieldsSpec != null) {
            customFields = Maps.newHashMap();
            for (String customFieldSpec : customFieldsSpec) {
                String[] split = customFieldSpec.split(":");
                if (split.length == 2 && StringUtils.isNotBlank((String)split[0]) && StringUtils.isNotBlank((String)split[1])) {
                    customFields.put(split[0], split[1]);
                    continue;
                }
                log.warn("Unsupported format for " + CarrotParams.CUSTOM_FIELD_NAME + ": '" + customFieldSpec + "'. Skipping this field definition.");
            }
        }
        return customFields;
    }

    private String getConcatenated(SolrDocument sdoc, String fieldsSpec) {
        StringBuilder result = new StringBuilder();
        for (String field : fieldsSpec.split("[, ]")) {
            Collection vals = sdoc.getFieldValues(field);
            if (vals == null) continue;
            Iterator ite = vals.iterator();
            while (ite.hasNext()) {
                result.append(ObjectUtils.toString(ite.next())).append(" . ");
            }
        }
        return result.toString().trim();
    }

    private List<NamedList<Object>> clustersToNamedList(List<Cluster> carrotClusters, SolrParams solrParams) {
        ArrayList result = Lists.newArrayList();
        this.clustersToNamedList(carrotClusters, result, solrParams.getBool(CarrotParams.OUTPUT_SUB_CLUSTERS, true), solrParams.getInt(CarrotParams.NUM_DESCRIPTIONS, Integer.MAX_VALUE));
        return result;
    }

    private void clustersToNamedList(List<Cluster> outputClusters, List<NamedList<Object>> parent, boolean outputSubClusters, int maxLabels) {
        for (Cluster outCluster : outputClusters) {
            SimpleOrderedMap cluster = new SimpleOrderedMap();
            parent.add((NamedList<Object>)cluster);
            List labels = outCluster.getPhrases();
            if (labels.size() > maxLabels) {
                labels = labels.subList(0, maxLabels);
            }
            cluster.add("labels", (Object)labels);
            Double score = outCluster.getScore();
            if (score != null) {
                cluster.add("score", (Object)score);
            }
            if (outCluster.isOtherTopics()) {
                cluster.add("other-topics", (Object)outCluster.isOtherTopics());
            }
            List docs = outputSubClusters ? outCluster.getDocuments() : outCluster.getAllDocuments();
            ArrayList docList = Lists.newArrayList();
            cluster.add("docs", (Object)docList);
            for (Document doc : docs) {
                docList.add(doc.getField(SOLR_DOCUMENT_ID));
            }
            if (!outputSubClusters || outCluster.getSubclusters().isEmpty()) continue;
            ArrayList subclusters = Lists.newArrayList();
            cluster.add("clusters", (Object)subclusters);
            this.clustersToNamedList(outCluster.getSubclusters(), subclusters, outputSubClusters, maxLabels);
        }
    }

    private void extractCarrotAttributes(SolrParams solrParams, Map<String, Object> attributes) {
        Iterator paramNames = solrParams.getParameterNamesIterator();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            if (CarrotParams.CARROT_PARAM_NAMES.contains(paramName)) continue;
            attributes.put(paramName, solrParams.get(paramName));
        }
    }
}

