/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.SimplePropertiesWriter;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKPropertiesWriter
extends SimplePropertiesWriter {
    private static final Logger log = LoggerFactory.getLogger(ZKPropertiesWriter.class);
    private String path;
    private SolrZkClient zkClient;

    @Override
    public void init(DataImporter dataImporter, Map<String, String> params) {
        super.init(dataImporter, params);
        this.zkClient = dataImporter.getCore().getCoreDescriptor().getCoreContainer().getZkController().getZkClient();
    }

    @Override
    protected void findDirectory(DataImporter dataImporter, Map<String, String> params) {
        String collection = dataImporter.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName();
        this.path = "/configs/" + collection + "/" + this.filename;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public void persist(Map<String, Object> propObjs) {
        Properties existing = this.mapToProperties(this.readIndexerProperties());
        existing.putAll((Map<?, ?>)this.mapToProperties(propObjs));
        StringWriter output = new StringWriter();
        try {
            existing.store(output, null);
            byte[] bytes = output.toString().getBytes(IOUtils.CHARSET_UTF_8);
            if (!this.zkClient.exists(this.path, false).booleanValue()) {
                try {
                    this.zkClient.makePath(this.path, false);
                }
                catch (KeeperException.NodeExistsException e) {
                    // empty catch block
                }
            }
            this.zkClient.setData(this.path, bytes, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Could not persist properties to " + this.path + " :" + e.getClass(), (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Could not persist properties to " + this.path + " :" + e.getClass(), (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> readIndexerProperties() {
        Properties props = new Properties();
        try {
            byte[] data = this.zkClient.getData(this.path, null, null, false);
            if (data != null) {
                props.load(new StringReader(new String(data, "UTF-8")));
            }
        }
        catch (Throwable e) {
            log.warn("Could not read DIH properties from " + this.path + " :" + e.getClass(), e);
        }
        return this.propertiesToMap(props);
    }
}

