/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FilterIterator;

public final class FieldFilterAtomicReader
extends FilterAtomicReader {
    private final Set<String> fields;
    private final boolean negate;
    private final FieldInfos fieldInfos;

    public FieldFilterAtomicReader(AtomicReader in, Set<String> fields, boolean negate) {
        super(in);
        this.fields = fields;
        this.negate = negate;
        ArrayList<FieldInfo> filteredInfos = new ArrayList<FieldInfo>();
        for (FieldInfo fi : in.getFieldInfos()) {
            if (!this.hasField(fi.name)) continue;
            filteredInfos.add(fi);
        }
        this.fieldInfos = new FieldInfos(filteredInfos.toArray(new FieldInfo[filteredInfos.size()]));
    }

    boolean hasField(String field) {
        return this.negate ^ this.fields.contains(field);
    }

    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    public Fields getTermVectors(int docID) throws IOException {
        Object f = super.getTermVectors(docID);
        if (f == null) {
            return null;
        }
        return (f = new FieldFilterFields((Fields)f)).iterator().hasNext() ? f : null;
    }

    public void document(int docID, final StoredFieldVisitor visitor) throws IOException {
        super.document(docID, new StoredFieldVisitor(){

            public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
                visitor.binaryField(fieldInfo, value);
            }

            public void stringField(FieldInfo fieldInfo, String value) throws IOException {
                visitor.stringField(fieldInfo, value);
            }

            public void intField(FieldInfo fieldInfo, int value) throws IOException {
                visitor.intField(fieldInfo, value);
            }

            public void longField(FieldInfo fieldInfo, long value) throws IOException {
                visitor.longField(fieldInfo, value);
            }

            public void floatField(FieldInfo fieldInfo, float value) throws IOException {
                visitor.floatField(fieldInfo, value);
            }

            public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
                visitor.doubleField(fieldInfo, value);
            }

            public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                return FieldFilterAtomicReader.this.hasField(fieldInfo.name) ? visitor.needsField(fieldInfo) : StoredFieldVisitor.Status.NO;
            }
        });
    }

    public Fields fields() throws IOException {
        Fields f = super.fields();
        return f == null ? null : new FieldFilterFields(f);
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getNumericDocValues(field) : null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getBinaryDocValues(field) : null;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getSortedDocValues(field) : null;
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        return this.hasField(field) ? super.getNormValues(field) : null;
    }

    public Bits getDocsWithField(String field) throws IOException {
        return this.hasField(field) ? super.getDocsWithField(field) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FieldFilterAtomicReader(reader=");
        sb.append(this.in).append(", fields=");
        if (this.negate) {
            sb.append('!');
        }
        return sb.append(this.fields).append(')').toString();
    }

    private class FieldFilterFields
    extends FilterAtomicReader.FilterFields {
        public FieldFilterFields(Fields in) {
            super(in);
        }

        public int size() {
            return -1;
        }

        public Iterator<String> iterator() {
            return new FilterIterator<String>(super.iterator()){

                protected boolean predicateFunction(String field) {
                    return FieldFilterAtomicReader.this.hasField(field);
                }
            };
        }

        public Terms terms(String field) throws IOException {
            return FieldFilterAtomicReader.this.hasField(field) ? super.terms(field) : null;
        }
    }
}

