/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;

public class JavaBinUpdateRequestCodec {
    public void marshal(UpdateRequest updateRequest, OutputStream os) throws IOException {
        NamedList<Object> nl = new NamedList<Object>();
        NamedList params = this.solrParamsToNamedList(updateRequest.getParams());
        if (updateRequest.getCommitWithin() != -1) {
            params.add("commitWithin", updateRequest.getCommitWithin());
        }
        Iterator<SolrInputDocument> docIter = null;
        if (updateRequest.getDocuments() != null) {
            docIter = updateRequest.getDocuments().iterator();
        }
        if (updateRequest.getDocIterator() != null) {
            docIter = updateRequest.getDocIterator();
        }
        Map<SolrInputDocument, Map<String, Object>> docMap = updateRequest.getDocumentsMap();
        nl.add("params", params);
        nl.add("delByIdMap", updateRequest.getDeleteByIdMap());
        nl.add("delByQ", updateRequest.getDeleteQuery());
        nl.add("docs", docIter);
        nl.add("docsMap", docMap);
        JavaBinCodec codec = new JavaBinCodec();
        codec.marshal(nl, os);
    }

    public UpdateRequest unmarshal(InputStream is, final StreamingUpdateHandler handler) throws IOException {
        NamedList params;
        final UpdateRequest updateRequest = new UpdateRequest();
        final NamedList[] namedList = new NamedList[1];
        JavaBinCodec codec = new JavaBinCodec(){
            private boolean seenOuterMostDocIterator = false;

            public NamedList readNamedList(DataInputInputStream dis) throws IOException {
                int sz = this.readSize(dis);
                NamedList<Object> nl = new NamedList<Object>();
                if (namedList[0] == null) {
                    namedList[0] = nl;
                }
                for (int i = 0; i < sz; ++i) {
                    String name = (String)this.readVal(dis);
                    Object val = this.readVal(dis);
                    nl.add(name, val);
                }
                return nl;
            }

            public List readIterator(DataInputInputStream fis) throws IOException {
                if (this.seenOuterMostDocIterator) {
                    return super.readIterator(fis);
                }
                this.seenOuterMostDocIterator = true;
                return this.readOuterMostDocIterator(fis);
            }

            private List readOuterMostDocIterator(DataInputInputStream fis) throws IOException {
                Object o;
                NamedList params = (NamedList)namedList[0].getVal(0);
                updateRequest.setParams(new ModifiableSolrParams(SolrParams.toSolrParams(params)));
                if (handler == null) {
                    return super.readIterator(fis);
                }
                while ((o = this.readVal(fis)) != END_OBJ) {
                    SolrInputDocument sdoc = null;
                    if (o instanceof List) {
                        sdoc = JavaBinUpdateRequestCodec.this.listToSolrInputDocument((List)o);
                    } else if (o instanceof NamedList) {
                        UpdateRequest req = new UpdateRequest();
                        req.setParams(new ModifiableSolrParams(SolrParams.toSolrParams((NamedList)o)));
                        handler.update(null, req);
                    } else {
                        sdoc = (SolrInputDocument)o;
                    }
                    handler.update(sdoc, updateRequest);
                }
                return Collections.EMPTY_LIST;
            }
        };
        codec.unmarshal(is);
        if (updateRequest.getParams() == null && (params = (NamedList)namedList[0].get("params")) != null) {
            updateRequest.setParams(new ModifiableSolrParams(SolrParams.toSolrParams(params)));
        }
        List delById = (List)namedList[0].get("delById");
        Map delByIdMap = (Map)namedList[0].get("delByIdMap");
        List delByQ = (List)namedList[0].get("delByQ");
        List doclist = (List)namedList[0].get("docs");
        Map docMap = (Map)namedList[0].get("docsMap");
        if (doclist != null && !doclist.isEmpty()) {
            ArrayList<SolrInputDocument> solrInputDocs = new ArrayList<SolrInputDocument>();
            for (List list : doclist) {
                if (list instanceof List) {
                    solrInputDocs.add(this.listToSolrInputDocument(list));
                    continue;
                }
                solrInputDocs.add((SolrInputDocument)((Object)list));
            }
            updateRequest.add(solrInputDocs);
        }
        if (docMap != null && !docMap.isEmpty()) {
            Set entries = docMap.entrySet();
            for (Map.Entry entry : entries) {
                Map map = (Map)entry.getValue();
                Boolean overwrite = null;
                Integer commitWithin = null;
                if (map != null) {
                    overwrite = (Boolean)map.get("ow");
                    commitWithin = (Integer)map.get("cw");
                }
                updateRequest.add((SolrInputDocument)entry.getKey(), commitWithin, overwrite);
            }
        }
        if (delById != null) {
            for (String string : delById) {
                updateRequest.deleteById(string);
            }
        }
        if (delByIdMap != null) {
            for (Map.Entry entry : delByIdMap.entrySet()) {
                updateRequest.deleteById((String)entry.getKey(), (Long)entry.getValue());
            }
        }
        if (delByQ != null) {
            for (String string : delByQ) {
                updateRequest.deleteByQuery(string);
            }
        }
        return updateRequest;
    }

    private SolrInputDocument listToSolrInputDocument(List<NamedList> namedList) {
        SolrInputDocument doc = new SolrInputDocument();
        for (int i = 0; i < namedList.size(); ++i) {
            NamedList nl = namedList.get(i);
            if (i == 0) {
                doc.setDocumentBoost(nl.getVal(0) == null ? 1.0f : ((Float)nl.getVal(0)).floatValue());
                continue;
            }
            doc.addField((String)nl.getVal(0), nl.getVal(1), nl.getVal(2) == null ? 1.0f : ((Float)nl.getVal(2)).floatValue());
        }
        return doc;
    }

    private NamedList solrParamsToNamedList(SolrParams params) {
        if (params == null) {
            return new NamedList();
        }
        return params.toNamedList();
    }

    public static interface StreamingUpdateHandler {
        public void update(SolrInputDocument var1, UpdateRequest var2);
    }
}

