/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.HashBasedRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;

public class CompositeIdRouter
extends HashBasedRouter {
    public static final String NAME = "compositeId";
    private int separator = 33;
    private int bitsSeparator = 47;
    private int bits = 16;
    private int mask1 = -65536;
    private int mask2 = 65535;

    protected void setBits(int firstBits) {
        this.bits = firstBits;
        this.mask1 = firstBits == 0 ? 0 : -1 << 32 - firstBits;
        this.mask2 = firstBits == 32 ? 0 : -1 >>> firstBits;
    }

    protected int getBits(String firstPart, int commaIdx) {
        int v = 0;
        for (int idx = commaIdx + 1; idx < firstPart.length(); ++idx) {
            char ch = firstPart.charAt(idx);
            if (ch < '0' || ch > '9') {
                return -1;
            }
            v = v * 10 + (ch - 48);
        }
        return v > 32 ? -1 : v;
    }

    @Override
    public int sliceHash(String id, SolrInputDocument doc, SolrParams params, DocCollection collection) {
        int firstBits;
        String shardFieldName = this.getRouteField(collection);
        String part1 = null;
        int idx = 0;
        int commaIdx = 0;
        if (shardFieldName == null || doc == null) {
            idx = id.indexOf(this.separator);
            if (idx < 0) {
                return Hash.murmurhash3_x86_32(id, 0, id.length(), 0);
            }
        } else {
            Object o = doc.getFieldValue(shardFieldName);
            if (o != null) {
                part1 = o.toString();
                return Hash.murmurhash3_x86_32(part1, 0, part1.length(), 0);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No value for :" + shardFieldName + ". Unable to identify shard");
        }
        part1 = id.substring(0, idx);
        commaIdx = part1.indexOf(this.bitsSeparator);
        int m1 = this.mask1;
        int m2 = this.mask2;
        if (commaIdx > 0 && (firstBits = this.getBits(part1, commaIdx)) >= 0) {
            m1 = firstBits == 0 ? 0 : -1 << 32 - firstBits;
            m2 = firstBits == 32 ? 0 : -1 >>> firstBits;
            part1 = part1.substring(0, commaIdx);
        }
        String part2 = id.substring(idx + 1);
        int hash1 = Hash.murmurhash3_x86_32(part1, 0, part1.length(), 0);
        int hash2 = Hash.murmurhash3_x86_32(part2, 0, part2.length(), 0);
        return hash1 & m1 | hash2 & m2;
    }

    @Override
    public Collection<Slice> getSearchSlicesSingle(String shardKey, SolrParams params, DocCollection collection) {
        int upperBits;
        int firstBits;
        if (shardKey == null) {
            return collection.getActiveSlices();
        }
        String id = shardKey;
        int idx = shardKey.indexOf(this.separator);
        if (idx < 0) {
            return Collections.singletonList(this.hashToSlice(Hash.murmurhash3_x86_32(id, 0, id.length(), 0), collection));
        }
        int m1 = this.mask1;
        int m2 = this.mask2;
        String part1 = id.substring(0, idx);
        int bitsSepIdx = part1.indexOf(this.bitsSeparator);
        if (bitsSepIdx > 0 && (firstBits = this.getBits(part1, bitsSepIdx)) >= 0) {
            m1 = firstBits == 0 ? 0 : -1 << 32 - firstBits;
            m2 = firstBits == 32 ? 0 : -1 >>> firstBits;
            part1 = part1.substring(0, bitsSepIdx);
        }
        int hash1 = Hash.murmurhash3_x86_32(part1, 0, part1.length(), 0);
        int lowerBound = upperBits = hash1 & m1;
        int upperBound = upperBits | m2;
        if (m1 == 0) {
            lowerBound = Integer.MIN_VALUE;
            upperBound = Integer.MAX_VALUE;
        }
        DocRouter.Range completeRange = new DocRouter.Range(lowerBound, upperBound);
        ArrayList<Slice> targetSlices = new ArrayList<Slice>(1);
        for (Slice slice : collection.getActiveSlices()) {
            DocRouter.Range range = slice.getRange();
            if (range == null || !range.overlaps(completeRange)) continue;
            targetSlices.add(slice);
        }
        return targetSlices;
    }

    @Override
    public List<DocRouter.Range> partitionRange(int partitions, DocRouter.Range range) {
        boolean round;
        long targetStart;
        long start;
        int min = range.min;
        int max = range.max;
        assert (max >= min);
        if (partitions == 0) {
            return Collections.EMPTY_LIST;
        }
        long rangeSize = (long)max - (long)min;
        long rangeStep = Math.max(1L, rangeSize / (long)partitions);
        ArrayList<DocRouter.Range> ranges = new ArrayList<DocRouter.Range>(partitions);
        long end = start = (long)min;
        long targetEnd = targetStart = (long)min;
        boolean bl = round = rangeStep >= (long)((1 << this.bits) * 16);
        while (end < (long)max) {
            end = targetEnd = targetStart + rangeStep;
            if (round && (end & (long)this.mask2) != (long)this.mask2) {
                int increment = 1 << this.bits;
                long roundDown = (end | (long)this.mask2) - (long)increment;
                long roundUp = (end | (long)this.mask2) + (long)increment;
                end = end - roundDown < roundUp - end && roundDown > start ? roundDown : roundUp;
            }
            if (ranges.size() == partitions - 1) {
                end = max;
            }
            ranges.add(new DocRouter.Range((int)start, (int)end));
            start = end + 1L;
            targetStart = targetEnd + 1L;
        }
        return ranges;
    }
}

