/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.collation.ICUCollationKeyAnalyzer;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;

public class ICUCollationField
extends FieldType {
    private Analyzer analyzer;

    protected void init(IndexSchema schema, Map<String, String> args) {
        this.properties |= 2;
        this.setup((ResourceLoader)schema.getResourceLoader(), args);
        super.init(schema, args);
    }

    private void setup(ResourceLoader loader, Map<String, String> args) {
        String custom = args.remove("custom");
        String localeID = args.remove("locale");
        String strength = args.remove("strength");
        String decomposition = args.remove("decomposition");
        String alternate = args.remove("alternate");
        String caseLevel = args.remove("caseLevel");
        String caseFirst = args.remove("caseFirst");
        String numeric = args.remove("numeric");
        String variableTop = args.remove("variableTop");
        if (custom == null && localeID == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Either custom or locale is required.");
        }
        if (custom != null && localeID != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot specify both locale and custom. To tailor rules for a built-in language, see the javadocs for RuleBasedCollator. Then save the entire customized ruleset to a file, and use with the custom parameter");
        }
        Collator collator = localeID != null ? this.createFromLocale(localeID) : this.createFromRules(custom, loader);
        if (strength != null) {
            if (strength.equalsIgnoreCase("primary")) {
                collator.setStrength(0);
            } else if (strength.equalsIgnoreCase("secondary")) {
                collator.setStrength(1);
            } else if (strength.equalsIgnoreCase("tertiary")) {
                collator.setStrength(2);
            } else if (strength.equalsIgnoreCase("quaternary")) {
                collator.setStrength(3);
            } else if (strength.equalsIgnoreCase("identical")) {
                collator.setStrength(15);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid strength: " + strength);
            }
        }
        if (decomposition != null) {
            if (decomposition.equalsIgnoreCase("no")) {
                collator.setDecomposition(16);
            } else if (decomposition.equalsIgnoreCase("canonical")) {
                collator.setDecomposition(17);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid decomposition: " + decomposition);
            }
        }
        RuleBasedCollator rbc = (RuleBasedCollator)collator;
        if (alternate != null) {
            if (alternate.equalsIgnoreCase("shifted")) {
                rbc.setAlternateHandlingShifted(true);
            } else if (alternate.equalsIgnoreCase("non-ignorable")) {
                rbc.setAlternateHandlingShifted(false);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid alternate: " + alternate);
            }
        }
        if (caseLevel != null) {
            rbc.setCaseLevel(Boolean.parseBoolean(caseLevel));
        }
        if (caseFirst != null) {
            if (caseFirst.equalsIgnoreCase("lower")) {
                rbc.setLowerCaseFirst(true);
            } else if (caseFirst.equalsIgnoreCase("upper")) {
                rbc.setUpperCaseFirst(true);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid caseFirst: " + caseFirst);
            }
        }
        if (numeric != null) {
            rbc.setNumericCollation(Boolean.parseBoolean(numeric));
        }
        if (variableTop != null) {
            rbc.setVariableTop(variableTop);
        }
        this.analyzer = new ICUCollationKeyAnalyzer(Version.LUCENE_40, collator);
    }

    private Collator createFromLocale(String localeID) {
        return Collator.getInstance((ULocale)new ULocale(localeID));
    }

    private Collator createFromRules(String fileName, ResourceLoader loader) {
        InputStream input = null;
        try {
            input = loader.openResource(fileName);
            String rules = IOUtils.toString((InputStream)input, (String)"UTF-8");
            RuleBasedCollator ruleBasedCollator = new RuleBasedCollator(rules);
            return ruleBasedCollator;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    public SortField getSortField(SchemaField field, boolean top) {
        return this.getStringSort(field, top);
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.analyzer;
    }

    private BytesRef analyzeRangePart(String field, String part) {
        TokenStream source;
        try {
            source = this.analyzer.tokenStream(field, part);
            source.reset();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize TokenStream to analyze range part: " + part, e);
        }
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)source.getAttribute(TermToBytesRefAttribute.class);
        BytesRef bytes = termAtt.getBytesRef();
        try {
            if (!source.incrementToken()) {
                throw new IllegalArgumentException("analyzer returned no terms for range part: " + part);
            }
            termAtt.fillBytesRef();
            assert (!source.incrementToken());
        }
        catch (IOException e) {
            throw new RuntimeException("error analyzing range part: " + part, e);
        }
        try {
            source.end();
            source.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to end & close TokenStream after analyzing range part: " + part, e);
        }
        return BytesRef.deepCopyOf((BytesRef)bytes);
    }

    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        String f = field.getName();
        BytesRef low = part1 == null ? null : this.analyzeRangePart(f, part1);
        BytesRef high = part2 == null ? null : this.analyzeRangePart(f, part2);
        return new TermRangeQuery(field.getName(), low, high, minInclusive, maxInclusive);
    }
}

