/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public final class QueryResultKey {
    final Query query;
    final Sort sort;
    final SortField[] sfields;
    final List<Query> filters;
    final int nc_flags;
    private final int hc;
    private static SortField[] defaultSort = new SortField[0];

    public QueryResultKey(Query query, List<Query> filters, Sort sort, int nc_flags) {
        this.query = query;
        this.sort = sort;
        this.filters = filters;
        this.nc_flags = nc_flags;
        int h = query.hashCode();
        if (filters != null) {
            for (Query filt : filters) {
                h += filt.hashCode();
            }
        }
        for (SortField sf : this.sfields = this.sort != null ? this.sort.getSort() : defaultSort) {
            h = h * 29 + sf.hashCode();
        }
        this.hc = h;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryResultKey)) {
            return false;
        }
        QueryResultKey other = (QueryResultKey)o;
        if (this.hc != other.hc) {
            return false;
        }
        if (this.sfields.length != other.sfields.length) {
            return false;
        }
        if (!this.query.equals((Object)other.query)) {
            return false;
        }
        if (!QueryResultKey.isEqual(this.filters, other.filters)) {
            return false;
        }
        for (int i = 0; i < this.sfields.length; ++i) {
            SortField sf1 = this.sfields[i];
            SortField sf2 = other.sfields[i];
            if (sf1.equals((Object)sf2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(List<Query> fqList1, List<Query> fqList2) {
        if (fqList1 == fqList2) {
            return true;
        }
        if (fqList1 == null || fqList2 == null) {
            return false;
        }
        int sz = fqList1.size();
        if (sz != fqList2.size()) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            if (fqList1.get(i).equals((Object)fqList2.get(i))) continue;
            return QueryResultKey.unorderedCompare(fqList1, fqList2, i);
        }
        return true;
    }

    private static boolean unorderedCompare(List<Query> fqList1, List<Query> fqList2, int start) {
        int sz = fqList1.size();
        block0: for (int i = start; i < sz; ++i) {
            Query q1 = fqList1.get(i);
            for (int j = start; j < sz; ++j) {
                if (q1.equals((Object)fqList2.get(j))) continue block0;
            }
            return false;
        }
        return true;
    }
}

