/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.VersionedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFloatSource
extends ValueSource {
    private SchemaField field;
    private final SchemaField keyField;
    private final float defVal;
    private final String dataDir;
    private static final Logger log = LoggerFactory.getLogger(FileFloatSource.class);
    static Cache floatCache = new Cache(){

        @Override
        protected Object createValue(IndexReader reader, Object key) {
            return FileFloatSource.getFloats(((Entry)key).ffs, reader);
        }
    };
    static Object onlyForTesting;

    public FileFloatSource(SchemaField field, SchemaField keyField, float defVal, String datadir) {
        this.field = field;
        this.keyField = keyField;
        this.defVal = defVal;
        this.dataDir = datadir;
    }

    public String description() {
        return "float(" + this.field + ')';
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final int off = readerContext.docBase;
        IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)readerContext);
        final float[] arr = this.getCachedFloats(topLevelContext.reader());
        return new FloatDocValues(this){

            public float floatVal(int doc) {
                return arr[doc + off];
            }

            public Object objectVal(int doc) {
                return Float.valueOf(this.floatVal(doc));
            }
        };
    }

    public boolean equals(Object o) {
        if (o.getClass() != FileFloatSource.class) {
            return false;
        }
        FileFloatSource other = (FileFloatSource)((Object)o);
        return this.field.getName().equals(other.field.getName()) && this.keyField.getName().equals(other.keyField.getName()) && this.defVal == other.defVal && this.dataDir.equals(other.dataDir);
    }

    public int hashCode() {
        return FileFloatSource.class.hashCode() + this.field.getName().hashCode();
    }

    public String toString() {
        return "FileFloatSource(field=" + this.field.getName() + ",keyField=" + this.keyField.getName() + ",defVal=" + this.defVal + ",dataDir=" + this.dataDir + ")";
    }

    public static void resetCache() {
        floatCache.resetCache();
    }

    public void refreshCache(IndexReader reader) {
        log.info("Refreshing FlaxFileFloatSource cache for field {}", (Object)this.field.getName());
        floatCache.refresh(reader, new Entry(this));
        log.info("FlaxFileFloatSource cache for field {} reloaded", (Object)this.field.getName());
    }

    private final float[] getCachedFloats(IndexReader reader) {
        return (float[])floatCache.get(reader, new Entry(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float[] getFloats(FileFloatSource ffs, IndexReader reader) {
        InputStream is;
        float[] vals = new float[reader.maxDoc()];
        if (ffs.defVal != 0.0f) {
            Arrays.fill(vals, ffs.defVal);
        }
        String fname = "external_" + ffs.field.getName();
        try {
            is = VersionedFile.getLatestFile(ffs.dataDir, fname);
        }
        catch (IOException e) {
            SolrCore.log.error("Error opening external value source file: " + e);
            return vals;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(is, IOUtils.CHARSET_UTF_8));
        String idName = ffs.keyField.getName();
        FieldType idType = ffs.keyField.getType();
        ArrayList<String> notFound = new ArrayList<String>();
        int notFoundCount = 0;
        int otherErrors = 0;
        int delimiter = 61;
        BytesRef internalKey = new BytesRef();
        try {
            String line;
            TermsEnum termsEnum = MultiFields.getTerms((IndexReader)reader, (String)idName).iterator(null);
            DocsEnum docsEnum = null;
            while ((line = r.readLine()) != null) {
                int doc;
                float fval;
                int delimIndex = line.lastIndexOf(delimiter);
                if (delimIndex < 0) continue;
                int endIndex = line.length();
                String key = line.substring(0, delimIndex);
                String val = line.substring(delimIndex + 1, endIndex);
                try {
                    idType.readableToIndexed(key, internalKey);
                    fval = Float.parseFloat(val);
                }
                catch (Exception e) {
                    if (++otherErrors > 10) continue;
                    SolrCore.log.error("Error loading external value source + fileName + " + e + (otherErrors < 10 ? "" : "\tSkipping future errors for this file."));
                    continue;
                }
                if (!termsEnum.seekExact(internalKey)) {
                    if (notFoundCount < 10) {
                        notFound.add(key);
                    }
                    ++notFoundCount;
                    continue;
                }
                docsEnum = termsEnum.docs(null, docsEnum, 0);
                while ((doc = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    vals[doc] = fval;
                }
            }
        }
        catch (IOException e) {
            SolrCore.log.error("Error loading external value source: " + e);
        }
        finally {
            try {
                r.close();
            }
            catch (Exception e) {}
        }
        SolrCore.log.info("Loaded external value source " + fname + (notFoundCount == 0 ? "" : " :" + notFoundCount + " missing keys " + notFound));
        return vals;
    }

    public static class ReloadCacheRequestHandler
    extends RequestHandlerBase {
        static final Logger log = LoggerFactory.getLogger(ReloadCacheRequestHandler.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
            FileFloatSource.resetCache();
            log.debug("readerCache has been reset.");
            UpdateRequestProcessor processor = req.getCore().getUpdateProcessingChain(null).createProcessor(req, rsp);
            try {
                RequestHandlerUtils.handleCommit(req, processor, req.getParams(), true);
            }
            finally {
                processor.finish();
            }
        }

        @Override
        public String getDescription() {
            return "Reload readerCache request handler";
        }

        @Override
        public String getSource() {
            return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_5/solr/core/src/java/org/apache/solr/search/function/FileFloatSource.java $";
        }
    }

    private static class Entry {
        final FileFloatSource ffs;

        public Entry(FileFloatSource ffs) {
            this.ffs = ffs;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            return this.ffs.equals((Object)other.ffs);
        }

        public int hashCode() {
            return this.ffs.hashCode();
        }
    }

    static final class CreationPlaceholder {
        Object value;

        CreationPlaceholder() {
        }
    }

    static abstract class Cache {
        private final Map readerCache = new WeakHashMap();

        Cache() {
        }

        protected abstract Object createValue(IndexReader var1, Object var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh(IndexReader reader, Object key) {
            Object refreshedValues = this.createValue(reader, key);
            Map map = this.readerCache;
            synchronized (map) {
                HashMap<Object, Object> innerCache = (HashMap<Object, Object>)this.readerCache.get(reader);
                if (innerCache == null) {
                    innerCache = new HashMap<Object, Object>();
                    this.readerCache.put(reader, innerCache);
                }
                innerCache.put(key, refreshedValues);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(IndexReader reader, Object key) {
            Object value;
            HashMap<Object, Object> innerCache;
            Object object = this.readerCache;
            synchronized (object) {
                innerCache = (HashMap<Object, Object>)this.readerCache.get(reader);
                if (innerCache == null) {
                    innerCache = new HashMap<Object, Object>();
                    this.readerCache.put(reader, innerCache);
                    value = null;
                } else {
                    value = innerCache.get(key);
                }
                if (value == null) {
                    value = new CreationPlaceholder();
                    innerCache.put(key, value);
                }
            }
            if (value instanceof CreationPlaceholder) {
                object = value;
                synchronized (object) {
                    CreationPlaceholder progress = (CreationPlaceholder)value;
                    if (progress.value == null) {
                        progress.value = this.createValue(reader, key);
                        Map map = this.readerCache;
                        synchronized (map) {
                            innerCache.put(key, progress.value);
                            onlyForTesting = progress.value;
                        }
                    }
                    return progress.value;
                }
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetCache() {
            Map map = this.readerCache;
            synchronized (map) {
                this.readerCache.clear();
            }
        }
    }
}

