/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import org.apache.lucene.util.OpenBitSet;

class BitSetSlice {
    private final OpenBitSet obs;
    private final int off;
    private final int len;

    BitSetSlice(OpenBitSet obs, int off, int len) {
        this.obs = obs;
        this.off = off;
        this.len = len;
    }

    public boolean get(int pos) {
        return this.obs.get(pos + this.off);
    }

    public int prevSetBit(int pos) {
        int result = this.obs.prevSetBit(pos + this.off) - this.off;
        return result < 0 ? -1 : result;
    }

    public int nextSetBit(int pos) {
        int result = this.obs.nextSetBit(pos + this.off) - this.off;
        return result < 0 || result >= this.len ? -1 : result;
    }
}

