/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.ResponseUtils;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.servlet.cache.HttpCacheHeaderUtil;
import org.apache.solr.servlet.cache.Method;
import org.apache.solr.util.FastWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrDispatchFilter
implements Filter {
    final Logger log;
    protected volatile CoreContainer cores;
    protected String pathPrefix = null;
    protected String abortErrorMessage = null;
    protected final Map<SolrConfig, SolrRequestParsers> parsers = new WeakHashMap<SolrConfig, SolrRequestParsers>();
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public SolrDispatchFilter() {
        try {
            this.log = LoggerFactory.getLogger(SolrDispatchFilter.class);
        }
        catch (NoClassDefFoundError e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find necessary SLF4j logging jars. If using Jetty, the SLF4j logging jars need to go in the jetty lib/ext directory. For other containers, the corresponding directory should be used. For more information, see: http://wiki.apache.org/solr/SolrLogging", (Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.log.info("SolrDispatchFilter.init()");
        try {
            this.pathPrefix = config.getInitParameter("path-prefix");
            this.cores = this.createCoreContainer();
            this.log.info("user.dir=" + System.getProperty("user.dir"));
        }
        catch (Throwable t) {
            this.log.error("Could not start Solr. Check solr/home property and the logs");
            SolrCore.log(t);
        }
        this.log.info("SolrDispatchFilter.init() done");
    }

    private ConfigSolr loadConfigSolr(SolrResourceLoader loader) {
        String solrxmlLocation = System.getProperty("solr.solrxml.location", "solrhome");
        if (solrxmlLocation == null || "solrhome".equalsIgnoreCase(solrxmlLocation)) {
            return ConfigSolr.fromSolrHome(loader, loader.getInstanceDir());
        }
        if ("zookeeper".equalsIgnoreCase(solrxmlLocation)) {
            String zkHost = System.getProperty("zkHost");
            this.log.info("Trying to read solr.xml from " + zkHost);
            if (StringUtils.isEmpty((String)zkHost)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load solr.xml from zookeeper: zkHost system property not set");
            }
            SolrZkClient zkClient = new SolrZkClient(zkHost, 30000);
            try {
                if (!zkClient.exists("/solr.xml", true).booleanValue()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load solr.xml from zookeeper: node not found");
                }
                byte[] data = zkClient.getData("/solr.xml", null, null, true);
                ConfigSolr configSolr = ConfigSolr.fromInputStream(loader, new ByteArrayInputStream(data));
                return configSolr;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load solr.xml from zookeeper", (Throwable)e);
            }
            finally {
                zkClient.close();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Bad solr.solrxml.location set: " + solrxmlLocation + " - should be 'solrhome' or 'zookeeper'");
    }

    protected CoreContainer createCoreContainer() {
        SolrResourceLoader loader = new SolrResourceLoader(SolrResourceLoader.locateSolrHome());
        ConfigSolr config = this.loadConfigSolr(loader);
        CoreContainer cores = new CoreContainer(loader, config);
        cores.load();
        return cores;
    }

    public CoreContainer getCores() {
        return this.cores;
    }

    public void destroy() {
        if (this.cores != null) {
            this.cores.shutdown();
            this.cores = null;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter(request, response, chain, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain, boolean retry) throws IOException, ServletException {
        block61: {
            block59: {
                block55: {
                    block58: {
                        block56: {
                            block57: {
                                block51: {
                                    block54: {
                                        block52: {
                                            block53: {
                                                block49: {
                                                    block50: {
                                                        block47: {
                                                            block48: {
                                                                block45: {
                                                                    block46: {
                                                                        if (this.abortErrorMessage != null) {
                                                                            ((HttpServletResponse)response).sendError(500, this.abortErrorMessage);
                                                                            return;
                                                                        }
                                                                        if (this.cores == null) {
                                                                            ((HttpServletResponse)response).sendError(503, "Server is shutting down or failed to initialize");
                                                                            return;
                                                                        }
                                                                        cores = this.cores;
                                                                        core = null;
                                                                        solrReq = null;
                                                                        aliases = null;
                                                                        if (!(request instanceof HttpServletRequest)) break block61;
                                                                        req = (HttpServletRequest)request;
                                                                        resp = (HttpServletResponse)response;
                                                                        handler /* !! */  = null;
                                                                        corename = "";
                                                                        origCorename = null;
                                                                        req.setAttribute("org.apache.solr.CoreContainer", (Object)cores);
                                                                        path = req.getServletPath();
                                                                        if (req.getPathInfo() != null) {
                                                                            path = path + req.getPathInfo();
                                                                        }
                                                                        if (this.pathPrefix != null && path.startsWith(this.pathPrefix)) {
                                                                            path = path.substring(this.pathPrefix.length());
                                                                        }
                                                                        if ((alternate = cores.getManagementPath()) != null && path.startsWith(alternate)) {
                                                                            path = path.substring(0, alternate.length());
                                                                        }
                                                                        if ((idx = path.indexOf(58)) > 0) {
                                                                            path = path.substring(0, idx);
                                                                        }
                                                                        if (!path.equals(cores.getAdminPath())) break block45;
                                                                        handler /* !! */  = cores.getMultiCoreHandler();
                                                                        solrReq = SolrRequestParsers.DEFAULT.parse(null, path, req);
                                                                        this.handleAdminRequest(req, response, handler /* !! */ , solrReq);
                                                                        if (solrReq == null) break block46;
                                                                        this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                                                                        solrReq.close();
                                                                    }
                                                                    if (core != null) {
                                                                        core.close();
                                                                    }
                                                                    SolrRequestInfo.clearRequestInfo();
                                                                    return;
                                                                }
                                                                usingAliases = false;
                                                                collectionsList = null;
                                                                if (!path.equals("/admin/collections")) break block47;
                                                                handler /* !! */  = cores.getCollectionsHandler();
                                                                solrReq = SolrRequestParsers.DEFAULT.parse(null, path, req);
                                                                this.handleAdminRequest(req, response, handler /* !! */ , solrReq);
                                                                if (solrReq == null) break block48;
                                                                this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                                                                solrReq.close();
                                                            }
                                                            if (core != null) {
                                                                core.close();
                                                            }
                                                            SolrRequestInfo.clearRequestInfo();
                                                            return;
                                                        }
                                                        if (!path.startsWith("/admin/info")) break block49;
                                                        handler /* !! */  = cores.getInfoHandler();
                                                        solrReq = SolrRequestParsers.DEFAULT.parse(null, path, req);
                                                        this.handleAdminRequest(req, response, handler /* !! */ , solrReq);
                                                        if (solrReq == null) break block50;
                                                        this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                                                        solrReq.close();
                                                    }
                                                    if (core != null) {
                                                        core.close();
                                                    }
                                                    SolrRequestInfo.clearRequestInfo();
                                                    return;
                                                }
                                                idx = path.indexOf("/", 1);
                                                if (idx > 1) {
                                                    corename = path.substring(1, idx);
                                                    if (cores.isZooKeeperAware()) {
                                                        origCorename = corename;
                                                        reader = cores.getZkController().getZkStateReader();
                                                        aliases = reader.getAliases();
                                                        if (aliases != null && aliases.collectionAliasSize() > 0) {
                                                            usingAliases = true;
                                                            alias = aliases.getCollectionAlias(corename);
                                                            if (alias != null) {
                                                                collectionsList = StrUtils.splitSmart((String)alias, (String)",", (boolean)true);
                                                                corename = (String)collectionsList.get(0);
                                                            }
                                                        }
                                                    }
                                                    if ((core = cores.getCore(corename)) != null) {
                                                        path = path.substring(idx);
                                                    }
                                                }
                                                if (core == null && !cores.isZooKeeperAware()) {
                                                    core = cores.getCore("");
                                                }
                                                if (core != null || !cores.isZooKeeperAware()) ** GOTO lbl124
                                                core = this.getCoreByCollection(cores, corename, path);
                                                if (core != null) {
                                                    path = path.substring(idx);
                                                }
                                                if (core != null || idx <= 0) break block51;
                                                coreUrl = this.getRemotCoreUrl(cores, corename, origCorename);
                                                if (coreUrl == null) break block52;
                                                path = path.substring(idx);
                                                this.remoteQuery(coreUrl + path, req, solrReq, resp);
                                                if (solrReq == null) break block53;
                                                this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                                                solrReq.close();
                                            }
                                            if (core != null) {
                                                core.close();
                                            }
                                            SolrRequestInfo.clearRequestInfo();
                                            return;
                                        }
                                        if (retry) break block51;
                                        reader = cores.getZkController().getZkStateReader();
                                        reader.updateAliases();
                                        this.doFilter(request, response, chain, true);
                                        if (solrReq == null) break block54;
                                        this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                                        solrReq.close();
                                    }
                                    if (core != null) {
                                        core.close();
                                    }
                                    SolrRequestInfo.clearRequestInfo();
                                    return;
                                }
                                if (core == null) {
                                    core = cores.getCore("");
                                }
lbl124:
                                // 4 sources

                                if (core == null) break block55;
                                config = core.getSolrConfig();
                                parser = null;
                                parser = this.parsers.get(config);
                                if (parser == null) {
                                    parser = new SolrRequestParsers(config);
                                    this.parsers.put(config, parser);
                                }
                                if (!path.startsWith("/schema")) break block56;
                                solrReq = parser.parse(core, path, req);
                                SolrRequestInfo.setRequestInfo(new SolrRequestInfo(solrReq, new SolrQueryResponse()));
                                if (path.equals(req.getServletPath())) {
                                    chain.doFilter(request, response);
                                } else {
                                    req.getRequestDispatcher(path).forward(request, response);
                                }
                                if (solrReq == null) break block57;
                                this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                                solrReq.close();
                            }
                            if (core != null) {
                                core.close();
                            }
                            SolrRequestInfo.clearRequestInfo();
                            return;
                        }
                        if (handler /* !! */  == null && path.length() > 1 && (handler /* !! */  = core.getRequestHandler(path)) == null && parser.isHandleSelect() && ("/select".equals(path) || "/select/".equals(path))) {
                            solrReq = parser.parse(core, path, req);
                            qt = solrReq.getParams().get("qt");
                            handler /* !! */  = core.getRequestHandler(qt);
                            if (handler /* !! */  == null) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
                            }
                            if (qt != null && qt.startsWith("/") && handler /* !! */  instanceof ContentStreamHandlerBase) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Request Handler ('qt').  Do not use /select to access: " + qt);
                            }
                        }
                        if (handler /* !! */  == null) break block55;
                        if (solrReq == null) {
                            solrReq = parser.parse(core, path, req);
                        }
                        if (usingAliases) {
                            this.processAliases(solrReq, aliases, collectionsList);
                        }
                        reqMethod = Method.getMethod(req.getMethod());
                        HttpCacheHeaderUtil.setCacheControlHeader(config, resp, reqMethod);
                        if (config.getHttpCachingConfig().isNever304() || !HttpCacheHeaderUtil.doCacheHeaderValidation(solrReq, req, reqMethod, resp)) {
                            solrRsp = new SolrQueryResponse();
                            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(solrReq, solrRsp));
                            this.execute(req, handler /* !! */ , solrReq, solrRsp);
                            HttpCacheHeaderUtil.checkHttpCachingVeto(solrRsp, resp, reqMethod);
                            responseWriter = core.getQueryResponseWriter(solrReq);
                            this.writeResponse(solrRsp, response, responseWriter, solrReq, reqMethod);
                        }
                        if (solrReq == null) break block58;
                        this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                        solrReq.close();
                    }
                    if (core != null) {
                        core.close();
                    }
                    SolrRequestInfo.clearRequestInfo();
                    return;
                }
                try {
                    this.log.debug("no handler or core retrieved for " + path + ", follow through...");
                    if (solrReq == null) break block59;
                }
                catch (Throwable ex) {
                    block60: {
                        try {
                            this.sendError(core, solrReq, request, (HttpServletResponse)response, ex);
                            if (solrReq == null) break block60;
                        }
                        catch (Throwable var24_25) {
                            if (solrReq != null) {
                                this.log.debug("Closing out SolrRequest: {}", solrReq);
                                solrReq.close();
                            }
                            if (core != null) {
                                core.close();
                            }
                            SolrRequestInfo.clearRequestInfo();
                            throw var24_25;
                        }
                        this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                        solrReq.close();
                    }
                    if (core != null) {
                        core.close();
                    }
                    SolrRequestInfo.clearRequestInfo();
                    return;
                }
                this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                solrReq.close();
            }
            if (core != null) {
                core.close();
            }
            SolrRequestInfo.clearRequestInfo();
        }
        chain.doFilter(request, response);
    }

    private void processAliases(SolrQueryRequest solrReq, Aliases aliases, List<String> collectionsList) {
        String collection = solrReq.getParams().get("collection");
        if (collection != null) {
            collectionsList = StrUtils.splitSmart((String)collection, (String)",", (boolean)true);
        }
        if (collectionsList != null) {
            HashSet<String> newCollectionsList = new HashSet<String>(collectionsList.size());
            for (String col : collectionsList) {
                String al = aliases.getCollectionAlias(col);
                if (al != null) {
                    List aliasList = StrUtils.splitSmart((String)al, (String)",", (boolean)true);
                    newCollectionsList.addAll(aliasList);
                    continue;
                }
                newCollectionsList.add(col);
            }
            if (newCollectionsList.size() > 0) {
                StringBuilder collectionString = new StringBuilder();
                Iterator it = newCollectionsList.iterator();
                int sz = newCollectionsList.size();
                for (int i = 0; i < sz; ++i) {
                    collectionString.append((String)it.next());
                    if (i >= newCollectionsList.size() - 1) continue;
                    collectionString.append(",");
                }
                ModifiableSolrParams params = new ModifiableSolrParams(solrReq.getParams());
                params.set("collection", new String[]{collectionString.toString()});
                solrReq.setParams((SolrParams)params);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteQuery(String coreUrl, HttpServletRequest req, SolrQueryRequest solrReq, HttpServletResponse resp) throws IOException {
        try {
            String urlstr = coreUrl;
            String queryString = req.getQueryString();
            urlstr = urlstr + (queryString == null ? "" : "?" + queryString);
            URL url = new URL(urlstr);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod(req.getMethod());
            con.setUseCaches(false);
            con.setDoOutput(true);
            con.setDoInput(true);
            Enumeration e = req.getHeaderNames();
            while (e.hasMoreElements()) {
                String headerName = e.nextElement().toString();
                con.setRequestProperty(headerName, req.getHeader(headerName));
            }
            try {
                OutputStream os;
                Object is;
                con.connect();
                if ("POST".equals(req.getMethod())) {
                    is = req.getInputStream();
                    os = con.getOutputStream();
                    try {
                        IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                        os.flush();
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)os);
                        IOUtils.closeQuietly((InputStream)is);
                    }
                }
                resp.setStatus(con.getResponseCode());
                for (Map.Entry<String, List<String>> mapEntry : con.getHeaderFields().entrySet()) {
                    if (mapEntry.getKey() == null) continue;
                    resp.setHeader(mapEntry.getKey().toString(), mapEntry.getValue().get(0).toString());
                }
                resp.setCharacterEncoding(con.getContentEncoding());
                resp.setContentType(con.getContentType());
                is = con.getInputStream();
                os = resp.getOutputStream();
                try {
                    IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                    os.flush();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)os);
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            finally {
                con.disconnect();
            }
        }
        catch (IOException e) {
            this.sendError(null, solrReq, (ServletRequest)req, resp, new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error trying to proxy request for url: " + coreUrl, (Throwable)e));
        }
    }

    private String getRemotCoreUrl(CoreContainer cores, String collectionName, String origCorename) {
        ClusterState clusterState = cores.getZkController().getClusterState();
        ArrayList slices = clusterState.getActiveSlices(collectionName);
        boolean byCoreName = false;
        if (slices == null) {
            byCoreName = true;
            Set collections = clusterState.getCollections();
            for (String collection : collections) {
                slices = new ArrayList();
                slices.addAll(clusterState.getActiveSlices(collection));
            }
        }
        if (slices == null || slices.size() == 0) {
            return null;
        }
        Set liveNodes = clusterState.getLiveNodes();
        for (Slice slice : slices) {
            Map sliceShards = slice.getReplicasMap();
            for (Replica nodeProps : sliceShards.values()) {
                String coreUrl;
                ZkCoreNodeProps coreNodeProps = new ZkCoreNodeProps((ZkNodeProps)nodeProps);
                if (!liveNodes.contains(coreNodeProps.getNodeName()) || !coreNodeProps.getState().equals("active") || byCoreName && !collectionName.equals(coreNodeProps.getCoreName()) || coreNodeProps.getBaseUrl().equals(cores.getZkController().getBaseUrl())) continue;
                if (origCorename != null) {
                    coreUrl = coreNodeProps.getBaseUrl() + "/" + origCorename;
                } else {
                    coreUrl = coreNodeProps.getCoreUrl();
                    if (coreUrl.endsWith("/")) {
                        coreUrl = coreUrl.substring(0, coreUrl.length() - 1);
                    }
                }
                return coreUrl;
            }
        }
        return null;
    }

    private SolrCore getCoreByCollection(CoreContainer cores, String corename, String path) {
        String collection = corename;
        ZkStateReader zkStateReader = cores.getZkController().getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        Map slices = clusterState.getActiveSlicesMap(collection);
        if (slices == null) {
            return null;
        }
        Set entries = slices.entrySet();
        SolrCore core = null;
        block0: for (Map.Entry entry : entries) {
            Replica leaderProps = clusterState.getLeader(collection, (String)entry.getKey());
            if (leaderProps != null) {
                core = this.checkProps(cores, path, (ZkNodeProps)leaderProps);
            }
            if (core != null) break;
            Map shards = ((Slice)entry.getValue()).getReplicasMap();
            Set shardEntries = shards.entrySet();
            for (Map.Entry shardEntry : shardEntries) {
                Replica zkProps = (Replica)shardEntry.getValue();
                core = this.checkProps(cores, path, (ZkNodeProps)zkProps);
                if (core == null) continue;
                break block0;
            }
        }
        return core;
    }

    private SolrCore checkProps(CoreContainer cores, String path, ZkNodeProps zkProps) {
        SolrCore core = null;
        if (cores.getZkController().getNodeName().equals(zkProps.getStr("node_name"))) {
            String corename = zkProps.getStr("core");
            core = cores.getCore(corename);
        }
        return core;
    }

    private void handleAdminRequest(HttpServletRequest req, ServletResponse response, SolrRequestHandler handler, SolrQueryRequest solrReq) throws IOException {
        QueryResponseWriter respWriter;
        SolrQueryResponse solrResp = new SolrQueryResponse();
        SolrCore.preDecorateResponse(solrReq, solrResp);
        handler.handleRequest(solrReq, solrResp);
        SolrCore.postDecorateResponse(handler, solrReq, solrResp);
        if (this.log.isInfoEnabled() && solrResp.getToLog().size() > 0) {
            this.log.info(solrResp.getToLogAsString("[admin] "));
        }
        if ((respWriter = SolrCore.DEFAULT_RESPONSE_WRITERS.get(solrReq.getParams().get("wt"))) == null) {
            respWriter = SolrCore.DEFAULT_RESPONSE_WRITERS.get("standard");
        }
        this.writeResponse(solrResp, response, respWriter, solrReq, Method.getMethod(req.getMethod()));
    }

    private void writeResponse(SolrQueryResponse solrRsp, ServletResponse response, QueryResponseWriter responseWriter, SolrQueryRequest solrReq, Method reqMethod) throws IOException {
        String ct = responseWriter.getContentType(solrReq, solrRsp);
        if (null != ct) {
            response.setContentType(ct);
        }
        if (solrRsp.getException() != null) {
            SimpleOrderedMap info = new SimpleOrderedMap();
            int code = ResponseUtils.getErrorInfo(solrRsp.getException(), (NamedList)info, this.log);
            solrRsp.add("error", info);
            ((HttpServletResponse)response).setStatus(code);
        }
        if (Method.HEAD != reqMethod) {
            if (responseWriter instanceof BinaryQueryResponseWriter) {
                BinaryQueryResponseWriter binWriter = (BinaryQueryResponseWriter)responseWriter;
                binWriter.write((OutputStream)response.getOutputStream(), solrReq, solrRsp);
            } else {
                String charset = ContentStreamBase.getCharsetFromContentType((String)ct);
                Writer out = charset == null || charset.equalsIgnoreCase("UTF-8") ? new OutputStreamWriter((OutputStream)response.getOutputStream(), UTF8) : new OutputStreamWriter((OutputStream)response.getOutputStream(), charset);
                out = new FastWriter(out);
                responseWriter.write(out, solrReq, solrRsp);
                out.flush();
            }
        }
    }

    protected void execute(HttpServletRequest req, SolrRequestHandler handler, SolrQueryRequest sreq, SolrQueryResponse rsp) {
        sreq.getContext().put("webapp", req.getContextPath());
        sreq.getCore().execute(handler, sreq, rsp);
    }

    protected void sendError(SolrCore core, SolrQueryRequest req, ServletRequest request, HttpServletResponse response, Throwable ex) throws IOException {
        try {
            SolrQueryResponse solrResp = new SolrQueryResponse();
            if (ex instanceof Exception) {
                solrResp.setException((Exception)ex);
            } else {
                solrResp.setException(new RuntimeException(ex));
            }
            if (core == null) {
                core = this.cores.getCore("");
            }
            if (req == null) {
                Object solrParams = request instanceof HttpServletRequest ? SolrRequestParsers.parseQueryString(((HttpServletRequest)request).getQueryString()) : new MapSolrParams(Collections.emptyMap());
                req = new SolrQueryRequestBase(core, (SolrParams)solrParams){};
            }
            QueryResponseWriter writer = core.getQueryResponseWriter(req);
            this.writeResponse(solrResp, (ServletResponse)response, writer, req, Method.GET);
        }
        catch (Throwable t) {
            SimpleOrderedMap info = new SimpleOrderedMap();
            int code = ResponseUtils.getErrorInfo(ex, (NamedList)info, this.log);
            response.sendError(code, info.toString());
        }
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }
}

