/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest.fst;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.FuzzySuggester;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.spelling.suggest.LookupFactory;

public class FuzzyLookupFactory
extends LookupFactory {
    public static final String UNICODE_AWARE = "unicodeAware";
    public static final String MAX_EDITS = "maxEdits";
    public static final String TRANSPOSITIONS = "transpositions";
    public static final String NON_FUZZY_PREFIX = "nonFuzzyPrefix";
    public static final String MIN_FUZZY_LENGTH = "minFuzzyLength";
    private static final String FILENAME = "fwfsta.bin";

    @Override
    public Lookup create(NamedList params, SolrCore core) {
        Object fieldTypeName = params.get("suggestAnalyzerFieldType");
        if (fieldTypeName == null) {
            throw new IllegalArgumentException("Error in configuration: suggestAnalyzerFieldType parameter is mandatory");
        }
        FieldType ft = core.getLatestSchema().getFieldTypeByName(fieldTypeName.toString());
        Analyzer indexAnalyzer = ft.getAnalyzer();
        Analyzer queryAnalyzer = ft.getQueryAnalyzer();
        boolean exactMatchFirst = params.get("exactMatchFirst") != null ? Boolean.valueOf(params.get("exactMatchFirst").toString()) : true;
        boolean preserveSep = params.get("preserveSep") != null ? Boolean.valueOf(params.get("preserveSep").toString()) : true;
        int options = 0;
        if (exactMatchFirst) {
            options |= 1;
        }
        if (preserveSep) {
            options |= 2;
        }
        int maxSurfaceFormsPerAnalyzedForm = params.get("maxSurfaceFormsPerAnalyzedForm") != null ? Integer.parseInt(params.get("maxSurfaceFormsPerAnalyzedForm").toString()) : 256;
        int maxGraphExpansions = params.get("maxGraphExpansions") != null ? Integer.parseInt(params.get("maxGraphExpansions").toString()) : -1;
        int maxEdits = params.get(MAX_EDITS) != null ? Integer.parseInt(params.get(MAX_EDITS).toString()) : 1;
        boolean transpositions = params.get(TRANSPOSITIONS) != null ? Boolean.parseBoolean(params.get(TRANSPOSITIONS).toString()) : true;
        int nonFuzzyPrefix = params.get(NON_FUZZY_PREFIX) != null ? Integer.parseInt(params.get(NON_FUZZY_PREFIX).toString()) : 1;
        int minFuzzyLength = params.get(MIN_FUZZY_LENGTH) != null ? Integer.parseInt(params.get(MIN_FUZZY_LENGTH).toString()) : 3;
        boolean unicodeAware = params.get(UNICODE_AWARE) != null ? Boolean.valueOf(params.get(UNICODE_AWARE).toString()) : false;
        return new FuzzySuggester(indexAnalyzer, queryAnalyzer, options, maxSurfaceFormsPerAnalyzedForm, maxGraphExpansions, maxEdits, transpositions, nonFuzzyPrefix, minFuzzyLength, unicodeAware);
    }

    @Override
    public String storeFileName() {
        return FILENAME;
    }
}

