/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.lucene.store.DataOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsFileWriter
extends DataOutput
implements Closeable {
    public static Logger LOG = LoggerFactory.getLogger(HdfsFileWriter.class);
    public static final String HDFS_SYNC_BLOCK = "solr.hdfs.sync.block";
    private final Path path;
    private FSDataOutputStream outputStream;
    private long currentPosition;

    public HdfsFileWriter(FileSystem fileSystem, Path path) throws IOException {
        LOG.debug("Creating writer on {}", (Object)path);
        this.path = path;
        Configuration conf = fileSystem.getConf();
        FsServerDefaults fsDefaults = fileSystem.getServerDefaults(path);
        EnumSet<CreateFlag> flags = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
        if (Boolean.getBoolean(HDFS_SYNC_BLOCK)) {
            flags.add(CreateFlag.SYNC_BLOCK);
        }
        this.outputStream = fileSystem.create(path, FsPermission.getDefault().applyUMask(FsPermission.getUMask((Configuration)conf)), flags, fsDefaults.getFileBufferSize(), fsDefaults.getReplication(), fsDefaults.getBlockSize(), null);
    }

    public long length() {
        return this.currentPosition;
    }

    public void seek(long pos) throws IOException {
        LOG.error("Invalid seek called on {}", (Object)this.path);
        throw new IOException("Seek not supported");
    }

    public void flush() throws IOException {
        this.outputStream.flush();
        LOG.debug("Flushed file {}", (Object)this.path);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
        LOG.debug("Closed writer on {}", (Object)this.path);
    }

    public void writeByte(byte b) throws IOException {
        this.outputStream.write(b & 0xFF);
        ++this.currentPosition;
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.outputStream.write(b, offset, length);
        this.currentPosition += (long)length;
    }

    public long getPosition() {
        return this.currentPosition;
    }
}

