/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.update.HdfsTransactionLog;
import org.apache.solr.update.TransactionLog;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.util.HdfsUtil;
import org.apache.solr.util.IOUtils;
import org.slf4j.Logger;

public class HdfsUpdateLog
extends UpdateLog {
    private volatile FileSystem fs;
    private volatile Path tlogDir;
    private final String confDir;

    public HdfsUpdateLog() {
        this.confDir = null;
    }

    public HdfsUpdateLog(String confDir) {
        this.confDir = confDir;
    }

    @Override
    public boolean dropBufferedUpdates() {
        Future<UpdateLog.RecoveryInfo> future = this.applyBufferedUpdates();
        if (future != null) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    @Override
    public void init(PluginInfo info) {
        this.dataDir = (String)info.initArgs.get("dir");
        this.defaultSyncLevel = UpdateLog.SyncLevel.getSyncLevel((String)info.initArgs.get("syncLevel"));
    }

    private Configuration getConf() {
        Configuration conf = new Configuration();
        if (this.confDir != null) {
            HdfsUtil.addHdfsResources(conf, this.confDir);
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(UpdateHandler uhandler, SolrCore core) {
        String ulogDir = core.getCoreDescriptor().getUlogDir();
        if (ulogDir != null) {
            this.dataDir = ulogDir;
        }
        if (this.dataDir == null || this.dataDir.length() == 0) {
            this.dataDir = core.getDataDir();
        }
        if (!core.getDirectoryFactory().isAbsolute(this.dataDir)) {
            try {
                this.dataDir = core.getDirectoryFactory().getDataHome(core.getCoreDescriptor());
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        try {
            if (this.fs != null) {
                this.fs.close();
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        try {
            this.fs = FileSystem.newInstance((URI)new Path(this.dataDir).toUri(), (Configuration)this.getConf());
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        this.uhandler = uhandler;
        if (this.dataDir.equals(this.lastDataDir)) {
            if (this.debug) {
                log.debug("UpdateHandler init: tlogDir=" + this.tlogDir + ", next id=" + this.id, (Object)" this is a reopen... nothing else to do.");
            }
            this.versionInfo.reload();
            return;
        }
        this.lastDataDir = this.dataDir;
        this.tlogDir = new Path(this.dataDir, TLOG_NAME);
        try {
            boolean success;
            if (!this.fs.exists(this.tlogDir) && !(success = this.fs.mkdirs(this.tlogDir))) {
                throw new RuntimeException("Could not create directory:" + this.tlogDir);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.tlogFiles = HdfsUpdateLog.getLogList(this.fs, this.tlogDir);
        this.id = this.getLastLogId() + 1L;
        if (this.debug) {
            log.debug("UpdateHandler init: tlogDir=" + this.tlogDir + ", existing tlogs=" + Arrays.asList(this.tlogFiles) + ", next id=" + this.id);
        }
        HdfsTransactionLog oldLog = null;
        for (String oldLogName : this.tlogFiles) {
            Path f = new Path(this.tlogDir, oldLogName);
            try {
                oldLog = new HdfsTransactionLog(this.fs, f, null, true);
                this.addOldLog(oldLog, false);
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)("Failure to open existing log file (non fatal) " + f), (Throwable)e);
                try {
                    this.fs.delete(f, false);
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        for (TransactionLog ll : this.logs) {
            this.newestLogsOnStartup.addFirst(ll);
            if (this.newestLogsOnStartup.size() < 2) continue;
            break;
        }
        try {
            this.versionInfo = new VersionInfo(this, 256);
        }
        catch (SolrException e) {
            log.error("Unable to use updateLog: " + e.getMessage(), (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to use updateLog: " + e.getMessage(), (Throwable)e);
        }
        UpdateLog.RecentUpdates startingUpdates = this.getRecentUpdates();
        try {
            int i;
            this.startingVersions = startingUpdates.getVersions(100);
            this.startingOperation = startingUpdates.getLatestOperation();
            for (i = startingUpdates.deleteList.size() - 1; i >= 0; --i) {
                UpdateLog.DeleteUpdate du = startingUpdates.deleteList.get(i);
                this.oldDeletes.put(new BytesRef(du.id), new UpdateLog.LogPtr(-1L, du.version));
            }
            for (i = startingUpdates.deleteByQueryList.size() - 1; i >= 0; --i) {
                UpdateLog.Update update = startingUpdates.deleteByQueryList.get(i);
                List dbq = (List)update.log.lookup(update.pointer);
                long version = (Long)dbq.get(1);
                String q = (String)dbq.get(2);
                this.trackDeleteByQuery(q, version);
            }
        }
        finally {
            startingUpdates.close();
        }
    }

    @Override
    public String getLogDir() {
        return this.tlogDir.toUri().toString();
    }

    public static String[] getLogList(FileSystem fs, Path tlogDir) {
        FileStatus[] fileStatuses;
        final String prefix = TLOG_NAME + '.';
        assert (fs != null);
        try {
            fileStatuses = fs.listStatus(tlogDir, new PathFilter(){

                public boolean accept(Path path) {
                    return path.getName().startsWith(prefix);
                }
            });
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Object[] names = new String[fileStatuses.length];
        for (int i = 0; i < fileStatuses.length; ++i) {
            names[i] = fileStatuses[i].getPath().getName();
        }
        Arrays.sort(names);
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean committed) {
        HdfsUpdateLog hdfsUpdateLog = this;
        synchronized (hdfsUpdateLog) {
            super.close(committed);
            IOUtils.closeQuietly((Closeable)this.fs);
        }
    }

    @Override
    protected void ensureLog() {
        if (this.tlog == null) {
            String newLogName = String.format(Locale.ROOT, LOG_FILENAME_PATTERN, TLOG_NAME, this.id);
            this.tlog = new HdfsTransactionLog(this.fs, new Path(this.tlogDir, newLogName), this.globalStrings);
        }
    }

    @Override
    public void clearLog(SolrCore core, PluginInfo ulogPluginInfo) {
        if (ulogPluginInfo == null) {
            return;
        }
        Path tlogDir = new Path(this.getTlogDir(core, ulogPluginInfo));
        try {
            if (this.fs.exists(tlogDir)) {
                String[] files;
                for (String file : files = this.getLogList(tlogDir)) {
                    Path f = new Path(tlogDir, file);
                    boolean s = this.fs.delete(f, false);
                    if (s) continue;
                    log.error("Could not remove tlog file:" + f);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String[] getLogList(Path tlogDir) throws FileNotFoundException, IOException {
        final String prefix = TLOG_NAME + '.';
        FileStatus[] files = this.fs.listStatus(tlogDir, new PathFilter(){

            public boolean accept(Path name) {
                return name.getName().startsWith(prefix);
            }
        });
        ArrayList<String> fileList = new ArrayList<String>(files.length);
        for (FileStatus file : files) {
            fileList.add(file.getPath().getName());
        }
        return fileList.toArray(new String[0]);
    }

    @Override
    public String toString() {
        return "HDFSUpdateLog{state=" + (Object)((Object)this.getState()) + ", tlog=" + this.tlog + "}";
    }
}

