/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Collections2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.EmptyImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Hashing;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableEnumSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ObjectArrays;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Sets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.SingletonImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class ImmutableSet
extends ImmutableCollection
implements Set {
    private static final int CUTOFF = (int)Math.floor(7.516192768E8);

    public static ImmutableSet of() {
        return EmptyImmutableSet.INSTANCE;
    }

    public static ImmutableSet of(Object object) {
        return new SingletonImmutableSet(object);
    }

    private static ImmutableSet construct(int n, Object ... objectArray) {
        switch (n) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object object = objectArray[0];
                return ImmutableSet.of(object);
            }
        }
        int n2 = ImmutableSet.chooseTableSize(n);
        Object[] objectArray2 = new Object[n2];
        int n3 = n2 - 1;
        int n4 = 0;
        int n5 = 0;
        block4: for (int i = 0; i < n; ++i) {
            Object object = ObjectArrays.checkElementNotNull(objectArray[i], i);
            int n6 = object.hashCode();
            int n7 = Hashing.smear(n6);
            while (true) {
                int n8;
                Object object2;
                if ((object2 = objectArray2[n8 = n7 & n3]) == null) {
                    objectArray[n5++] = object;
                    objectArray2[n8] = object;
                    n4 += n6;
                    continue block4;
                }
                if (object2.equals(object)) continue block4;
                ++n7;
            }
        }
        Arrays.fill(objectArray, n5, n, null);
        if (n5 == 1) {
            Object object = objectArray[0];
            return new SingletonImmutableSet(object, n4);
        }
        if (n2 != ImmutableSet.chooseTableSize(n5)) {
            return ImmutableSet.construct(n5, objectArray);
        }
        Object[] objectArray3 = n5 < objectArray.length ? ObjectArrays.arraysCopyOf(objectArray, n5) : objectArray;
        return new RegularImmutableSet(objectArray3, n4, objectArray2, n3);
    }

    static int chooseTableSize(int n) {
        if (n < CUTOFF) {
            int n2 = Integer.highestOneBit(n - 1) << 1;
            while ((double)n2 * 0.7 < (double)n) {
                n2 <<= 1;
            }
            return n2;
        }
        Preconditions.checkArgument(n < 0x40000000, "collection too large");
        return 0x40000000;
    }

    public static ImmutableSet copyOf(Object[] objectArray) {
        switch (objectArray.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(objectArray[0]);
            }
        }
        return ImmutableSet.construct(objectArray.length, (Object[])objectArray.clone());
    }

    public static ImmutableSet copyOf(Iterable iterable) {
        return iterable instanceof Collection ? ImmutableSet.copyOf(Collections2.cast(iterable)) : ImmutableSet.copyOf(iterable.iterator());
    }

    public static ImmutableSet copyOf(Iterator iterator) {
        if (!iterator.hasNext()) {
            return ImmutableSet.of();
        }
        Object e = iterator.next();
        if (!iterator.hasNext()) {
            return ImmutableSet.of(e);
        }
        return new ImmutableSet$Builder().add(e).addAll(iterator).build();
    }

    public static ImmutableSet copyOf(Collection collection) {
        if (collection instanceof ImmutableSet && !(collection instanceof ImmutableSortedSet)) {
            ImmutableSet immutableSet = (ImmutableSet)collection;
            if (!immutableSet.isPartialView()) {
                return immutableSet;
            }
        } else if (collection instanceof EnumSet) {
            EnumSet enumSet = EnumSet.copyOf((EnumSet)collection);
            ImmutableSet immutableSet = ImmutableEnumSet.asImmutable(enumSet);
            return immutableSet;
        }
        return ImmutableSet.copyFromCollection(collection);
    }

    private static ImmutableSet copyFromCollection(Collection collection) {
        Object[] objectArray = collection.toArray();
        switch (objectArray.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object object = objectArray[0];
                return ImmutableSet.of(object);
            }
        }
        return ImmutableSet.construct(objectArray.length, objectArray);
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator iterator();

    public static ImmutableSet$Builder builder() {
        return new ImmutableSet$Builder();
    }

    static /* synthetic */ ImmutableSet access$000(int n, Object[] objectArray) {
        return ImmutableSet.construct(n, objectArray);
    }
}

