/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Order;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Expression;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ExpressionBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Model;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PathException;

class ModelAssembler {
    private final ExpressionBuilder builder;
    private final Class type;

    public ModelAssembler(ExpressionBuilder expressionBuilder, Class clazz) {
        this.builder = expressionBuilder;
        this.type = clazz;
    }

    public void assemble(Model model, Order order) {
        this.assembleElements(model, order);
        this.assembleAttributes(model, order);
    }

    private void assembleElements(Model model, Order order) {
        for (String string : order.elements()) {
            Expression expression = this.builder.build(string);
            if (expression.isAttribute()) {
                throw new PathException("Ordered element '%s' references an attribute in %s", expression, this.type);
            }
            this.registerElements(model, expression);
        }
    }

    private void assembleAttributes(Model model, Order order) {
        for (String string : order.attributes()) {
            Expression expression = this.builder.build(string);
            if (!expression.isAttribute() && expression.isPath()) {
                throw new PathException("Ordered attribute '%s' references an element in %s", expression, this.type);
            }
            this.registerAttributes(model, expression);
        }
    }

    private void registerAttributes(Model model, Expression expression) {
        String string = expression.getPrefix();
        String string2 = expression.getFirst();
        int n = expression.getIndex();
        if (expression.isPath()) {
            Model model2 = model.register(string2, string, n);
            Expression expression2 = expression.getPath(1);
            if (model2 == null) {
                throw new PathException("Element '%s' does not exist in %s", string2, this.type);
            }
            this.registerAttributes(model2, expression2);
        } else {
            this.registerAttribute(model, expression);
        }
    }

    private void registerAttribute(Model model, Expression expression) {
        String string = expression.getFirst();
        if (string != null) {
            model.registerAttribute(string);
        }
    }

    private void registerElements(Model model, Expression expression) {
        String string = expression.getPrefix();
        String string2 = expression.getFirst();
        int n = expression.getIndex();
        if (string2 != null) {
            Model model2 = model.register(string2, string, n);
            Expression expression2 = expression.getPath(1);
            if (expression.isPath()) {
                this.registerElements(model2, expression2);
            }
        }
        this.registerElement(model, expression);
    }

    private void registerElement(Model model, Expression expression) {
        Model model2;
        String string = expression.getPrefix();
        String string2 = expression.getFirst();
        int n = expression.getIndex();
        if (n > 1 && (model2 = model.lookup(string2, n - 1)) == null) {
            throw new PathException("Ordered element '%s' in path '%s' is out of sequence for %s", string2, expression, this.type);
        }
        model.register(string2, string, n);
    }
}

