/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AllDeletedFilterReader;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.search.CheckHits;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.LuceneTestCase;

public class QueryUtils {
    static final IndexReader[] emptyReaders = new IndexReader[8];

    public static void check(Query q) {
        QueryUtils.checkHashEquals(q);
    }

    public static void checkHashEquals(Query q) {
        Query q2 = q.clone();
        QueryUtils.checkEqual(q, q2);
        Query q3 = q.clone();
        q3.setBoost(7.2179236f);
        QueryUtils.checkUnequal(q, q3);
        Query whacky = new Query(){

            public String toString(String field) {
                return "My Whacky Query";
            }
        };
        whacky.setBoost(q.getBoost());
        QueryUtils.checkUnequal(q, whacky);
        Assert.assertFalse((boolean)q.equals(null));
    }

    public static void checkEqual(Query q1, Query q2) {
        Assert.assertEquals((Object)q1, (Object)q2);
        Assert.assertEquals((int)q1.hashCode(), (int)q2.hashCode());
    }

    public static void checkUnequal(Query q1, Query q2) {
        Assert.assertFalse((String)(q1 + " equal to " + q2), (boolean)q1.equals((Object)q2));
        Assert.assertFalse((String)(q2 + " equal to " + q1), (boolean)q2.equals((Object)q1));
        Assert.assertTrue((q1.hashCode() != q2.hashCode() ? 1 : 0) != 0);
    }

    public static void checkExplanations(Query q, IndexSearcher s) throws IOException {
        CheckHits.checkExplanations(q, null, s, true);
    }

    public static void check(Random random, Query q1, IndexSearcher s) {
        QueryUtils.check(random, q1, s, true);
    }

    public static void check(Random random, Query q1, IndexSearcher s, boolean wrap) {
        try {
            QueryUtils.check(q1);
            if (s != null) {
                QueryUtils.checkFirstSkipTo(q1, s);
                QueryUtils.checkSkipTo(q1, s);
                if (wrap) {
                    QueryUtils.check(random, q1, QueryUtils.wrapUnderlyingReader(random, s, -1), false);
                    QueryUtils.check(random, q1, QueryUtils.wrapUnderlyingReader(random, s, 0), false);
                    QueryUtils.check(random, q1, QueryUtils.wrapUnderlyingReader(random, s, 1), false);
                }
                QueryUtils.checkExplanations(q1, s);
                Query q2 = q1.clone();
                QueryUtils.checkEqual(s.rewrite(q1), s.rewrite(q2));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void purgeFieldCache(IndexReader r) throws IOException {
        FieldCache.DEFAULT.purge(SlowCompositeReaderWrapper.wrap((IndexReader)r));
    }

    public static IndexSearcher wrapUnderlyingReader(Random random, IndexSearcher s, int edge) throws IOException {
        IndexReader r = s.getIndexReader();
        IndexReader[] readers = new IndexReader[]{edge < 0 ? r : emptyReaders[0], emptyReaders[0], new FCInvisibleMultiReader(edge < 0 ? emptyReaders[4] : emptyReaders[0], emptyReaders[0], 0 == edge ? r : emptyReaders[0]), 0 < edge ? emptyReaders[0] : emptyReaders[7], emptyReaders[0], new FCInvisibleMultiReader(0 < edge ? emptyReaders[0] : emptyReaders[5], emptyReaders[0], 0 < edge ? r : emptyReaders[0])};
        IndexSearcher out = LuceneTestCase.newSearcher((IndexReader)new FCInvisibleMultiReader(readers));
        out.setSimilarity(s.getSimilarity());
        return out;
    }

    private static IndexReader makeEmptyIndex(Random random, int numDocs) throws IOException {
        assert (numDocs > 0);
        MockDirectoryWrapper d = new MockDirectoryWrapper(random, (Directory)new RAMDirectory());
        IndexWriter w = new IndexWriter((Directory)d, new IndexWriterConfig(LuceneTestCase.TEST_VERSION_CURRENT, (Analyzer)new MockAnalyzer(random)));
        for (int i = 0; i < numDocs; ++i) {
            w.addDocument((Iterable)new Document());
        }
        w.forceMerge(1);
        w.commit();
        w.close();
        DirectoryReader reader = DirectoryReader.open((Directory)d);
        return new AllDeletedFilterReader((AtomicReader)LuceneTestCase.getOnlySegmentReader(reader));
    }

    public static void checkSkipTo(final Query q, final IndexSearcher s) throws IOException {
        final List readerContextArray = s.getTopReaderContext().leaves();
        if (s.createNormalizedWeight(q).scoresDocsOutOfOrder()) {
            return;
        }
        boolean skip_op = false;
        boolean next_op = true;
        int[][] orders = new int[][]{{1}, {0}, {0, 1}, {1, 0}, {0, 0, 1, 1}, {1, 1, 0, 0}, {0, 0, 0, 1, 1}};
        for (int k = 0; k < orders.length; ++k) {
            final int[] order = orders[k];
            final int[] opidx = new int[]{0};
            final int[] lastDoc = new int[]{-1};
            float maxDiff = 1.0E-5f;
            final AtomicReader[] lastReader = new AtomicReader[]{null};
            s.search(q, new Collector(){
                private Scorer sc;
                private Scorer scorer;
                private int leafPtr;

                public void setScorer(Scorer scorer) {
                    this.sc = scorer;
                }

                public void collect(int doc) throws IOException {
                    float score = this.sc.score();
                    lastDoc[0] = doc;
                    try {
                        if (this.scorer == null) {
                            Weight w = s.createNormalizedWeight(q);
                            AtomicReaderContext context = (AtomicReaderContext)readerContextArray.get(this.leafPtr);
                            this.scorer = w.scorer(context, true, false, context.reader().getLiveDocs());
                        }
                        int n = opidx[0];
                        opidx[0] = n + 1;
                        int op = order[n % order.length];
                        boolean more = op == 0 ? this.scorer.advance(this.scorer.docID() + 1) != Integer.MAX_VALUE : this.scorer.nextDoc() != Integer.MAX_VALUE;
                        int scorerDoc = this.scorer.docID();
                        float scorerScore = this.scorer.score();
                        float scorerScore2 = this.scorer.score();
                        float scoreDiff = Math.abs(score - scorerScore);
                        float scorerDiff = Math.abs(scorerScore2 - scorerScore);
                        if (!more || doc != scorerDoc || scoreDiff > 1.0E-5f || scorerDiff > 1.0E-5f) {
                            StringBuilder sbord = new StringBuilder();
                            for (int i = 0; i < order.length; ++i) {
                                sbord.append(order[i] == 0 ? " skip()" : " next()");
                            }
                            throw new RuntimeException("ERROR matching docs:\n\t" + (doc != scorerDoc ? "--> " : "") + "doc=" + doc + ", scorerDoc=" + scorerDoc + "\n\t" + (!more ? "--> " : "") + "tscorer.more=" + more + "\n\t" + (scoreDiff > 1.0E-5f ? "--> " : "") + "scorerScore=" + scorerScore + " scoreDiff=" + scoreDiff + " maxDiff=" + 1.0E-5f + "\n\t" + (scorerDiff > 1.0E-5f ? "--> " : "") + "scorerScore2=" + scorerScore2 + " scorerDiff=" + scorerDiff + "\n\thitCollector.doc=" + doc + " score=" + score + "\n\t Scorer=" + this.scorer + "\n\t Query=" + q + "  " + q.getClass().getName() + "\n\t Searcher=" + s + "\n\t Order=" + sbord + "\n\t Op=" + (op == 0 ? " skip()" : " next()"));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void setNextReader(AtomicReaderContext context) throws IOException {
                    if (lastReader[0] != null) {
                        AtomicReader previousReader = lastReader[0];
                        IndexSearcher indexSearcher = LuceneTestCase.newSearcher((IndexReader)previousReader);
                        indexSearcher.setSimilarity(s.getSimilarity());
                        Weight w = indexSearcher.createNormalizedWeight(q);
                        AtomicReaderContext ctx = (AtomicReaderContext)indexSearcher.getTopReaderContext();
                        Scorer scorer = w.scorer(ctx, true, false, ctx.reader().getLiveDocs());
                        if (scorer != null) {
                            boolean more = scorer.advance(lastDoc[0] + 1) != Integer.MAX_VALUE;
                            Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but skipTo(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
                        }
                        ++this.leafPtr;
                    }
                    lastReader[0] = context.reader();
                    assert (((AtomicReaderContext)readerContextArray.get(this.leafPtr)).reader() == context.reader());
                    this.scorer = null;
                    lastDoc[0] = -1;
                }

                public boolean acceptsDocsOutOfOrder() {
                    return true;
                }
            });
            if (lastReader[0] == null) continue;
            AtomicReader previousReader = lastReader[0];
            IndexSearcher indexSearcher = LuceneTestCase.newSearcher((IndexReader)previousReader, false);
            indexSearcher.setSimilarity(s.getSimilarity());
            Weight w = indexSearcher.createNormalizedWeight(q);
            AtomicReaderContext ctx = previousReader.getContext();
            Scorer scorer = w.scorer(ctx, true, false, ctx.reader().getLiveDocs());
            if (scorer == null) continue;
            boolean more = scorer.advance(lastDoc[0] + 1) != Integer.MAX_VALUE;
            Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but skipTo(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
        }
    }

    public static void checkFirstSkipTo(final Query q, final IndexSearcher s) throws IOException {
        float maxDiff = 0.001f;
        final int[] lastDoc = new int[]{-1};
        final AtomicReader[] lastReader = new AtomicReader[]{null};
        final List context = s.getTopReaderContext().leaves();
        s.search(q, new Collector(){
            private Scorer scorer;
            private int leafPtr;
            private Bits liveDocs;

            public void setScorer(Scorer scorer) {
                this.scorer = scorer;
            }

            public void collect(int doc) throws IOException {
                float score = this.scorer.score();
                try {
                    long startMS = System.currentTimeMillis();
                    for (int i = lastDoc[0] + 1; i <= doc; ++i) {
                        Weight w = s.createNormalizedWeight(q);
                        Scorer scorer = w.scorer((AtomicReaderContext)context.get(this.leafPtr), true, false, this.liveDocs);
                        Assert.assertTrue((String)("query collected " + doc + " but skipTo(" + i + ") says no more docs!"), (scorer.advance(i) != Integer.MAX_VALUE ? 1 : 0) != 0);
                        Assert.assertEquals((String)("query collected " + doc + " but skipTo(" + i + ") got to " + scorer.docID()), (int)doc, (int)scorer.docID());
                        float skipToScore = scorer.score();
                        Assert.assertEquals((String)("unstable skipTo(" + i + ") score!"), (float)skipToScore, (float)scorer.score(), (float)0.001f);
                        Assert.assertEquals((String)("query assigned doc " + doc + " a score of <" + score + "> but skipTo(" + i + ") has <" + skipToScore + ">!"), (float)score, (float)skipToScore, (float)0.001f);
                        if (i >= doc || System.currentTimeMillis() - startMS <= 5L) continue;
                        i = doc - 1;
                    }
                    lastDoc[0] = doc;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void setNextReader(AtomicReaderContext context2) throws IOException {
                if (lastReader[0] != null) {
                    AtomicReader previousReader = lastReader[0];
                    IndexSearcher indexSearcher = LuceneTestCase.newSearcher((IndexReader)previousReader);
                    indexSearcher.setSimilarity(s.getSimilarity());
                    Weight w = indexSearcher.createNormalizedWeight(q);
                    Scorer scorer = w.scorer((AtomicReaderContext)indexSearcher.getTopReaderContext(), true, false, previousReader.getLiveDocs());
                    if (scorer != null) {
                        boolean more = scorer.advance(lastDoc[0] + 1) != Integer.MAX_VALUE;
                        Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but skipTo(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
                    }
                    ++this.leafPtr;
                }
                lastReader[0] = context2.reader();
                lastDoc[0] = -1;
                this.liveDocs = context2.reader().getLiveDocs();
            }

            public boolean acceptsDocsOutOfOrder() {
                return false;
            }
        });
        if (lastReader[0] != null) {
            AtomicReader previousReader = lastReader[0];
            IndexSearcher indexSearcher = LuceneTestCase.newSearcher((IndexReader)previousReader);
            indexSearcher.setSimilarity(s.getSimilarity());
            Weight w = indexSearcher.createNormalizedWeight(q);
            Scorer scorer = w.scorer((AtomicReaderContext)indexSearcher.getTopReaderContext(), true, false, previousReader.getLiveDocs());
            if (scorer != null) {
                boolean more = scorer.advance(lastDoc[0] + 1) != Integer.MAX_VALUE;
                Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but skipTo(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
            }
        }
    }

    static {
        try {
            QueryUtils.emptyReaders[0] = new MultiReader(new IndexReader[0]);
            QueryUtils.emptyReaders[4] = QueryUtils.makeEmptyIndex(new Random(0L), 4);
            QueryUtils.emptyReaders[5] = QueryUtils.makeEmptyIndex(new Random(0L), 5);
            QueryUtils.emptyReaders[7] = QueryUtils.makeEmptyIndex(new Random(0L), 7);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class FCInvisibleMultiReader
    extends MultiReader {
        private final Object cacheKey = new Object();

        public FCInvisibleMultiReader(IndexReader ... readers) {
            super(readers);
        }

        public Object getCoreCacheKey() {
            return this.cacheKey;
        }

        public Object getCombinedCoreAndDeletesKey() {
            return this.cacheKey;
        }
    }
}

