/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer;

import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.decomposer.EigenStatus;
import org.apache.mahout.math.decomposer.SingularVectorVerifier;

public class SimpleEigenVerifier
implements SingularVectorVerifier {
    @Override
    public EigenStatus verify(VectorIterable corpus, Vector vector) {
        double cosAngle;
        double eigenValue;
        Vector resultantVector = corpus.timesSquared(vector);
        double newNorm = resultantVector.norm(2.0);
        double oldNorm = vector.norm(2.0);
        if (newNorm > 0.0 && oldNorm > 0.0) {
            eigenValue = newNorm / oldNorm;
            cosAngle = resultantVector.dot(vector) / newNorm * oldNorm;
        } else {
            eigenValue = 1.0;
            cosAngle = 0.0;
        }
        return new EigenStatus(eigenValue, cosAngle, false);
    }
}

