/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.util.MapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlayPDF {
    private static final Log LOG = LogFactory.getLog(BaseParser.class);
    private static final String XOBJECT_PREFIX = "OL";
    private LayoutPage defaultOverlayPage;
    private LayoutPage firstPageOverlayPage;
    private LayoutPage lastPageOverlayPage;
    private LayoutPage oddPageOverlayPage;
    private LayoutPage evenPageOverlayPage;
    private static Map<Integer, PDDocument> specificPageOverlay = new HashMap<Integer, PDDocument>();
    private static Map<Integer, LayoutPage> specificPageOverlayPage = new HashMap<Integer, LayoutPage>();
    private static Position overlayPosition = Position.BACKGROUND;
    private static boolean useNonSeqParser = false;
    private static String inputFile = null;
    private static String outputFile = null;
    private static String defaultOverlayFile = null;
    private static String firstPageOverlayFile = null;
    private static String lastPageOverlayFile = null;
    private static String oddPageOverlayFile = null;
    private static String evenPageOverlayFile = null;
    private static final String POSITION = "-position";
    private static final String ODD = "-odd";
    private static final String EVEN = "-even";
    private static final String FIRST = "-first";
    private static final String LAST = "-last";
    private static final String PAGE = "-page";
    private static final String NONSEQ = "-nonSeq";

    public static void main(String[] args) throws Exception {
        HashMap<Integer, String> specificPageOverlayFile = new HashMap<Integer, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (i == 0) {
                inputFile = arg;
                continue;
            }
            if (i == args.length - 1) {
                outputFile = arg;
                continue;
            }
            if (arg.equals(POSITION) && i + 1 < args.length) {
                if (Position.FOREGROUND.toString().equalsIgnoreCase(args[i + 1].trim())) {
                    overlayPosition = Position.FOREGROUND;
                } else if (Position.BACKGROUND.toString().equalsIgnoreCase(args[i + 1].trim())) {
                    overlayPosition = Position.BACKGROUND;
                } else {
                    OverlayPDF.usage();
                }
                ++i;
                continue;
            }
            if (arg.equals(ODD) && i + 1 < args.length) {
                oddPageOverlayFile = args[i + 1].trim();
                ++i;
                continue;
            }
            if (arg.equals(EVEN) && i + 1 < args.length) {
                evenPageOverlayFile = args[i + 1].trim();
                ++i;
                continue;
            }
            if (arg.equals(FIRST) && i + 1 < args.length) {
                firstPageOverlayFile = args[i + 1].trim();
                ++i;
                continue;
            }
            if (arg.equals(LAST) && i + 1 < args.length) {
                lastPageOverlayFile = args[i + 1].trim();
                ++i;
                continue;
            }
            if (arg.equals(PAGE) && i + 2 < args.length && OverlayPDF.isInteger(args[i + 1].trim())) {
                specificPageOverlayFile.put(Integer.parseInt(args[i + 1].trim()), args[i + 2].trim());
                i += 2;
                continue;
            }
            if (args[i].equals(NONSEQ)) {
                useNonSeqParser = true;
                continue;
            }
            if (defaultOverlayFile == null) {
                defaultOverlayFile = arg;
                continue;
            }
            OverlayPDF.usage();
        }
        if (inputFile == null || outputFile == null) {
            OverlayPDF.usage();
        }
        try {
            OverlayPDF overlayer = new OverlayPDF();
            overlayer.overlay(specificPageOverlayFile);
        }
        catch (Exception e) {
            LOG.error((Object)("Overlay failed: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    private static void usage() {
        StringBuilder message = new StringBuilder();
        message.append("usage: java -jar pdfbox-app-x.y.z.jar OverlayPDF <input.pdf> [OPTIONS] <output.pdf>\n");
        message.append("  <input.pdf>                                        input file\n");
        message.append("  <defaultOverlay.pdf>                               default overlay file\n");
        message.append("  -odd <oddPageOverlay.pdf>                          overlay file used for odd pages\n");
        message.append("  -even <evenPageOverlay.pdf>                        overlay file used for even pages\n");
        message.append("  -first <firstPageOverlay.pdf>                      overlay file used for the first page\n");
        message.append("  -last <lastPageOverlay.pdf>                        overlay file used for the last page\n");
        message.append("  -page <pageNumber> <specificPageOverlay.pdf>       overlay file used for the given page number, may occur more than once\n");
        message.append("  -position foreground|background                    where to put the overlay file: foreground or background\n");
        message.append("  -nonSeq                                            enables the new non-sequential parser\n");
        message.append("  <output.pdf>                                       output file\n");
        System.err.println(message.toString());
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overlay(Map<Integer, String> specificPageOverlayFile) throws IOException, COSVisitorException {
        PDDocument evenPageOverlay;
        PDDocument oddPageOverlay;
        PDDocument lastPageOverlay;
        PDDocument firstPageOverlay;
        PDDocument defaultOverlay;
        block21: {
            PDDocument sourcePDFDocument = null;
            defaultOverlay = null;
            firstPageOverlay = null;
            lastPageOverlay = null;
            oddPageOverlay = null;
            evenPageOverlay = null;
            try {
                sourcePDFDocument = PDDocument.load(inputFile);
                if (defaultOverlayFile != null) {
                    defaultOverlay = useNonSeqParser ? PDDocument.loadNonSeq(new File(defaultOverlayFile), null) : PDDocument.load(defaultOverlayFile);
                    this.defaultOverlayPage = this.getLayoutPage(defaultOverlay);
                }
                if (firstPageOverlayFile != null) {
                    firstPageOverlay = useNonSeqParser ? PDDocument.loadNonSeq(new File(firstPageOverlayFile), null) : PDDocument.load(firstPageOverlayFile);
                    this.firstPageOverlayPage = this.getLayoutPage(firstPageOverlay);
                }
                if (lastPageOverlayFile != null) {
                    lastPageOverlay = useNonSeqParser ? PDDocument.loadNonSeq(new File(lastPageOverlayFile), null) : PDDocument.load(lastPageOverlayFile);
                    this.lastPageOverlayPage = this.getLayoutPage(lastPageOverlay);
                }
                if (oddPageOverlayFile != null) {
                    oddPageOverlay = useNonSeqParser ? PDDocument.loadNonSeq(new File(oddPageOverlayFile), null) : PDDocument.load(oddPageOverlayFile);
                    this.oddPageOverlayPage = this.getLayoutPage(oddPageOverlay);
                }
                if (evenPageOverlayFile != null) {
                    evenPageOverlay = useNonSeqParser ? PDDocument.loadNonSeq(new File(evenPageOverlayFile), null) : PDDocument.load(evenPageOverlayFile);
                    this.evenPageOverlayPage = this.getLayoutPage(evenPageOverlay);
                }
                for (Map.Entry<Integer, String> e : specificPageOverlayFile.entrySet()) {
                    PDDocument doc = null;
                    doc = useNonSeqParser ? PDDocument.loadNonSeq(new File(e.getValue()), null) : PDDocument.load(e.getValue());
                    specificPageOverlay.put(e.getKey(), doc);
                    specificPageOverlayPage.put(e.getKey(), this.getLayoutPage(doc));
                }
                PDDocumentCatalog pdfCatalog = sourcePDFDocument.getDocumentCatalog();
                this.processPages(pdfCatalog.getAllPages());
                sourcePDFDocument.save(outputFile);
                Object var12_11 = null;
                if (sourcePDFDocument == null) break block21;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (sourcePDFDocument != null) {
                    sourcePDFDocument.close();
                }
                if (defaultOverlay != null) {
                    defaultOverlay.close();
                }
                if (firstPageOverlay != null) {
                    firstPageOverlay.close();
                }
                if (lastPageOverlay != null) {
                    lastPageOverlay.close();
                }
                if (oddPageOverlay != null) {
                    oddPageOverlay.close();
                }
                if (evenPageOverlay != null) {
                    evenPageOverlay.close();
                }
                for (Map.Entry<Integer, PDDocument> e : specificPageOverlay.entrySet()) {
                    e.getValue().close();
                }
                specificPageOverlay.clear();
                specificPageOverlayPage.clear();
                throw throwable;
            }
            sourcePDFDocument.close();
        }
        if (defaultOverlay != null) {
            defaultOverlay.close();
        }
        if (firstPageOverlay != null) {
            firstPageOverlay.close();
        }
        if (lastPageOverlay != null) {
            lastPageOverlay.close();
        }
        if (oddPageOverlay != null) {
            oddPageOverlay.close();
        }
        if (evenPageOverlay != null) {
            evenPageOverlay.close();
        }
        for (Map.Entry<Integer, PDDocument> e : specificPageOverlay.entrySet()) {
            e.getValue().close();
        }
        {
        }
        specificPageOverlay.clear();
        specificPageOverlayPage.clear();
    }

    private static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private LayoutPage getLayoutPage(PDDocument doc) throws IOException {
        PDDocumentCatalog catalog = doc.getDocumentCatalog();
        PDPage page = (PDPage)catalog.getAllPages().get(0);
        COSBase contents = page.getCOSDictionary().getDictionaryObject(COSName.CONTENTS);
        PDResources resources = page.findResources();
        if (resources == null) {
            resources = new PDResources();
        }
        return new LayoutPage(page.getMediaBox(), this.createContentStream(contents), resources.getCOSDictionary());
    }

    private COSStream createContentStream(COSBase contents) throws IOException {
        List<COSStream> contentStreams = this.createContentStreamList(contents);
        COSStream concatStream = new COSStream(new RandomAccessBuffer());
        OutputStream out = concatStream.createUnfilteredStream();
        for (COSStream contentStream : contentStreams) {
            int n;
            InputStream in = contentStream.getUnfilteredStream();
            byte[] buf = new byte[2048];
            while ((n = in.read(buf)) > 0) {
                out.write(buf, 0, n);
            }
            out.flush();
        }
        out.close();
        concatStream.setFilters(COSName.FLATE_DECODE);
        return concatStream;
    }

    private List<COSStream> createContentStreamList(COSBase contents) throws IOException {
        ArrayList<COSStream> contentStreams = new ArrayList<COSStream>();
        if (contents instanceof COSStream) {
            contentStreams.add((COSStream)contents);
        } else if (contents instanceof COSArray) {
            for (COSBase item : (COSArray)contents) {
                contentStreams.addAll(this.createContentStreamList(item));
            }
        } else if (contents instanceof COSObject) {
            contentStreams.addAll(this.createContentStreamList(((COSObject)contents).getObject()));
        } else {
            throw new IOException("Contents are unknown type:" + contents.getClass().getName());
        }
        return contentStreams;
    }

    private void processPages(List<?> pages) throws IOException {
        int pageCount = 0;
        for (Object pageObject : pages) {
            PDPage page = (PDPage)pageObject;
            COSDictionary pageDictionary = page.getCOSDictionary();
            COSBase contents = pageDictionary.getDictionaryObject(COSName.CONTENTS);
            COSArray contentArray = new COSArray();
            switch (overlayPosition) {
                case FOREGROUND: {
                    contentArray.add(this.createStream("q\n"));
                    if (contents instanceof COSStream) {
                        contentArray.add(contents);
                    } else if (contents instanceof COSArray) {
                        contentArray.addAll((COSArray)contents);
                    } else {
                        throw new IOException("Unknown content type:" + contents.getClass().getName());
                    }
                    contentArray.add(this.createStream("Q\n"));
                    this.overlayPage(contentArray, page, pageCount + 1, pages.size());
                    break;
                }
                case BACKGROUND: {
                    this.overlayPage(contentArray, page, pageCount + 1, pages.size());
                    if (contents instanceof COSStream) {
                        contentArray.add(contents);
                        break;
                    }
                    if (contents instanceof COSArray) {
                        contentArray.addAll((COSArray)contents);
                        break;
                    }
                    throw new IOException("Unknown content type:" + contents.getClass().getName());
                }
                default: {
                    throw new IOException("Unknown type of position:" + (Object)((Object)overlayPosition));
                }
            }
            pageDictionary.setItem(COSName.CONTENTS, (COSBase)contentArray);
            ++pageCount;
        }
    }

    private void overlayPage(COSArray array, PDPage page, int pageNumber, int numberOfPages) throws IOException {
        LayoutPage layoutPage = null;
        if (specificPageOverlayPage.containsKey(pageNumber)) {
            layoutPage = specificPageOverlayPage.get(pageNumber);
        } else if (pageNumber == 1 && this.firstPageOverlayPage != null) {
            layoutPage = this.firstPageOverlayPage;
        } else if (pageNumber == numberOfPages && this.lastPageOverlayPage != null) {
            layoutPage = this.lastPageOverlayPage;
        } else if (pageNumber % 2 == 1 && this.oddPageOverlayPage != null) {
            layoutPage = this.oddPageOverlayPage;
        } else if (pageNumber % 2 == 0 && this.evenPageOverlayPage != null) {
            layoutPage = this.evenPageOverlayPage;
        } else if (this.defaultOverlayPage != null) {
            layoutPage = this.defaultOverlayPage;
        }
        if (layoutPage != null) {
            PDResources resources = page.findResources();
            if (resources == null) {
                resources = new PDResources();
                page.setResources(resources);
            }
            String xObjectId = this.createOverlayXObject(page, layoutPage, layoutPage.overlayContentStream);
            array.add(this.createOverlayStream(page, layoutPage, xObjectId));
        }
    }

    private String createOverlayXObject(PDPage page, LayoutPage layoutPage, COSStream contentStream) {
        PDResources resources = page.findResources();
        COSDictionary dict = (COSDictionary)resources.getCOSDictionary().getDictionaryObject(COSName.XOBJECT);
        if (dict == null) {
            dict = new COSDictionary();
            resources.getCOSDictionary().setItem(COSName.XOBJECT, (COSBase)dict);
        }
        String xObjectId = MapUtil.getNextUniqueKey(resources.getXObjects(), XOBJECT_PREFIX);
        COSStream xobj = contentStream;
        xobj.setItem(COSName.RESOURCES, (COSBase)layoutPage.overlayResources);
        xobj.setItem(COSName.TYPE, (COSBase)COSName.XOBJECT);
        xobj.setItem(COSName.SUBTYPE, (COSBase)COSName.FORM);
        xobj.setInt(COSName.FORMTYPE, 1);
        COSArray matrix = new COSArray();
        matrix.add(COSInteger.get(1L));
        matrix.add(COSInteger.get(0L));
        matrix.add(COSInteger.get(0L));
        matrix.add(COSInteger.get(1L));
        matrix.add(COSInteger.get(0L));
        matrix.add(COSInteger.get(0L));
        xobj.setItem(COSName.MATRIX, (COSBase)matrix);
        COSArray bbox = new COSArray();
        bbox.add(COSInteger.get(0L));
        bbox.add(COSInteger.get(0L));
        bbox.add(COSInteger.get((int)layoutPage.overlayMediaBox.getWidth()));
        bbox.add(COSInteger.get((int)layoutPage.overlayMediaBox.getHeight()));
        xobj.setItem(COSName.BBOX, (COSBase)bbox);
        dict.setItem(xObjectId, (COSBase)xobj);
        return xObjectId;
    }

    private COSStream createOverlayStream(PDPage page, LayoutPage layoutPage, String xObjectId) throws IOException {
        PDRectangle pageMediaBox = page.getMediaBox();
        float scale = 1.0f;
        float hShift = (pageMediaBox.getWidth() - layoutPage.overlayMediaBox.getWidth()) / 2.0f;
        float vShift = (pageMediaBox.getHeight() - layoutPage.overlayMediaBox.getHeight()) / 2.0f;
        return this.createStream("q\nq " + scale + " 0 0 " + scale + " " + hShift + " " + vShift + " cm /" + xObjectId + " Do Q\nQ\n");
    }

    private COSStream createStream(String content) throws IOException {
        COSStream stream = new COSStream(new RandomAccessBuffer());
        OutputStream out = stream.createUnfilteredStream();
        out.write(content.getBytes("ISO-8859-1"));
        out.close();
        stream.setFilters(COSName.FLATE_DECODE);
        return stream;
    }

    private static class LayoutPage {
        private final PDRectangle overlayMediaBox;
        private final COSStream overlayContentStream;
        private final COSDictionary overlayResources;

        private LayoutPage(PDRectangle mediaBox, COSStream contentStream, COSDictionary resources) {
            this.overlayMediaBox = mediaBox;
            this.overlayContentStream = contentStream;
            this.overlayResources = resources;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Position {
        FOREGROUND,
        BACKGROUND;

    }
}

